---
name: linkedin-lead-gen
description: Search for, research, and verify non-tech founders on LinkedIn to identify high-value prospects for technology services (Web Dev, ERP, CRM, App Dev, SEO, AI). Generates professional PDF reports. Use when asked to find potential clients or leads.
---

# LinkedIn Lead Generation & Research

This skill provides a structured workflow for identifying and verifying high-quality business leads.

## Workflow

1.  **Target Selection**: Define industries that need digital transformation but aren't tech-native (e.g., Textile, Manufacturing, Real Estate, Healthcare, Energy, D2C Brands).
2.  **LinkedIn Search**:
    -   Use `browser` tool to search LinkedIn: `https://www.linkedin.com/search/results/people/?keywords=founder+CEO+[Industry]+[Location]`
    -   Filter for 2nd-degree connections for easier outreach.
3.  **Strict Filtering**:
    -   EXCLUDE any founder already in the IT, Software, or Digital Marketing space.
    -   EXCLUDE founders whose profiles indicate they already have a strong internal tech team.
4.  **Deep Research**:
    -   Visit each candidate's LinkedIn profile.
    -   Find their company website URL.
    -   Visit the company website using `web_fetch` or `browser`.
5.  **Gap Analysis**:
    -   Analyze the website for: Speed, Mobile Responsiveness, SEO, E-commerce capabilities, and overall modern aesthetic.
    -   Identify specific needs (e.g., "No mobile app", "Outdated UI", "No CRM/ERP integration").
6.  **Reporting**:
    -   Compile a list of 10 qualified prospects.
    -   Include: Name, LinkedIn URL, Company, Website Status, Specific Needs, and a "Pitch Idea".
    -   Generate a professional HTML-based PDF report.

## Tools to Use

-   **browser**: For LinkedIn search and profile viewing.
-   **web_fetch**: For quick website analysis.
-   **write**: To create the HTML template for the PDF.

## PDF Template (HTML Structure)

Use the following CSS principles for a premium feel:
-   LinkedIn Blue (`#0077b5`) for headers.
-   Clean, modern typography (sans-serif).
-   Priority badges (High/Medium/Low).
-   Structured grids for easy scanning.

## Outreach Principles

-   **Personalized**: Reference something specific from their profile or website.
-   **Problem-First**: Focus on the gap identified (e.g., "Your brand is growing on social, but your website is broken").
-   **Local Advantage**: If in the same city (Surat), emphasize face-to-face consultation.
