---
name: linkedin-autopilot
description: Your agent builds your LinkedIn presence while you sleep. Schedule posts, auto-engage with target accounts, run personalized DM sequences, and never miss an engagement opportunity. Handles connection requests, profile visiting campaigns, post engagement, and follow-up sequences with safety throttling and human-like behavior patterns. Configure your targets, define engagement rules, and let your agent network 24/7. Use when setting up LinkedIn automation, managing posting schedules, running engagement campaigns, or building agent-driven LinkedIn lead generation workflows.
metadata:
  clawdbot:
    emoji: "🤝"
    requires:
      browser: true
      env:
        - LINKEDIN_EMAIL
        - LINKEDIN_PASSWORD
---

# LinkedIn Autopilot — Your Agent Networks 24/7

**You sleep. Your LinkedIn thrives.**

LinkedIn Autopilot turns your agent into a 24/7 LinkedIn manager. It schedules posts, auto-engages with target accounts, runs personalized DM sequences, and builds your network while you focus on actual work. No more "I should post more" guilt. No more missing engagement windows. No more manual connection request grinding.

**What makes it different:** This isn't a dumb bot — it's your agent using real browser automation with human-like behavior patterns. Random delays, natural engagement patterns, safety throttling, and intelligent targeting. Multi-day sequences with conditional logic. State tracking across sessions. Full reporting on what worked.

## The Pain Points This Solves

❌ **"I spend 2 hours/day on LinkedIn and have nothing to show for it"**  
✅ Your agent handles engagement, DMs, and connection building automatically

❌ **"I post inconsistently and my reach is dying"**  
✅ Scheduled posts with optimal timing — your agent never forgets

❌ **"I see opportunities to engage but I'm too busy"**  
✅ Auto-engage on target accounts' posts with personalized comments

❌ **"Follow-up sequences are tedious and I drop leads"**  
✅ Multi-step DM sequences with conditional logic — your agent follows up

❌ **"I want to build my network but connection requests feel spammy"**  
✅ Targeted connection campaigns with personalized notes and safety limits

## Setup

1. Run `scripts/setup.sh` to initialize config and data directories
2. Edit `~/.config/linkedin-autopilot/config.json` with targets, sequences, and posting schedule
3. Store LinkedIn credentials in `~/.clawdbot/secrets.env`:
   ```bash
   LINKEDIN_EMAIL=your-email@example.com
   LINKEDIN_PASSWORD=your-password
   ```
4. Test with: `scripts/engage.sh --dry-run`

## Config

Config lives at `~/.config/linkedin-autopilot/config.json`. See `config.example.json` for full schema.

Key sections:
- **identity** — Your LinkedIn profile info (for personalization)
- **targets** — Who/what to engage with (companies, people, keywords)
- **posting** — Schedule, content queue, optimal times
- **engagement** — Auto-like/comment rules, target post patterns
- **outreach** — Connection request campaigns, DM sequences
- **safety** — Rate limits, delays, warmup period, blackout windows

## Scripts

| Script | Purpose |
|--------|---------|
| `scripts/setup.sh` | Initialize config and data directories |
| `scripts/post.sh` | Post scheduled content from queue |
| `scripts/engage.sh` | Auto-engage on target posts (like, comment, share) |
| `scripts/dm-sequence.sh` | Manage DM sequences (send, follow-up, track) |
| `scripts/connect.sh` | Send connection requests to target profiles |
| `scripts/report.sh` | Generate analytics report (engagement, growth, conversions) |

All scripts support `--dry-run` for testing without actually posting/engaging.

## Posting Workflow

Run `scripts/post.sh` on schedule (cron daily at optimal times). The script:
1. Checks posting queue in config
2. Verifies timing (respects blackout windows, rate limits)
3. Logs into LinkedIn via browser automation
4. Posts content with configured formatting
5. Tracks post performance
6. Updates queue state

**Post queue example:**
```json
"posts": [
  {
    "content": "5 lessons from building AI agents in production:\n\n1. ...",
    "scheduled_time": "2024-01-28T09:00:00Z",
    "status": "pending",
    "media": null
  }
]
```

## Engagement Workflow

Run `scripts/engage.sh` 3-4x daily. The script:
1. Searches for posts matching target criteria (keywords, accounts, hashtags)
2. Scores relevance (content match, author influence, engagement level)
3. Engages with top posts (like, thoughtful comment, or share)
4. Tracks engagement to avoid repeats
5. Respects rate limits (20-30 engagements per run)

**Target patterns:**
- Posts from specific companies/people
- Posts with keywords/hashtags
- Posts in your feed from connections
- Trending posts in your industry

**Engagement types:**
- **Like:** Quick signal, low friction
- **Comment:** Generated from templates + post context (not spammy)
- **Share:** With your take/commentary added

## DM Sequence Workflow

Run `scripts/dm-sequence.sh` daily. The script:
1. Checks active sequences for people at each stage
2. Sends next message in sequence (respects delays)
3. Detects replies and advances/pauses accordingly
4. Handles conditional branching (replied vs not replied)
5. Reports on conversion rates

**Sequence example:**
```json
{
  "name": "consulting-intro",
  "trigger": "new_connection",
  "steps": [
    {
      "delay_hours": 24,
      "message": "Hey {first_name}! Thanks for connecting. I help {title}s with {pain_point}. Are you currently working on anything in this space?",
      "condition": null
    },
    {
      "delay_hours": 72,
      "message": "Following up — I saw your post about {topic}. Would love to chat about {offering}. Free for a quick call this week?",
      "condition": "no_reply"
    }
  ]
}
```

## Connection Request Workflow

Run `scripts/connect.sh` weekly (not daily — LinkedIn limits this). The script:
1. Searches for target profiles (job titles, companies, keywords)
2. Filters out existing connections and pending requests
3. Generates personalized connection notes
4. Sends requests with safety throttling (20-30/week max)
5. Tracks acceptance rate

**Target criteria:**
```json
"connection_targets": [
  {
    "query": "AI consultant OR automation specialist",
    "companies": ["Microsoft", "Google", "OpenAI"],
    "exclude_titles": ["Recruiter"],
    "note_template": "Hey {first_name}, I'm building AI tools for {industry} and saw your work at {company}. Would love to connect!"
  }
]
```

## Safety & Rate Limits

LinkedIn Autopilot follows conservative rate limits to avoid account flags:

| Action | Limit | Timing |
|--------|-------|--------|
| **Posts** | 1-2/day | Optimal hours (9am-11am, 2pm-4pm) |
| **Engagements** | 80-100/day | Spread across 3-4 runs |
| **Connection Requests** | 20-30/week | Gradual warmup over first 2 weeks |
| **DMs** | 30-50/day | Random delays 5-15min between sends |
| **Profile Views** | 50-80/day | Natural browsing pattern |

**Warmup Period:** First 2 weeks run at 50% capacity to establish normal behavior pattern.

**Blackout Windows:** No activity during nights/weekends (configurable).

**Random Delays:** 3-8 seconds between actions, 5-15 minutes between campaigns.

**Human-Like Patterns:** Varied engagement times, occasional skips, natural language variance.

## State Tracking

All activity is logged and tracked:

```
~/.config/linkedin-autopilot/
├── config.json              # User configuration
├── posts-queue.json         # Scheduled posts
├── engagement-history.json  # Posts engaged with (dedup)
├── dm-sequences.json        # Active DM threads
├── connections.json         # Connection requests + status
├── analytics.json           # Performance metrics
└── activity-log.json        # Full audit trail
```

## Reporting

`scripts/report.sh` generates performance reports:

**Weekly Summary:**
- Posts published (reach, engagement rate)
- Engagements performed (breakdown by type)
- Connection requests (sent, accepted, pending)
- DM sequences (active, replied, converted)
- Growth metrics (followers, connections, profile views)

**Lead Conversion Tracking:**
- DM replies → qualified leads
- Connection acceptances → engaged conversations
- Post engagement → inbound interest

## Example Workflows

### 1. Thought Leader Building
- Post 1x/day on schedule (industry insights, lessons learned)
- Auto-engage with 20-30 posts daily from influencers in your space
- Share top posts with your commentary
- Track which content types drive the most profile views

### 2. Outbound Lead Gen
- Connect with 20-30 target profiles weekly (ICP: CTOs at Series A startups)
- Run DM sequence on new connections (intro → value prop → call booking)
- Auto-engage with prospects' posts before sending sequence
- Report on reply rate and meeting bookings

### 3. Network Maintenance
- Like posts from existing connections (stay top of mind)
- Comment thoughtfully on key accounts' updates
- Share relevant content to your feed
- Periodic check-ins via DM (birthday, work anniversary, post milestone)

## LinkedIn TOS Compliance

**Important:** LinkedIn's ToS prohibits automation. This tool is designed for:
1. **Personal use** with human oversight (you review/approve actions)
2. **Agent-assisted workflows** (agent suggests, human approves)
3. **Batch scheduling** (compose in bulk, post on schedule)

**Recommended approach:**
- Use `--dry-run` mode to preview actions
- Review queued posts/messages before enabling auto-send
- Set conservative rate limits
- Monitor for account warnings
- Always have a human in the loop for sensitive actions

This tool is provided as-is for educational purposes. Use responsibly.

## Data Files

```
~/.config/linkedin-autopilot/
├── config.json              # Main configuration
├── posts-queue.json         # Scheduled content
├── engagement-history.json  # Activity dedup
├── dm-sequences.json        # Active conversations
├── connections.json         # Network building state
├── analytics.json           # Performance tracking
└── activity-log.json        # Full audit trail
```

## Browser Automation

Uses Clawdbot's built-in browser control:
- Snapshot → Act → Verify pattern
- Handles login, 2FA prompts, session management
- Retries on rate limit detection
- Graceful handling of LinkedIn UI changes

## Advanced Features

**A/B Testing:** Test post variants, measure which performs better

**Smart Scheduling:** ML-based optimal posting time suggestion

**Reply Detection:** Pauses DM sequences when prospect replies

**Sentiment Analysis:** Adjusts engagement strategy based on post sentiment

**Network Mapping:** Tracks who engages with your content (potential advocates)

## Troubleshooting

**"LinkedIn security check triggered"**  
→ Reduce rate limits in config, extend delays, complete security verification manually

**"Posts not publishing"**  
→ Check `activity-log.json` for errors, verify LinkedIn session still valid

**"DM sequences not advancing"**  
→ Verify reply detection is working, check conversation state in `dm-sequences.json`

**"Connection requests rejected frequently"**  
→ Improve note personalization, target better ICP matches, reduce volume

## Contributing

Want to add features? See `references/linkedin-api.md` for browser automation patterns and `references/sequence-engine.md` for DM workflow logic.

---

**Remember:** Your agent is a force multiplier, not a replacement for authentic networking. Use it to handle the tedious parts so you can focus on the conversations that matter.
