# LinkedIn Content Strategy Guide

## Post Formats That Work

### 1. The Hook Mastery

First line is everything. LinkedIn truncates after ~140 chars.

**Strong hooks:**
- "I got fired yesterday." (shock)
- "Stop doing [common practice]." (contrarian)
- "The best advice I ignored for 5 years:" (curiosity)
- "This one skill made me $X:" (value)
- "Unpopular opinion:" (debate trigger)

**Weak hooks:**
- "I'm excited to announce..." (corporate)
- "Happy to share..." (generic)
- "Check out this article..." (no value)

### 2. Post Structure

**The Line Break Formula:**
```
Hook line (grab attention)

Short paragraph (context)

• Bullet point 1
• Bullet point 2  
• Bullet point 3

One-liner insight

Call to action or question
```

**Character counts:**
- Ideal post: 1,200-1,500 characters
- Max before "see more": ~140 characters
- Max total: 3,000 characters

### 3. Best Posting Times (UTC)

| Region | Best Times | Best Days |
|--------|-----------|-----------|
| US East | 12:00-14:00 | Tue-Thu |
| US West | 15:00-17:00 | Tue-Thu |
| Europe | 07:00-09:00 | Tue-Wed |
| Asia | 00:00-02:00 | Mon-Wed |

General rule: Post when your audience starts their workday.

### 4. Content Pillars

Choose 3-4 pillars and rotate:

1. **Educational** - Tips, how-tos, frameworks
2. **Personal Stories** - Failures, lessons, wins
3. **Industry Insights** - Trends, analysis, predictions
4. **Engagement Posts** - Questions, polls, debates

Example rotation:
- Monday: Educational
- Wednesday: Personal Story
- Friday: Engagement/Question

### 5. Hashtag Strategy

**Rules:**
- Use 3-5 hashtags
- Place at END of post (not inline)
- Mix reach levels:
  - 1 broad (#leadership - 10M+ followers)
  - 2 medium (#startups - 1M followers)
  - 1-2 niche (#saasfounder - 50K followers)

**Top performing hashtags (2026):**
- #leadership #management #productivity
- #ai #technology #innovation
- #startup #entrepreneur #founder
- #career #hiring #jobsearch
- #marketing #sales #growth

### 6. Content That Gets Shared

**High share triggers:**
- "Save this for later" (utility)
- Controversial takes (debate)
- Data/stats visualized (credibility)
- Templates/frameworks (practical)
- Inspirational stories (emotional)

### 7. The 4-1-1 Rule

For every 6 posts:
- 4 educational/value posts
- 1 soft promotion (case study, achievement)
- 1 hard promotion (product, service, hiring)

Never go full promo. Value first, always.

## Engagement Multipliers

### Reply to Every Comment

Replies within 1 hour = 2x reach.
Ask follow-up questions to keep threads going.

### Tag Strategically

- Tag 1-2 people max
- Only tag if genuinely relevant
- "cc @person who wrote about this"

### Cross-Promote

- Share LinkedIn posts to Twitter/X
- Repurpose top posts into threads
- Turn comments into new posts
