---
name: linkedin-authority
version: 1.0.0
description: Build genuine LinkedIn thought leadership for any professional or business. Long-form posts, articles, speaker positioning, B2B outreach templates, and a proven content framework to grow authority, inbound leads, and speaking opportunities.
tags: [linkedin, thought-leadership, b2b, personal-brand, content-marketing, networking, speaking]
author: contentai-suite
license: MIT
---

# LinkedIn Authority — Universal Thought Leadership System

## What This Skill Does

Creates LinkedIn content that builds real authority — not empty engagement bait. Designed for professionals, entrepreneurs, coaches, and B2B businesses who want to attract clients, speaking gigs, and partnership opportunities through genuine expertise.

## How to Use This Skill

**Input format:**
```
NAME: [Your full name]
TITLE/ROLE: [Your professional title]
COMPANY: [Your company or "Solopreneur"]
NICHE/EXPERTISE: [What you're an authority in]
TARGET AUDIENCE: [Who you want to reach — job titles, industries]
GOAL: [Leads / Speaking / Job opportunities / Partnerships / Brand awareness]
TONE: [Professional + [warm/bold/direct/empathetic] — pick your combination]
UNIQUE PERSPECTIVE: [Your contrarian view or unique approach in your field]
```

---

## LinkedIn Post Framework: The 4-Part Structure

Every high-performing LinkedIn post follows this pattern:

### Part 1: The Hook (Line 1 — the most important)
The first line is ALL that appears before "...see more". It must compel the click.

**Hook formulas:**
```
Contrarian: "Everyone says [X]. They're wrong."
Story: "3 years ago, I [relatable struggle]. Here's what I learned."
Number: "I've [done X] for [N] years. The #1 mistake I see:"
Question: "Why do [common behavior] lead to [unexpected result]?"
Statement: "[Bold claim that challenges assumptions]."
```

### Part 2: The Story / Experience
```
[Personal or client situation — specific, not generic]
[The problem or challenge that arose]
[What you tried first — and why it didn't fully work]
[The turning point or insight]
```

### Part 3: The Lesson
```
[The core insight — 1-3 clear sentences]
[Why this matters for your audience]
[How this applies to their situation]
```

### Part 4: The Perspective + CTA
```
[Your clear stance or recommendation]
[Optional: what you now do differently]
[Engagement CTA: "What's your experience?" / "Agree or disagree?" / "Save this for..."]
```

---

## Post Types

### 1. Thought Leadership Post (Long-form, 300-600 words)
**Best for:** Authority building, organic reach, attracting leads
**Prompt:**
```
Write a LinkedIn thought leadership post for [NAME] in [NICHE].
Topic: [SPECIFIC TOPIC]
Structure: Hook → Personal story (specific situation) → Lesson learned → Your perspective → Discussion question.
Tone: [TONE]. No bullet point overload. Conversational but authoritative.
Word count: 350-500 words.
```

### 2. Insight Post (Short, 100-200 words)
**Best for:** Daily presence, high engagement, building habits
**Prompt:**
```
Write a short LinkedIn insight post for [NAME].
Topic: [TOPIC] — one sharp observation or lesson.
Format: Bold hook line → 3-5 short paragraphs → 1 closing question.
Max 150 words. Punchy. No fluff.
```

### 3. Case Study Post
**Best for:** Converting readers into leads
**Prompt:**
```
Write a LinkedIn case study post for [NAME].
Client situation: [describe the before-state anonymously]
Challenge: [what problem they faced]
Solution: [what you/they did]
Result: [specific outcome if possible]
Format: "The [client type] came to me with [problem]..." story format.
End with CTA for similar prospects.
```

### 4. Controversial/Contrarian Take
**Best for:** Viral reach, establishing a clear position
**Prompt:**
```
Write a contrarian LinkedIn post for [NAME] challenging the common belief that [COMMON BELIEF IN NICHE].
Present the counter-argument with evidence or experience.
Don't be offensive — be thoughtful and invite discussion.
End with: "Agree? Disagree? Let me know below."
```

### 5. LinkedIn Article (Long-form, 800-2000 words)
**Best for:** SEO on LinkedIn, establishing deep expertise
**Prompt:**
```
Write a LinkedIn article for [NAME] titled: "[TITLE]"
Audience: [TARGET AUDIENCE]
Structure: Introduction → 3-4 H2 sections → Conclusion with CTA
Include: practical examples, numbered lists where helpful, 1-2 personal stories
Tone: [TONE]. This is a definitive guide on [TOPIC].
```

---

## Posting Strategy

### Optimal Posting Schedule

| Day | Content Type | Best Time |
|-----|-------------|-----------|
| Monday | Inspirational or motivational insight | 7-8 AM |
| Tuesday | Educational post or how-to | 10-11 AM |
| Wednesday | Thought leadership (long-form) | 7-8 AM |
| Thursday | Case study or client story | 12-1 PM |
| Friday | Reflection, lesson of the week | 8-9 AM |

**Frequency:** 3-5x per week
**Comments:** Reply to every comment within 2 hours of posting (algorithm boost)
**Engagement:** Comment meaningfully on 5-10 posts/day in your niche

---

## LinkedIn Profile Optimization

### Headline Formula
```
[What you do] for [who you serve] → [Result they get]

Example: "I help B2B founders generate 10+ inbound leads/month through LinkedIn content | Marketing Strategist"
```

### About Section Structure
```
[Hook — your most impressive result or bold statement]

[Your story — why you do what you do, 2-3 sentences]

[Who you serve — specific, not generic]

[What you offer — your main services/products]

[Social proof — numbers, clients, results]

[CTA — how to work with you or connect]
```

### Featured Section
Pin your best posts, a lead magnet, or a booking link.

---

## B2B Outreach Templates

### Connection Request (Cold)
```
Hi [Name], I came across your post about [SPECIFIC TOPIC] and it resonated with what I see in [NICHE].
Would love to connect — I share content on [YOUR EXPERTISE] that might be useful for someone in your role.
```

### Follow-up DM After Connection
```
Hi [Name], thanks for connecting!
I noticed you work in [FIELD]. I'm [YOUR ROLE] helping [TARGET CLIENTS] with [SPECIFIC PROBLEM].
Are you currently dealing with [RELEVANT CHALLENGE]?
No pitch — genuinely curious about your experience.
```

### Inbound Lead Response
```
Hi [Name], thanks for reaching out!
To make sure I give you the most relevant answer: what's the main challenge you're trying to solve with [YOUR SERVICE/TOPIC]?
I want to give you useful info, not just a sales pitch.
```

---

## Speaker Bio Generator

**Prompt:**
```
Write a professional speaker bio for [NAME].
Include:
- Their unique expertise in [NICHE]
- Specific results achieved (for clients or personally)
- Credentials or experience (years, notable clients/stages)
- Personal element (what makes them human, not just impressive)
- What audiences take away from their talk

Format: Short version (100 words) + Full version (300 words).
Tone: [TONE] — third person, professional but not stiff.
```

---

## 90-Day LinkedIn Growth Plan

**Days 1-30: Establish Voice**
- Post 3x/week
- Test different formats (story vs insight vs controversial)
- Optimize profile completely
- Connect with 10 ideal prospects/day

**Days 31-60: Build Authority**
- Identify your 2-3 highest-performing content themes
- Write 2 LinkedIn articles
- Start engaging with industry thought leaders' content
- Request 3-5 LinkedIn recommendations from past clients/colleagues

**Days 61-90: Generate Leads**
- 4-5 posts/week on proven themes
- DM follow-up sequence for engaged commenters
- Share lead magnet in relevant posts
- Track: which content type brings profile views → follow up with those viewers

---

## Use with ContentAI Suite

This skill works seamlessly with **[ContentAI Suite](https://contentai-suite.vercel.app)** — a free multi-agent marketing platform that generates your LinkedIn thought leadership content, B2B outreach, and speaker positioning in your unique voice.

→ **Try it free:** https://contentai-suite.vercel.app
