# Link Brain v4.0.0 notes (for ClawHub + issue #15913)

## What is new

- Auto save: `save --auto` and `auto-save` fetch the page with `urllib` and generate title, tags, and an extractive summary locally.
- Knowledge graph: `graph` generates a single standalone interactive HTML file with no external JavaScript dependencies.
- Natural language search: `search` supports time, source, read/unread, rating, and sort hints.
  - Examples: `last week unread from github`, `best rated sqlite`, `oldest unread`.
- Collections: create reading lists, add and remove links, and export a collection to markdown or HTML.
- Spaced repetition: review queue stored in SQLite with `review next`, `review done`, and `review skip`.

## Safety and privacy

- All data stays on disk in `~/.link-brain/`.
- The only network request is in auto save mode (`--auto` or `auto-save`), where the script fetches the URL content in order to summarize locally.
- No external APIs and no telemetry.

## Tests

- Added an end to end v4 test script: `skills/link-brain/tests/test_v4.sh`.
- Tests run with `LINK_BRAIN_DIR=/tmp/test-link-brain-v4`.
