# 小红书视觉场景

## 平台特征与创意底层逻辑

小红书是一个以"真实生活方式分享"为核心的内容平台。用户来这里寻找的不是广告，而是来自真实用户的推荐、分享和生活灵感。这决定了小红书视觉有几个根本性的特征：

**真实感比完美感更重要**
过度精修、太像广告大片的图片在小红书往往表现不好。用户需要感受到"这是真实的人拍的"，带有生活温度的不完美感反而能增加信任。

**情绪价值是传播核心**
用户保存、分享一张图的核心动机是情绪共鸣——"这就是我想要的生活"、"这说出了我的心声"、"这太美了我也想去"。视觉创意要优先服务情绪，其次才是信息。

**封面图决定点击率**
在信息流中，封面图是唯一的点击入口。封面图要在缩略图状态下就能传递内容价值，文字和视觉要高度配合。

**图文是一个整体**
小红书的"图"和"文"不是分离的，封面图的文字标题、正文配图、最后的收尾图共同构成完整的内容体验，每张图在内容叙事中都有自己的位置。

---

## 一、内容类型识别与创意策略

### 1.1 种草笔记（产品推荐）

**内容特征**
用户来看种草笔记是为了决策——要不要买、值不值得买。视觉任务是让产品"看起来值这个价"，同时保留真实感让用户相信这是真实体验。

**封面图创意策略**
封面文字：直接说清楚推荐什么、最大卖点是什么，字要大、有情绪（"用了三年的回购神器"比"产品推荐"更吸引点击）
视觉主体：产品本身或产品使用状态，场景要有生活感不要太像产品图
氛围感：背景和光线要与产品调性一致，美妆护肤偏柔和明亮，户外装备偏自然真实

**正文配图创意策略**
第1-2张：产品整体展示，清晰为主，可以是平铺或场景摆拍
第3-4张：产品使用细节或效果展示，真实感优先
第5-6张：使用场景或使用后效果，代入感优先
最后1张：总结图或购买信息图，可以有文字叠加

**色彩推导**
场景维度：亲和力与温度感场景为主，高端产品种草兼顾品质感
主题维度：
- 美妆护肤种草 → 浪漫美好主题 → 裸粉、珍珠白、玫瑰金、奶白，低饱和温柔
- 食品零食种草 → 喜悦庆典加自然健康主题 → 暖橙、奶白、草木绿，明快有食欲感
- 家居好物种草 → 温柔关怀加自然健康主题 → 莫兰迪色系，低饱和有质感
- 数码好物种草 → 专业信任主题 → 深色背景加产品高光，专业感
- 服装穿搭种草 → 根据风格选择，基础款偏简约，设计款可以更大胆
配色方案：低饱和莫兰迪或主色加点缀方案，整体克制有质感

**推荐风格**：自然有机风、简约风、写实风、极简奢华风（高端产品）

**创意参考方向**
- 深度层次构图：产品前景加生活场景背景，制造真实生活感
- 平铺摆拍：产品加相关道具的精心平铺，视觉完整有美感
- 局部特写：产品关键部位的微距特写，传递质感和细节

---

### 1.2 生活分享（日常/Vlog/心情）

**内容特征**
生活分享笔记的核心是情绪共鸣。用户看这类内容是为了获得情感共鸣、生活灵感或治愈感。视觉要传递真实的生活状态，过度精修反而会破坏代入感。

**封面图创意策略**
封面文字：情绪化的短句或问句比陈述句更容易引发共鸣（"一个人的周末怎么过最治愈"比"周末日记"更吸引点击）
视觉主体：生活场景的真实瞬间，光线和构图要有美感但不能太刻意
情绪传递：色调和光线是最重要的情绪载体，冷暖色调会传递完全不同的情绪

**正文配图创意策略**
图片要有叙事性，从第一张到最后一张有情绪流动，不能只是不相关图片的堆砌
每张图承担不同的叙事位置：开场建立氛围、中间展开内容、结尾情绪收尾
生活感和真实感优先，带有自然光线的照片质感更受欢迎

**色彩推导**
场景维度：亲和力与温度感场景
主题维度：
- 治愈日常 → 温柔关怀主题 → 莫兰迪色系，低饱和暖色，柔和自然光
- 精致生活 → 浪漫美好主题 → 奶白、香槟、裸粉，有质感但不失真实
- 元气活力 → 活力年轻主题 → 中高饱和明快色，阳光自然感
- 旅行探索 → 自然健康或神秘高端主题 → 根据目的地色调推导
配色方案：整体低饱和，用光线变化而非高饱和色彩来营造情绪

**推荐风格**：自然有机风、简约风、手绘风（偶尔）

**创意参考方向**
- 情绪具象化：把生活情绪（治愈、惬意、充实）转化为具体视觉氛围
- 框中框构图：窗边、门框、镜面反射等自然框景元素
- 局部叙事：用有温度的生活细节暗示整个生活状态

---

### 1.3 干货教程（攻略/技巧/测评）

**内容特征**
干货教程的用户来这里是为了获取有价值的信息。视觉任务是让信息清晰易读，同时不能枯燥无趣——小红书的干货要有"颜值"。

**封面图创意策略**
封面文字：数字化标题更受欢迎（"5个让你的早晨高效的习惯"比"早晨习惯分享"点击率高），字要大且清晰
视觉主体：与主题相关的精致场景图，或信息图样式的封面（文字信息图）
设计感：干货类封面比生活类封面更适合有设计感的图文排版，但要保持小红书调性

**正文配图创意策略**
信息图样式：步骤、要点、对比可以用信息图方式呈现，但视觉要精致，不能有PPT感
每张图承担清晰的信息任务：步骤1、步骤2，或要点一、要点二
文字和视觉的密度要平衡，不能图太满也不能太空

**色彩推导**
场景维度：品质感与信任感场景（传递专业感）
主题维度：专业信任主题 → 清爽的颜色体系，蓝绿、奶白、浅灰，信息清晰优先
配色方案：主色加点缀方案，整体色调统一，强调色用于标注重点信息

**推荐风格**：简约风、平面风

**创意参考方向**
- 信息图布局：清晰的视觉层级，图标化表达，步骤感强
- 张力构图：主体信息占据视觉主导，留白让内容呼吸
- 色彩编码：用不同颜色区分不同信息层级或步骤

---

### 1.4 探店打卡

**内容特征**
探店内容的核心价值是"帮用户做决策"——值不值得去。视觉要传递空间氛围、食物品质、整体体验感，让用户隔着屏幕就能感受到"在那里会是什么感觉"。

**封面图创意策略**
封面文字：直接说出最大亮点（"藏在胡同里的宝藏咖啡馆"比"咖啡馆探店"更有点击欲）
视觉主体：空间最美的角落或最具特色的食物，光线是最重要的氛围载体
氛围传递：不同类型的空间有不同的氛围追求，咖啡馆要静谧有质感，餐厅要有食欲感，景点要有沉浸感

**正文配图创意策略**
第1-2张：空间整体环境，建立场景感
第3-4张：食物或产品特写，食欲感或品质感
第5-6张：细节和亮点，传递体验感
最后1张：地址信息或总结图，功能性收尾

**色彩推导**
场景维度：亲和力与温度感场景
主题维度：根据探店类型推导
- 咖啡馆探店 → 浪漫美好加温柔关怀主题 → 暖棕、奶白、低饱和绿，温柔静谧
- 餐厅美食探店 → 喜悦庆典加自然健康主题 → 暖橙、食材本色、温暖灯光色
- 文艺空间探店 → 神秘高端或自然健康主题 → 根据空间色调推导
- 景区户外探店 → 自然健康主题 → 天空蓝、草木绿、自然光色调
配色方案：顺应拍摄场所的自然色调，后期调色克制，保留真实感

**推荐风格**：写实风、自然有机风

**创意参考方向**
- 深度层次构图：前景道具虚化，中景主体清晰，远景空间延伸
- 框中框构图：利用门框、窗框、拱形等建筑元素自然框景
- 情绪具象化：把空间氛围（温馨、神秘、治愈）转化为光线和色调

---

### 1.5 经验分享（成长/感悟/职场/情感）

**内容特征**
经验分享是小红书上增长最快的内容类型之一，涵盖职场经验、人生感悟、情感故事、成长记录等。用户来看这类内容是为了获得认同感、启发感或安慰。视觉任务是强化情感共鸣，让用户感受到"这说的就是我"。

**与生活分享的核心区别**
生活分享展示的是"我的生活状态"，经验分享传递的是"我的思考和感悟"。前者视觉感性具象，后者可以更抽象和符号化，文字在视觉中的比重更高。

**封面图创意策略**
封面文字：观点型或共鸣型标题最有效，直接说出用户想说但没说出口的话（"在大城市独居的第三年，我终于想清楚了一件事"）；数字化标题也适用（"工作5年的真实感受"）
视觉主体：与主题情绪一致的场景或氛围图，人物出镜时背影、侧影比正面更有故事感；也可以是有设计感的文字图，用排版本身作为视觉主体
情绪氛围：视觉要与内容情绪高度一致，职场内容偏城市感，情感内容偏温柔感，成长内容偏开阔感

**正文配图创意策略**
经验分享类内容的正文图可以分两种方向：
纯场景图方向：每张图都是有情绪价值的生活场景，配合文字叙述情感流动
图文混排方向：金句或核心观点做成排版精致的文字图，与场景图穿插
结尾图通常是最有力的金句或总结，视觉处理要有仪式感

**色彩推导**
场景维度：亲和力与温度感场景为主
主题维度：
- 职场经验分享 → 专业信任主题 → 城市灰蓝、冷白、简约配色，克制专业
- 情感故事分享 → 温柔关怀主题 → 暖白、莫兰迪粉、低饱和暖色，柔和温暖
- 成长感悟分享 → 自然健康主题加力量突破主题 → 天空蓝、草木绿、开阔自然感
- 生活哲学分享 → 神秘高端主题 → 深色背景加留白，有思考感的克制美学
配色方案：低饱和主色加点缀方案，整体色彩比生活分享更克制，给文字留出视觉空间

**推荐风格**：简约风、自然有机风、极简奢华风（深度内容）

**高频视觉元素**
城市感：城市天际线、咖啡馆窗边、地铁站台、写字楼走廊
自然开阔感：海边、山顶、空旷的原野、黄昏天空
内心感：手持书籍、窗边发呆、独坐的背影、晨光中的房间
时间感：日历、钟表、季节变化的植物

**创意参考方向**
- 情绪具象化：把抽象的感悟（迷茫、豁然开朗、坚定）转化为具体的自然意象或空间状态
- 极简压迫构图：大面积留白加核心元素，给人思考的空间
- 局部叙事：用一个有象征意义的细节传递整个内容的情感内核

---

### 1.6 穿搭时尚类

**内容特征**
穿搭是小红书流量最大的内容品类之一。用户看穿搭内容的核心动机是寻找穿衣灵感、确认某种风格适不适合自己、或者找到具体的购买参考。视觉任务是让看到图的人产生"我也想穿成这样"的冲动。

**与种草笔记的核心区别**
种草笔记的主角是产品，穿搭内容的主角是"穿着这套搭配的人在某个场景里的整体状态"。产品是构成这个状态的元素，但不是视觉核心。

**封面图创意策略**
封面文字：风格标签加场景感标题效果最好（"显高显瘦的通勤穿搭｜打工人日常"），或直接用视觉冲击力强的全身造型图无文字
视觉主体：人物全身或四分之三身造型，周围环境与穿搭风格高度匹配，背景不抢戏但要有质感
场景选择：场景是穿搭内容的灵魂——通勤穿搭要有城市感，度假穿搭要有轻松感，复古风要有年代感，场景和服装要互相成就

**正文配图创意策略**
第1-2张：整体造型的不同角度，全身正面加侧面或背面
第3-4张：搭配细节特写，包包、鞋子、首饰、叠穿细节
第5-6张：不同场景下的同套穿搭，或同款单品的多种搭配方式
最后1-2张：单品平铺或挂拍，配购买信息

**核心视觉要素**
人与场景的关系：人物不是孤立站在白背景前，而是融入一个与穿搭气质一致的空间或街道
光线选择：自然光是穿搭图的最佳光源，硬光显衣服质感，柔光显整体氛围
动态感：自然的行走、转身、整理发丝的动作比僵硬的摆拍更有生活感
细节放大：材质特写是穿搭内容建立信任感的重要方式

**色彩推导**
场景维度：亲和力与温度感场景
主题维度：与穿搭风格强烈关联
- 简约通勤风 → 专业信任主题 → 黑白灰米，克制有质感
- 法式复古风 → 浪漫美好主题 → 奶白、玫瑰粉、雾霾蓝，低饱和柔和
- 街头潮流风 → 活力年轻主题 → 高饱和撞色，大胆对比
- 自然清新风 → 自然健康主题 → 草木绿、奶白、土地棕，户外自然感
- 度假慵懒风 → 温柔关怀主题 → 沙滩米、珊瑚橙、天空蓝，轻松愉快
配色方案：顺应穿搭本身的色彩，背景和道具色调不与服装撞色抢戏

**推荐风格**：写实风，强调自然光线和真实场景感

**组图建议**：6-12张，封面加造型图加细节图加单品图

**创意参考方向**
- 深度层次构图：人物中景，背景虚化但保留场景感，街道、建筑、自然环境
- 对角线构图：人物行走或转身的动态，对角线延伸制造节奏感
- 局部叙事：材质特写、叠穿细节、配件组合，每一个局部都在强化整体的风格印象

---

### 1.7 美妆美发类

**内容特征**
美妆美发内容在小红书有两种截然不同的形态：效果展示型（最终妆容或发型的呈现）和教程步骤型（分步骤讲解如何实现）。两种形态的视觉逻辑完全不同，需要先识别是哪种再决定创意策略。

**效果展示型创意策略**
封面：妆后或发型完成后的最佳状态，光线是核心，美妆图的光线要能让妆容细节清晰可见同时有美感
正面近景：五官清晰，妆容细节可见，光线均匀柔和不过曝
半侧面：展示妆容的立体感和轮廓效果
细节特写：眼妆、唇妆、腮红等关键部位的微距，传递质地和层次感
整体氛围图：人物在有美感的场景中的状态，传递"化了这个妆之后的感觉"

**教程步骤型创意策略**
每个步骤一张图，步骤图的核心是清晰而非美观
步骤编号要显眼，方便用户按顺序浏览
每张图的操作动作要清晰，手势和工具使用清晰可见
前后对比图是这类内容最有价值的图，放在开头（激发兴趣）或结尾（总结效果）

**封面图差异**
效果展示型封面：妆容或发型最好看的状态，视觉冲击力强，让用户第一眼就想要
教程步骤型封面：通常用Before/After对比图作封面，直接传递"跟着做能达到的效果"

**色彩推导**
场景维度：亲和力场景为主，高端美妆内容兼顾品质感
主题维度：
- 日常自然妆 → 温柔关怀主题 → 裸粉、奶白、肤色，低饱和清透感
- 精致复古妆 → 浪漫美好主题 → 玫瑰红、香槟金、奶白，有仪式感
- 元气活力妆 → 活力年轻主题 → 珊瑚橙、桃粉、明黄，明快青春
- 高级暗黑妆 → 神秘高端主题 → 深枣红、暗紫、深棕，神秘有力量
发型配色顺应发色，背景色不与发色撞色
配色方案：整体以肤色和妆色为主导，背景和服装是辅助，不能抢过妆容本身

**推荐风格**：写实风，美妆图的光线和色彩要真实准确，不能过度滤镜导致色差

**组图建议**：效果展示型4-6张；教程步骤型6-12张，步骤数决定张数

**创意参考方向**
效果展示：极简压迫构图，人物面部占满画面三分之二以上，背景干净不抢戏
教程步骤：规律性构图，每张图的机位和裁切方式保持统一，给用户稳定的阅读节奏
Before/After：左右对比或上下对比，两侧光线环境要保持一致，对比才有说服力

---

### 1.8 美食食谱类

**内容特征**
美食食谱内容包括家庭烹饪教程、食谱分享、美食制作记录等。与探店不同，这类内容展示的是自己做的食物，核心视觉任务是激发食欲感同时传递"我也能做到"的可复制感。

**与探店打卡的核心区别**
探店强调空间氛围和体验感，食谱类强调食物本身的诱人状态和制作过程的可学习性。两者都需要食欲感，但食谱类还需要传递步骤清晰、材料可得的亲切感。

**封面图创意策略**
封面文字：结果导向的标题最有效（"10分钟搞定的懒人早餐"、"用空气炸锅做的外酥里嫩鸡翅"），数字和具体描述比模糊描述更有点击欲
视觉主体：成品食物在最好看的状态，光线、摆盘、背景是决定食欲感的三要素
食欲感营造：热腾腾的蒸汽、流动的酱汁、新鲜食材的剖面、食物的堆叠层次，这些细节决定图片的食欲感高低

**正文配图创意策略**
成品大图（第1-2张）：最诱人的角度，光线最好，摆盘最精心，激发继续看下去的欲望
食材准备图（第3张）：所有食材整齐摆放的平铺图，让用户一眼确认"我有这些材料"
步骤图（第4-7张）：每个关键步骤一张图，动作清晰，火候和状态变化要可见
细节特写（穿插使用）：食材断面、酱汁挂壁、火候状态等关键细节

**食欲感视觉要素**
光线：自然光或暖色侧光是食物摄影最友好的光源，顶光会让食物显得扁平缺乏食欲
背景：木质台面、白色瓷碗、亚麻布等自然材质背景最能衬托食物
角度：45度俯视角是食物最通用的最佳角度，汤类食物可以完全俯视，有高度的食物可以平视
新鲜感：食物刚出锅的状态、刀切断面的新鲜感，时机比摆盘更重要

**色彩推导**
场景维度：亲和力与温度感场景
主题维度：自然健康主题加喜悦庆典主题
- 家常菜 → 暖橙、食材本色、木质暖棕，亲切有烟火气
- 烘焙甜品 → 奶白、焦糖棕、莫兰迪粉，温柔精致感
- 健康轻食 → 草木绿、奶白、清爽蓝，清爽干净感
- 节日料理 → 暖红、金黄、节日氛围色，喜庆热闹感
配色方案：以食材本色为主导，背景和道具衬托而非主导

**推荐风格**：自然有机风、写实风

**组图建议**：6-10张，成品图加材料图加步骤图

**创意参考方向**
- 45度俯视构图：食物摄影最经典的角度，层次清晰，元素完整
- 深度层次构图：前景食材虚化，中景主食物清晰，背景厨房环境虚化
- 局部特写：食物断面、酱汁细节、食材质感的微距，制造强烈食欲感

---

### 1.9 旅行攻略类

**内容特征**
旅行攻略内容帮助用户规划出行，包括目的地推荐、行程安排、景点详解、住宿攻略、交通指南等。与探店打卡的单点体验不同，旅行攻略是多地点、多维度的系统性内容，视觉要同时处理多场景的信息量。

**与探店打卡的核心区别**
探店聚焦单一地点的深度体验，情绪感和氛围感优先；旅行攻略需要覆盖多地点多维度，实用信息密度更高，视觉要在美感和信息量之间找平衡。

**封面图创意策略**
封面文字：目的地加行程亮点的组合最有效（"云南8天7夜完整攻略｜人均3000元的高性价比线路"），具体的数字和承诺让用户感受到内容的实用价值
视觉主体：目的地最有代表性的标志性景观，或多张景点照片的拼贴封面（2x2或3x1的拼图封面）
情感钩子：旅行内容要让用户产生"我也想去"的冲动，封面图要传递目的地最打动人的特质

**正文配图创意策略**
封面大图（第1张）：目的地最震撼的视觉，建立"值得去"的第一印象
行程概览图（第2张）：整体行程安排的信息图，让用户快速了解内容框架
各景点展示（第3-8张）：每个重点景点或体验独立一张图，按行程顺序排列
实用信息图（最后1-2张）：交通、住宿、预算的整理，信息图形式，功能性强

**多图拼贴封面的处理**
旅行攻略类内容常用多图拼贴封面展示目的地的丰富性，拼贴要注意：
图片数量：2张（左右对半）或4张（2x2四宫格），不超过4张
色调统一：拼贴内的图片色调要接近，否则拼在一起会显得杂乱
留白分隔：拼贴图片之间要有极细的白色分隔线，避免图片互相干扰

**色彩推导**
场景维度：亲和力与温度感场景为主，大自然景观兼顾自然健康场景
主题维度：与目的地的自然特征和文化调性高度相关
- 热带海岛 → 自然健康主题 → 天空蓝、珊瑚橙、沙滩米，明亮轻松
- 欧洲城市 → 神秘高端加浪漫美好主题 → 石灰白、古典棕、天空蓝，有历史感
- 国内古城 → 文化感场景 → 青砖灰、朱砂红、水墨感色调，有中式韵味
- 自然山水 → 自然健康主题 → 山绿、天蓝、云白、岩灰，自然清透
- 都市探索 → 专业信任加活力主题 → 城市灰、霓虹色、夜景金，现代都市感
配色方案：以目的地的自然色彩为主导，后期色调要保持目的地的真实气质

**推荐风格**：写实风（景观图）、简约风（信息图）

**组图建议**：8-15张，视行程长度和覆盖维度决定

**创意参考方向**
- 极简压迫构图：标志性景观的震撼展示，天地各半或三分之一构图，空间感强
- 深度层次构图：前景植物或人物，中景建筑或景点，远景山水或天际线
- 信息图穿插：纯景观图和信息整理图交替出现，美感和实用并重

---

### 1.10 健身运动类

**内容特征**
健身运动内容包括训练教程、健身记录、运动好物推荐、体型变化分享等。这类内容有强烈的激励属性，视觉要传递力量感、健康感或成就感，让用户感受到"我也可以做到"的可能性。

**内容子类型与视觉差异**
动作教程类：步骤分解图，清晰展示每个动作的姿势和要点，准确性优先
体态变化类（Before/After）：前后对比图，是这类内容传播力最强的形式，光线和角度的一致性是关键
训练记录类：日常健身状态的真实记录，真实感和坚持感是情绪价值
运动好物种草类：装备推荐，与电商种草逻辑相近，但要在运动场景中展示

**封面图创意策略**
动作教程型封面：关键动作的标准姿势展示，配上数字化标题（"10分钟核心训练，在家就能做"）
体态变化型封面：Before/After对比直接作封面，数字化效果说明（"3个月练出的马甲线"）最有传播力
训练记录型封面：训练状态中的真实场景，汗水和专注感是情绪核心

**正文配图创意策略**
动作教程：每个动作独立一张图，相同机位和背景保持稳定，动作标注清晰
体态变化：多角度的前后对比，同样的站姿、同样的灯光、同样的角度才有可信度
训练记录：时间顺序的训练照片，展示坚持的过程比展示结果更有共鸣

**色彩推导**
场景维度：力量突破场景为主
主题维度：
- 力量训练内容 → 力量突破主题 → 深色背景加高饱和强调色，力量感强
- 瑜伽普拉提内容 → 自然健康加温柔关怀主题 → 白色或木色背景，低饱和柔和
- 户外运动内容 → 自然健康主题 → 自然光、蓝天、绿地，开阔自然感
- 体态管理内容 → 专业信任主题 → 干净背景、清晰光线，专业可信感
配色方案：运动类内容整体饱和度略高于生活类，力量感要在视觉中体现

**推荐风格**：写实风为主，力量类内容可以偏向科技风或极简风

**组图建议**：动作教程6-10张；体态变化4-6张；训练记录4-8张

**创意参考方向**
- 对角线构图：运动动作沿对角线延伸，制造动感和力量感
- 极简压迫构图：深色背景加人物，聚焦肌肉线条或动作细节
- Before/After对比构图：左右或上下对称排列，相同光线和角度是可信度的基础

---

## 二、小红书视觉规范

### 2.1 尺寸规范

封面图（标准）：3:4 竖版，1242x1660px
正方形配图：1:1，1080x1080px
横版配图：4:3，1440x1080px（较少使用）

组图建议：
种草笔记：6-9张，封面加5-8张正文图
生活分享：3-6张
干货教程：4-8张，视内容量决定
探店打卡：6-12张，场景要展示完整
经验分享：4-8张，场景图与文字图可穿插使用
穿搭时尚：6-12张，造型图加细节图加单品图
美妆美发（效果展示型）：4-6张
美妆美发（教程步骤型）：6-12张，步骤数决定张数
美食食谱：6-10张，成品图加材料图加步骤图
旅行攻略：8-15张，视行程长度和覆盖维度决定
健身运动（动作教程）：6-10张；体态变化：4-6张；训练记录：4-8张

### 2.2 封面图文字规范

文字层级：
- 主标题：核心吸引点，字号最大，通常10-20字
- 副标题：补充说明，可选，字号次之
- 装饰性小字：账号名或标签，最小字号

文字风格：
- 字体要与整体视觉风格一致，精致类内容用细体或衬线体，活力类内容用粗体
- 文字颜色与背景要有足够对比度
- 文字位置通常在画面上三分之一或下三分之一，不遮挡视觉核心

用户未提供标题时：根据内容类型生成符合小红书调性的标题：
种草类：情绪价值词汇（回购神器、宝藏发现、绝绝子）
干货类：数字化标题（3个技巧、5步搞定）
生活分享类：情感共鸣词（治愈、打工人、一个人）
经验分享类：观点感或共鸣感（"我终于想清楚了"、"工作X年后才明白"）
穿搭类：风格标签加场景（"显高显瘦的通勤穿搭"）
美妆类：效果承诺加时间成本（"5分钟搞定的通勤妆"）
美食类：结果导向加具体描述（"10分钟搞定的懒人早餐"）
旅行类：目的地加行程亮点加具体数字
健身类：效果承诺加时间或难度（"在家就能做的10分钟核心训练"）

### 2.3 整体调性要点

在提示词中需要明确传递的小红书质感：
- 自然光线优先：窗边光、散射光、黄昏光，避免强烈的人工布光感
- 生活道具的存在感：咖啡杯、书籍、花束、植物，增加生活温度
- 不刻意的真实感：构图可以精心但不能显得"太刻意"
- 低饱和的色调处理：整体色调克制，通过明暗对比而非高饱和度制造视觉层次
