# 微信公众号视觉场景

## 平台特征与创意底层逻辑

微信公众号是强关系链的内容平台，用户订阅是主动行为，意味着对这个账号有明确的信任和期待。与小红书的广场发现逻辑不同，公众号的内容在熟人圈和订阅圈内传播，信任感是一切的基础。

**信任感比冲击力更重要**
读者是"老朋友"而非陌生路人。过度广告感或视觉刺激会损害信任关系。视觉风格要稳定、专业、有品牌感，让读者每次打开都有"这就是我认识的那个账号"的熟悉感。

**图片是长内容的一部分**
公众号图片不是独立的，封面图决定打开率，内文配图服务于阅读体验，分享卡片承担社交传播。每张图在内容叙事和传播链路中都有明确的功能定位。

**移动端竖屏阅读优先**
绝大多数公众号阅读在手机上发生，750px宽度是设计的第一标准，图片在手机屏幕内的视觉效果比在电脑上更重要。

**品牌一致性是账号资产**
视觉风格的一致性是建立账号辨识度的关键。每篇推文的视觉都在品牌框架内，读者看到封面颜色或排版风格就能识别出账号，这是长期积累的视觉资产。

---

## 一、内容类型识别与创意策略

### 1.1 知识干货类封面与配图

**内容特征**
知识类公众号是最主流的形态，涵盖行业分析、学习方法、职场技能、科普内容等。用户来这里是为了获取有价值的信息，视觉任务是传递专业感和可信度，同时让内容看起来值得打开。

**封面图创意策略**
封面文字：标题要在消息列表缩略图（200x200）状态下清晰可读，主标题要直接传递内容价值，数字化标题（"5个方法"、"3个误区"）和问题式标题（"为什么你的XXX总是失败？"）点击率更高
视觉主体：与主题相关的场景图或信息图风格；知识类内容用场景图时要有专业感，用信息图时要有设计感
整体调性：专业克制，不能廉价，但也不能过于冷漠——知识类读者期待的是"靠谱的朋友"而非"权威机构"

**内文配图创意策略**
章节分隔图：大字章节标题加简洁背景，帮助读者快速把握文章结构，色调与封面统一
内容说明图：数据可视化、流程图、对比图，把文字描述的结构化内容转化为可视图表
情绪配图：段落之间的视觉呼吸图，与该段内容情绪相关，无文字或极少文字

**色彩推导**
场景维度：品质感与信任感场景
主题维度：
- 职场商业类 → 专业信任主题 → 深蓝、藏青、白灰，稳重专业
- 学习成长类 → 自然健康加专业信任主题 → 蓝绿、奶白、浅灰，清新专业
- 科技互联网类 → 专业信任加力量突破主题 → 深色背景加冷白，科技感
- 人文历史类 → 神秘高端主题 → 深棕、暖灰、纸质感色调，有厚重感
配色方案：主色加点缀方案，整体不超过三色，品牌色系贯穿全文

**推荐风格**：简约风、平面风（信息图）、写实风（场景图）

**创意参考方向**
- 张力构图：主标题占据画面主导，背景简洁有设计感
- 信息图布局：清晰视觉层级，数据和要点的图形化表达
- 框中框构图：制造层次感，比纯文字封面有更高的点击欲望

---

### 1.2 情感故事类封面与配图

**内容特征**
情感类公众号是另一大主流形态，涵盖人生故事、情感共鸣、心理疗愈、生活哲学等。用户来这里是为了获得情感共鸣或心理滋养，视觉任务是快速建立情绪连接，让用户感受到"这篇文章懂我"。

**封面图创意策略**
封面文字：情绪化标题最有效，直接说出用户的心理状态（"那些让你在深夜哭泣的瞬间"），共鸣感比信息量更重要
视觉主体：有情感温度的生活瞬间，人物背影、窗边光线、自然场景比正面人像更有故事感和想象空间
光线与色调：是情感类封面最重要的创意元素，冷暖色调传递完全不同的情绪，要与文章的情感基调高度一致

**内文配图创意策略**
情感类配图更强调图片的叙事性，每张图要和对应段落的情绪流动相匹配
开篇图建立情绪基调，要有代入感；中间图随着故事发展维持情绪流动；结尾图做情绪升华或收尾，通常是最有力量感的一张
金句图：把文中最有传播力的句子单独做成排版精致的文字图，读者截图分享的概率极高

**色彩推导**
场景维度：亲和力与温度感场景
主题维度：
- 温暖治愈类 → 温柔关怀主题 → 暖白、奶黄、莫兰迪粉，柔和光感
- 感悟励志类 → 力量突破主题 → 开阔的冷暖对比，天空蓝加暖橙
- 忧郁共鸣类 → 神秘高端主题 → 冷色调，深蓝灰，有距离感的孤独美
- 生活哲学类 → 自然健康主题 → 低饱和自然色，有思考空间的克制美
配色方案：渐变色或单色深浅方案，情感类配色要有情绪的流动感，不宜用强对比撞色

**推荐风格**：自然有机风、写实风、极简奢华风（深度内容）

**创意参考方向**
- 情绪具象化：把文章情绪转化为可感知的光线状态、自然景象或空间氛围
- 局部叙事：用一个有温度的细节（手、窗光、咖啡杯）暗示整个情感场景
- 极简压迫构图：大面积留白加核心情感元素，给读者留出情绪呼吸空间

---

### 1.3 品牌营销类封面与配图

**内容特征**
品牌官方公众号或有商业合作的推文，包括产品推介、活动宣传、品牌故事等。用户对这类内容有一定的"被推销"预期，视觉任务是在不让用户产生抵触的前提下，建立品牌好感并传递信息。

**封面图创意策略**
品牌营销封面要找到品牌利益和读者价值的交叉点，不能只有广告感。标题要有读者视角（"这个东西帮我解决了XXX问题"），而非品牌视角（"XX品牌新品发布"）
视觉主体：产品在生活场景中的自然状态，或品牌故事的情感化呈现
调性平衡：品牌感要保留，但读者价值感要更突出

**内文配图创意策略**
产品展示图：要有生活感，不能太像广告大图，在公众号环境中偏写实的场景感更受接受
品牌故事图：情感化呈现品牌背后的人和故事，增加品牌温度
活动信息图：清晰的活动规则和利益点展示，功能性强，视觉要克制

**色彩推导**
场景维度：品质感与信任感场景为主
主题维度：与品牌调性高度一致，不能因为是公众号场景就偏离品牌色系
配色方案：品牌主色系主导，保持品牌视觉的识别性

**推荐风格**：写实风、简约风（根据品牌调性）

---

### 1.4 活动通知与运营类封面

**内容特征**
公众号活动推文，包括线上活动、线下活动、抽奖互动、征集投票等。这类内容的核心是让读者采取行动，视觉任务是清晰传递活动信息并激发参与动机。

**封面图创意策略**
封面文字：活动主题和最大利益点（奖品、福利）要在第一眼传递清楚，时间信息要显眼
视觉设计：比内容类封面有更多设计感，类似海报的视觉语言，但要与账号整体风格保持一致
行动感：视觉要传递"机会感"，让读者感受到"不参加会错过什么"

**内文配图创意策略**
活动规则图：清晰的规则和参与步骤，功能性第一，视觉辅助理解
奖品展示图：奖品要有视觉吸引力，场景化展示比白底图更有吸引力
倒计时感：如有时间限制，视觉上要传递紧迫感

**色彩推导**
场景维度：强视觉冲击场景为主，但要控制在账号调性范围内
主题维度：喜悦庆典主题，与账号品牌色结合，活动感强但不离谱
配色方案：账号主色加促销强调色，整体比日常内容饱和度稍高

---

### 1.5 分享卡片与长图海报

**内容特征**
用于读者分享到朋友圈的单独图片，包括文章金句卡片、活动海报、知识总结图等。分享卡片是公众号内容在朋友圈二次传播的主要载体。

**创意策略**
分享卡片的设计要解决一个核心问题：读者愿不愿意把这张图发到自己的朋友圈？用户分享的动机通常是：图很美、内容很有共鸣、显示自己的品味或立场。视觉要同时满足美感和内容价值。

金句卡片：文字是绝对主角，排版精致，背景简洁，留出品牌标识位置
活动海报：信息清晰，视觉有吸引力，品牌感强，让分享者感受到"发这个不丢脸"
知识总结卡：核心信息的精华呈现，有收藏和分享价值

**色彩推导**
与账号整体视觉风格高度一致，分享卡片是账号品牌的对外名片

**尺寸规范**
分享海报：3:4竖版，750x1000px，适合朋友圈竖屏浏览
正方形卡片：1:1，750x750px，适合九宫格式的分享
长图：750px宽，高度根据内容，通常750x2000px至750x4000px

---

## 二、公众号视觉规范

### 2.1 尺寸规范

封面大图（文章顶部）：900x383px（约2.35:1横版）
封面小图（消息列表缩略图）：200x200px（1:1），这是最重要的尺寸，消息列表中先被看到
内文配图：750px宽，高度根据内容比例
分享海报：750x1000px 或 750x750px

关键提示：封面大图和小图是不同的尺寸，设计时要同时考虑两者的视觉效果。小图200x200是缩略图，核心信息必须在这个极小尺寸下清晰可读，是决定打开率的关键。

### 2.2 封面图文字规范

文字层级：
主标题：核心内容价值，字号最大，在200x200缩略图下依然清晰
副标题：补充说明，字号次之，可选
账号标识：账号名称或logo，最小字号，固定位置

文字设计原则：
字体风格与账号调性一致，严肃知识类用无衬线字体，人文情感类可以用有温度感的字体
文字颜色与背景的对比度要极高，半透明深色蒙层加白字是最稳定的方案
文字位置避开图片视觉核心，通常在上三分之一或下三分之一

用户未提供标题时：根据内容类型生成符合公众号调性的标题，知识类要有明确的信息价值，情感类要有共鸣感，活动类要有利益点

### 2.3 账号视觉一致性要点

公众号视觉资产的核心是一致性：
固定主色调：品牌色在每篇推文封面中保持稳定，读者能通过颜色识别账号
固定排版风格：封面文字的位置、字体组合、色彩处理方式要形成固定模式
固定质感方向：统一用摄影图、统一用插画、或统一用信息图，不随意混用

在提示词中传递公众号质感的关键描述：
专业克制、品牌一致性强、信息层级清晰、有阅读信任感、移动端阅读优先
