# 短视频封面与缩略图场景

## 场景说明

短视频封面是视频内容在平台信息流中唯一的静态入口。用户在0.3秒内决定要不要点击，封面的任务就是在这0.3秒内传递足够的"点击理由"。

**短视频封面与其他图片的根本差异**
其他图片通常在较大的展示空间内被查看，短视频封面最重要的展示状态是缩略图——在密集的信息流中，它只有约150x250像素的展示空间。所有的设计决策都要以"缩略图状态下是否有效"为第一标准。

**平台差异的重要性**
不同平台的封面逻辑有本质差异。本文件覆盖通用短视频封面逻辑，平台专属的细节规范参见各平台专属场景文件（douyin.md、xiaohongshu.md等）。

---

## 一、封面类型识别与创意策略

### 1.1 人物出镜型封面

**适用内容**
Vlog、知识分享、情感类内容、访谈、真人测评、生活记录。

**创意策略**
人物表情是最强的情绪载体。用户在缩略图中先感受到的是人物传递的情绪，然后才是文字内容。一个有感染力的表情（惊讶、开心、专注、感动）比平静的表情有更高的点击率。

人物在画面中的比例：人物要大，在缩略图状态下面部要清晰可识别。人物太小在缩略图中只是一个模糊的点，失去情绪传递的能力。

背景处理：背景要干净或与内容主题高度相关。复杂的背景会在缩略图中变成噪音，干扰人物的视觉主体地位。

**人物出镜封面的文字处理**
文字要大，在缩略图状态下清晰可读
通常放在画面的上方或下方，避免遮挡人物面部
颜色高对比：白字加黑描边是最通用的方案，在任何背景上都可读

**不同内容类型的人物封面方向**
知识分享类：人物专注/认真的表情，干净背景，大字标题
生活Vlog类：人物自然状态，生活场景背景虚化，有温度感
情感类：人物有情绪感染力的表情，情绪与内容基调一致
测评类：人物手持产品或指向产品，表情有评价感（惊喜、皱眉等反应）

**色彩推导**
场景维度：亲和力场景（生活/情感类）或强视觉冲击场景（知识/娱乐类）
配色方案：人物封面的色调通常跟随拍摄环境，后期调色要统一账号整体色调风格

---

### 1.2 场景展示型封面

**适用内容**
美食、旅行、探店、美景、美妆效果展示、装修改造。

**创意策略**
场景封面的核心是"让用户在0.3秒内感受到这个场景的吸引力"。最佳角度、最好的光线状态、最有代表性的画面瞬间，是场景封面选取的标准。

场景代表性：选取整个视频内容中最有视觉冲击力或最有代表性的一帧，不一定是视频的开头
光线是场景封面最重要的变量：黄金时刻的自然光、精心布置的餐厅灯光、蓬勃的日出，光线决定场景的情绪感染力
文字配合场景：场景封面的文字要说清楚"这是什么地方/什么东西"，避免模糊表达

**场景类型与封面视觉方向**
美食类：食物的最诱人角度，暖色调，45度俯视或平视，食欲感优先
旅行美景类：最震撼的景观角度，自然光，宏大感或独特性
探店类：空间最美的角落，氛围光，有"让人想去"的代入感
美妆效果类：妆前妆后对比，或妆后最好看的状态，清晰的面部展示

---

### 1.3 信息图型封面

**适用内容**
知识科普、干货教程、生活技巧、行业分析。

**创意策略**
信息图型封面本身就是内容价值的预告。用户看到封面上的关键词或数字，能立即判断这个视频对自己有没有价值，决定要不要看。

数字化标题：数字在信息流中有极强的视觉吸引力，也传递内容的具体性（"5个"比"多个"更有点击欲）
关键词突出：核心关键词要在缩略图状态下清晰可读，通常一个主关键词加最多一个副关键词
视觉背景：信息图封面可以用纯色背景、渐变背景或与主题相关的场景图，重要的是文字清晰
对比元素：Before/After对比图作封面，直接传递内容的效果承诺，适合改造/教程类内容

**信息图封面的色彩策略**
高对比色组合：深色底加亮色文字，或亮色底加深色文字
统一的账号配色：信息图封面的颜色要形成账号的视觉识别系统，用户看到颜色就知道是这个账号

---

### 1.4 产品展示型封面

**适用内容**
好物推荐、产品测评、开箱、品牌合作。

**创意策略**
产品封面要让产品在缩略图中就有辨识度和吸引力。产品要够大、够清晰、背景要干净。

产品与文字的配合：产品图加价格或关键词的组合，让用户第一眼就判断这个内容与自己的需求是否相关
多产品封面：好物合集类内容，多个产品拼贴展示，整体有视觉丰富感，但不能太杂乱

---

## 二、跨平台封面规范

### 2.1 各平台主流封面比例

抖音：9:16竖版（1080x1920px）
小红书：3:4竖版（1242x1660px）
B站：16:9横版（1920x1080px）
YouTube：16:9横版（1280x720px）
微信视频号：3:4竖版或1:1
快手：9:16竖版（1080x1920px）

### 2.2 封面文字通用规范

字号：缩略图状态下可读是底线，主标题字号通常是画面高度的8%-15%
颜色：高对比是第一原则，白字加黑描边适用于任何背景
位置安全区：
- 抖音：避开底部150px（用户名）和右侧120px（互动按钮）
- 小红书：底部留出账号信息区
- B站/YouTube：四边各留出约5%的安全边距
字数：主标题不超过15字，越短越有力

### 2.3 封面风格与账号一致性

封面风格的一致性是账号视觉资产的核心。固定的配色、固定的字体风格、固定的构图语言，让用户看到封面就能识别账号。

建立封面系统的要素：
固定主色调：每个视频封面用相同的主色或色调方向
固定字体风格：粗体/细体/衬线/无衬线，选一个方向长期坚持
固定排版位置：标题文字总在固定区域（如画面上三分之一），形成视觉规律
