# 促销海报与活动Banner场景

## 场景说明

促销海报的核心矛盾是：视觉冲击力和信息传达效率的平衡。促销感太弱，利益点传递不出去；促销感太强，画面廉价损害品牌。这个场景的所有创意决策都围绕这个矛盾展开。

**与通用海报的核心区别**
通用海报中的市场营销子场景关注的是品牌侧的促销，本场景聚焦的是电商平台、线上线下活动、节日大促等更具体的促销执行场景，信息密度更高，转化导向更强，时间紧迫感是必要元素。

**促销海报的第一原则**
利益点必须在0.3秒内被感知到。用户不会停下来仔细阅读，如果核心优惠信息不够突出，这张海报就失败了。创意可以大胆，但不能让创意遮蔽利益点。

---

## 一、子场景识别与创意策略

### 1.1 电商大促海报

**使用场景**
双十一、618、年货节、双十二等平台大促节点，通常需要在极短时间内设计完成并大量铺放。

**创意策略**
大促节点的用户已经处于"购物状态"，视觉任务是强化冲动购买的情绪，并清晰传递优惠力度。色彩要热烈，布局要有爆发感，促销数字要做到整张海报最突出的视觉元素。

避免的设计误区：
- 把品牌调性放在第一位而牺牲促销冲击力（大促节点品牌让位于促销）
- 过多装饰元素导致利益点被稀释
- 数字字号不够大，在缩略图状态下无法识别

**推荐风格**
大众品类：高饱和平面风、孟菲斯风、波普艺术风
高端品类：极简奢华风加克制促销感
国货品牌：国潮风或红金风结合现代设计

**色彩推导**
场景维度：强视觉冲击场景
主题维度：喜悦庆典主题 → 暖红、亮橙、金黄为主色，高饱和高对比
配色方案：双色撞色方案，促销数字和利益点用最高对比的色彩呈现，如深底浅字或亮底深字
特殊节点色彩参考：
- 双十一：红色加金色或橙色加红色，热烈喜庆
- 618：蓝色加橙色（京东配色系统）或品牌主色加金色
- 年货节：红金为主，春节氛围
- 情人节促销：玫瑰红加香槟金

**创意参考方向**
- 比例颠覆：促销数字放大到超常规尺寸，占据画面核心视觉
- 爆炸性构图：从中心向四周放射，营造爆炸开场感
- 情绪具象化：把抢购的爽感、优惠的惊喜感转化为视觉动态

---

### 1.2 品牌自营促销海报

**使用场景**
品牌官方渠道（公众号、微博、微信群）发布的促销活动，不依附于平台大促，更注重品牌调性的维护。

**创意策略**
品牌自营促销和电商大促的视觉语言不同。这里需要让用户感受到"这是品牌给我的专属优惠"而非"清仓甩卖"。促销感要克制，品牌感要保留，可以用"限时礼遇""会员专享"等高级感词汇替代"大甩卖""骨折价"。

产品调性决定促销视觉语言：
- 高端品牌：用极简留白、黑金配色、精致排版传递"限时高端礼遇"
- 中端品牌：视觉冲击力与品质感并重，促销数字突出但不失精致
- 年轻品牌：可以用更活泼的视觉语言，孟菲斯风或撞色都适合

**推荐风格**
高端品牌：极简奢华风、简约风
中端品牌：写实风加促销元素
年轻品牌：孟菲斯风、平面风、波普艺术风

**色彩推导**
场景维度：品质感与信任感场景为主，兼顾强视觉冲击
主题维度：根据品牌调性选择
- 高端品牌促销 → 神秘高端主题 → 深色背景加金色，中性色加强调色方案
- 中端品牌促销 → 喜悦庆典加专业信任主题 → 品牌色为主加促销强调色
- 年轻品牌促销 → 活力年轻主题 → 高饱和撞色，双色撞色方案
配色方案：高端用中性色加强调色，中端用主色加点缀，年轻品牌用双色撞色

**创意参考方向**
- 极简压迫构图：产品放大，留白克制，用精准排版传递高级促销感
- 张力构图：产品偏一侧，利益点文字占据另一侧，有设计感
- 局部叙事：用产品局部细节的精致感来支撑促销行为的合理性

---

### 1.3 节日限定促销海报

**使用场景**
春节、中秋、情人节、妇女节、圣诞节等节日节点结合的促销活动，需要同时传递节日氛围和促销利益。

**创意策略**
节日限定促销有双重任务：节日感和促销感。不能只做成促销海报加节日装饰，而是要让节日氛围和促销行为产生有机连接。找到节日情感与产品/促销之间的内在关联，是创意突破口。

节日感和促销感的比例参考：
- 传统节日（春节、中秋）：节日感60%促销感40%，节日氛围是主视觉，利益点在视觉层级上略低于节日元素
- 购物节日（情人节、妇女节、双十一）：促销感60%节日感40%，利益点是主视觉，节日元素作为装饰背景

**推荐风格**
传统节日：红金风、国潮风、新中式风
情人节：极简奢华风、简约风
西方节日：孟菲斯风、波普艺术风

**色彩推导**
场景维度：文化感与仪式感场景（传统节日）或强视觉冲击场景（购物节日）
主题维度：
- 春节促销 → 喜悦庆典主题 → 红金为主色，暖橙点缀，主色加点缀方案
- 中秋促销 → 喜悦庆典加浪漫美好主题 → 深蓝月色加金色，渐变色方案
- 情人节促销 → 浪漫美好主题 → 玫瑰红加香槟金，渐变色或双色撞色方案
- 圣诞促销 → 喜悦庆典主题 → 深红加金绿，主色加点缀方案

**创意参考方向**
- 情绪具象化：把节日情感视觉化，不要只堆砌节日符号
- 矛盾融合：产品与节日场景的意外组合，制造记忆点
- 比例颠覆：节日核心元素放大到撑满画面，产品和利益点嵌入其中

---

### 1.4 活动Banner

**使用场景**
网站首页、APP开屏、电商店铺首页、公众号头图等位置的横版活动宣传图，通常是横版宽图，展示时间短，需要快速传递核心信息。

**创意策略**
Banner的展示时间极短，用户停留不超过2秒。视觉层级必须极度清晰：第一眼看到活动主题，第二眼看到利益点，第三眼有行动引导。元素不能多，多了反而什么都没传递到。

Banner类型区分：
- 纯品牌Banner：无明确利益点，传递品牌调性，视觉要大气克制
- 活动利益Banner：有明确优惠，利益点是视觉核心，行动引导必须有
- 新品上市Banner：产品是视觉核心，卖点文字简洁，传递新鲜感

**推荐风格**
品牌Banner：极简奢华风、简约风
活动利益Banner：根据品牌调性选择，有一定视觉冲击力
新品上市Banner：写实风或简约风，产品质感优先

**色彩推导**
场景维度：品质感与信任感场景（品牌Banner）或强视觉冲击场景（活动Banner）
主题维度：与品牌整体色调一致，活动Banner可在品牌色基础上加入活动强调色
配色方案：Banner色彩克制不超过三色，强调信息清晰，背景与文字对比度高

**尺寸规范**
PC端横版Banner：1920x600 或 1920x700
移动端Banner：750x400 或 750x300
公众号头图：900x500 或 900x383
开屏广告：1080x1920（竖版）或 1920x1080（横版）

**创意参考方向**
- 左右分区构图：左视觉右文字，或左文字右产品，信息层级清晰
- 极简压迫构图：产品居中放大，文字精简，大气有品牌感
- 深度层次构图：横版画面适合纵深感，制造空间延伸

---

## 二、促销海报文字层级与内容生成规则

### 2.1 促销海报的文字层级原则

促销海报的文字有严格的视觉层级要求，必须按重要性递减排布：

第一层级（视觉最突出）：核心利益点
折扣数字、优惠金额、赠品价值等，这是用户判断要不要继续看的关键，字号最大或视觉最突出

第二层级：活动主题或产品名称
告诉用户这是什么活动或什么产品，字号次之

第三层级：活动说明
参与条件、时间限制、适用范围，中等字号，可读即可

第四层级：行动引导
立即购买、扫码参与、点击领券等，小按钮样式或小字

第五层级：品牌信息
品牌名称、渠道标识，最小字号，角落位置

### 2.2 各子场景文字层级

**电商大促海报**
- 核心利益点：折扣或金额，视觉最突出，数字要大
- 活动名称：双十一、618等节点名称，第二层级
- 参与条件：满减门槛、时间限制，第三层级
- 行动引导：立即抢购、点击领券，必须有
- 品牌名称或平台标识：最小字号

内容生成示例：利益点"满300减100"，活动名称"双十一超级购物节"，时间"11月1日-11日"，引导"立即领券"

**品牌自营促销海报**
- 活动主题或产品名称：第一层级，有品牌感的表达
- 核心利益点：第二层级，数字突出但不粗暴
- 活动说明：第三层级，简洁精准
- 行动引导：克制的表达，如"立即查看"而非"疯狂抢购"
- 品牌名称：显著位置，品牌感强

内容生成示例：主题"会员专属感恩回馈"，利益点"会员享8折 新品立减200"，说明"活动时间12月1日至7日"，引导"立即查看"，品牌"XX品牌"

**节日限定促销海报**
- 节日主题：传统节日的祝福语或节日名称，有情感温度
- 核心利益点：第二层级，与节日氛围融合的表达
- 活动说明：时间和参与方式
- 品牌名称：与节日祝福结合

内容生成示例：主题"中秋礼遇 月圆情深"，利益点"礼盒8折 买二送一"，说明"9月15日至17日"，品牌"XX品牌中秋献礼"

**活动Banner**
- 活动主题：简短有力，第一眼识别
- 利益点：简洁直接，数字突出（活动利益Banner）
- 行动引导：按钮样式，明确指向
- 品牌名称或Logo位置

内容生成原则：Banner文字极度精简，主题加利益点加引导，总字数不超过20字

---

### 2.3 文字内容生成原则

用户未提供文字时按以下原则生成：

核心利益点：必须是具体的数字或利益描述，不能模糊（"超值优惠"不如"满200减50"清晰）；如用户未提供具体数字，写"限时特惠"或"会员专享折扣"作为占位

活动主题：根据促销类型和品牌调性推断，大促节点直接用节点名称，品牌自营活动起一个有品牌感的活动名称

时间信息：如用户未提供，写"限时特惠 时间另行通知"

行动引导：必须有，根据渠道推断合适的引导语，电商用"立即抢购"，品牌自营用"了解详情"，线下活动用"扫码报名"

---

## 三、促销海报高频视觉元素参考

**营造促销氛围的元素**
爆炸感：放射状光线、爆炸形状、飞散的彩纸
紧迫感：倒计时视觉、沙漏、箭头向下
热烈感：暖色光晕、烟火、彩带飘落
数字强化：超大折扣数字、价格标签、比较划线

**节日装饰元素（按节点）**
春节：红包、灯笼、烟花、祥云、福字、春联
中秋：月亮、兔子、月饼、桂花、灯笼
情人节：玫瑰、心形、丝带礼盒、香槟
双十一：购物袋、礼盒堆叠、金币、星星闪光
圣诞：麋鹿、雪花、礼物盒、圣诞树、铃铛

**品质感促销元素**
克制的金色装饰、精致的边框、高光材质
简洁的几何图形、品牌专属纹样

---

## 四、促销海报常见尺寸

竖版海报（线上分享）：750x1334 或 1080x1920（9:16）
正方形（社交媒体）：1080x1080（1:1）
横版Banner：1920x600 或 750x400
公众号封面：900x500
电商活动主图：800x800（1:1）
海报打印版：A3（297x420mm）或A4（210x297mm），分辨率300dpi

如用户未说明尺寸，根据使用渠道推断：线上分享默认竖版9:16，社交媒体默认1:1，网页Banner默认横版。
