# 产品概念图与产品海报场景

## 场景说明

产品视觉是产品与用户之间的第一次视觉对话。产品概念图和产品海报的核心任务不是展示产品长什么样（说明书干这个），而是传递产品存在的意义——它能带来什么改变、代表什么价值观、让用户感受到什么情绪。

**产品概念图与电商主图的根本区别**
电商主图服务于购买决策，信息明确，说服逻辑直接。产品概念图服务于品牌认知和情感连接，可以更抽象、更有创意、更注重情绪传达，不需要在单张图内完成说服任务。

---

## 一、子场景识别与创意策略

### 1.1 产品独立展示图（Product Shot）

**使用场景**
品牌官网的产品页、产品发布会素材、媒体公关图、产品手册。产品本身是绝对主角，要传递产品的质感、细节和设计美感。

**创意策略**
产品独立展示图的创意空间在于：如何用背景、光线、角度和道具，最大化产品本身的视觉价值。

极简白底展示：让产品形态和细节无干扰地被看见，适合工业设计感强或造型复杂的产品
色彩背景展示：用与产品形成对比或呼应的色彩背景，让产品的颜色和材质更突出
质感特写展示：微距视角放大材质纹理、工艺细节、关键部位，传递产品的品质感
多角度展示：从正面、侧面、俯视、仰视多个角度展示产品，让用户在脑海中建立产品的三维形态

**光线是产品独立展示图的核心创意变量**
硬光（直射光）：强化产品的轮廓感和材质反射，适合金属、玻璃等高反射材质
柔光（漫射光）：均匀呈现产品颜色和细节，适合大多数产品的基础展示
逆光或侧逆光：为产品边缘制造光晕，传递产品的轻盈感或神秘感
聚光：戏剧性地突出产品主体，压暗周边，制造舞台感

**色彩推导**
场景维度：品质感与信任感场景为主
主题维度：与产品品类和品牌调性一致
- 3C数码产品 → 专业信任主题 → 深黑、太空灰、冷白，科技质感
- 美妆护肤产品 → 浪漫美好主题 → 裸粉、珍珠白、玫瑰金，精致感
- 食品饮料产品 → 自然健康加喜悦庆典主题 → 暖橙、奶白、草木绿，食欲感
- 奢侈品/高端产品 → 神秘高端主题 → 深色背景加金属光泽，极致质感
配色方案：主色加点缀方案，背景色衬托产品而非与产品竞争

**推荐风格**：写实风、极简奢华风

**创意参考方向**
- 极简压迫构图：产品居中或偏位，大面积留白，让产品呼吸
- 对称构图：产品正面对称展示，强调设计美感和工整感
- 微距特写构图：产品关键部位极度放大，材质和工艺"说话"

---

### 1.2 产品生活场景图（Lifestyle Shot）

**使用场景**
品牌社交媒体、产品故事页、品牌Lookbook。产品融入真实生活场景，传递"使用这个产品的人的生活状态"，建立用户对产品生活方式价值的情感连接。

**创意策略**
生活场景图不是把产品放进一个场景那么简单，而是构建一个完整的生活氛围，产品是这个氛围的有机组成部分。用户看到图时想的不是"这个产品放在那里"，而是"我想要这样的生活"。

场景真实性：背景要真实，道具要有生活感，光线要自然，不能让人感觉是刻意布置的拍摄场景
产品与场景的关系：产品要"属于"这个场景，不能像是后期PS进去的外来物
人物的处理：有人物时，人物的状态和情绪要与场景氛围一致，背影和侧影往往比正面更有故事感

**场景类型与创意方向**

家居生活场景
适用产品：家电、家居用品、个护产品、美妆
场景元素：温暖的室内光线、木质或大理石台面、绿植、书籍、咖啡杯
视觉关键词：温馨、精致、有生活感

户外自然场景
适用产品：户外装备、运动产品、饮料食品、护肤（防晒类）
场景元素：自然光、草地、山川、海边
视觉关键词：自由、健康、开阔

商务/职场场景
适用产品：数码设备、商务用品、咖啡饮料
场景元素：简洁的办公桌面、笔记本电脑、城市背景
视觉关键词：效率、专业、品质

**色彩推导**
场景维度：亲和力与温度感场景
主题维度：以场景情绪为主导，产品色彩融入场景而非主导场景
配色方案：场景自然色彩为基础，产品作为视觉重心但色调与环境协调

**推荐风格**：写实风、自然有机风

**创意参考方向**
- 深度层次构图：前景道具虚化，中景产品清晰，远景场景延伸
- 局部叙事：通过场景中一个有温度的细节暗示整个生活状态
- 框中框构图：利用场景中的自然框景元素（窗框、门框）为产品创造画中画

---

### 1.3 产品概念视觉图（Concept Visual）

**使用场景**
产品发布会主视觉、品牌概念传播、设计奖项参赛作品、产品理念视觉化。目的不是展示产品长什么样，而是传递产品背后的设计理念、品牌哲学或产品带来的情感体验。

**创意策略**
概念视觉图有最大的创意自由度，可以突破现实逻辑，用隐喻、象征、超现实手法来传递产品的精神内核。

核心问题：这个产品代表什么？它改变什么？它属于什么世界观？把这个答案转化为一个有力量的视觉意象，这就是概念视觉的创意核心。

常见的概念视觉手法：
场景置换：把产品放入一个意想不到的场景，制造视觉张力，暗示产品的跨界属性
比例操控：改变产品与环境的比例关系，产品放大或缩小，制造超现实感
元素分解：把产品拆解为构成元素，展示产品的成分、材料或技术逻辑
情绪可视化：把产品带来的情绪或体验转化为具象的视觉意象

**色彩推导**
场景维度：根据概念所传达的情绪推导，无固定场景维度
主题维度：与产品理念高度匹配，概念视觉的色彩可以比其他类型更大胆
配色方案：渐变色方案或大胆的双色撞色方案，概念图的色彩是主动的情绪传递者

**推荐风格**：概念艺术风、极简奢华风、超现实风

**创意参考方向**
- 场景置换：产品出现在意想不到的环境中，制造认知冲突和视觉张力
- 比例颠覆：产品放大到撑满画面，或缩小到成为宏大场景中的一个微小元素
- 元素爆炸：产品分解为构成元素向四周扩散，传递产品的技术或成分故事

---

### 1.4 产品海报（Product Poster）

**使用场景**
产品发布海报、产品宣传海报、产品限定款海报。兼顾产品展示和品牌情绪传递，通常有完整的文字信息层级。

**创意策略**
产品海报要在展示产品的同时传递品牌调性，是产品独立展示图和品牌海报之间的中间地带。

视觉主导型：产品图占据画面主导，文字为辅，适合视觉本身就有强说服力的产品
文案主导型：有力量的文案是视觉核心，产品图是文案的视觉注脚，适合需要用语言建立认知的产品
情绪主导型：氛围和情绪是最大视觉，产品出现在情绪场景中，适合生活方式类品牌

**文字层级（产品海报）**
产品名称或系列名：视觉最突出层级
核心卖点或品牌主张：第二层级，用一句话传递产品价值
产品规格或参数（如有）：第三层级，辅助信息
品牌名称：固定位置，视觉存在但不抢主角

**色彩推导**
场景维度：根据产品品类，参照1.1的品类色彩推导
配色方案：产品主色系主导，品牌色系为框架

**推荐风格**：与产品品类对应的推荐风格，参照1.1

**尺寸规范**
竖版海报：A3（297x420mm）、A2（420x594mm）
横版海报：16:9（1920x1080px）
方形：1:1（1080x1080px）

**创意参考方向**
- 张力构图：产品偏一侧，文案占据另一侧，产品和文案形成视觉对话
- 极简压迫构图：产品居中放大，文字精简，留白传递品质感
- 深度层次构图：产品在有景深的场景中，前后层次传递生活感

---

### 1.5 新品发布视觉

**使用场景**
新产品上市时的发布主视觉，通常用于发布会现场、官网首页、社交媒体发布首图。是产品与市场的第一次正式见面，需要制造"这个产品值得期待"的强烈第一印象。

**创意策略**
新品发布视觉有三种主要策略：

揭幕式：产品从某种遮盖或黑暗中"诞生"，制造仪式感和期待感
对比式：新品与旧品或现有产品的对比，强调进化和突破
宣言式：产品加一句强有力的品牌宣言，用语言定义产品的意义

**色彩推导**
发布视觉的色彩通常比日常产品图更戏剧化，更倾向于神秘高端或力量突破主题，暗色背景加高光是新品发布的经典视觉语言

---

## 二、产品视觉通用规范

### 2.1 产品图的参考图调用规则

产品独立展示图和生活场景图：【图生图：商品图】，产品外观、颜色、品牌标识必须忠实于参考图
产品概念视觉图：可以用【图生图：商品图】作为起点，但允许创意性改变产品的环境和视觉处理
新品发布视觉：通常用【图生图：商品图】，重点在背景和光效的创意处理

### 2.2 不同材质的光线处理

金属材质：侧光或背光，强调反射和高光，传递硬朗质感
玻璃/透明材质：逆光或背光，利用透光性制造晶莹感
皮革/织物：柔光，强调纹理细节，避免强高光
哑光材质：均匀漫射光，避免反光，展示纯色质感
发光产品（屏幕、灯具）：暗背景，让产品自身的光成为主光源
