# 摄影风格图场景

## 场景说明

摄影风格图是用AI生成技术模拟真实摄影的视觉效果，目标是生成"看起来像是用相机拍摄的"图片。与其他AI视觉生成场景相比，摄影风格图追求的是写实性和"相机存在感"——有明确的光学特征（景深、镜头畸变、焦外虚化），有真实的质感（皮肤毛孔、布料纤维、自然光线波动），有摄影的偶然性（轻微的运动模糊、自然的光影变化）。

---

## 一、摄影类型识别与创意策略

### 1.1 人像摄影风格

**适用场景**
人物肖像、时尚摄影、生活方式人像、情绪人像。

**注意事项**
人像摄影风格图中的人物为虚构人物，不生成任何真实人物的肖像。

**摄影参数设定**
镜头焦段：85mm（人像标准焦段，轻微背景压缩，面部不变形）或 50mm（更自然的透视）
光圈：f/1.4-f/2.8（浅景深，背景虚化，人物突出）
快门：1/200s以上（冻结面部细节，无运动模糊）

**光线类型与人像效果**

自然光人像（窗边光）：
光线方向：来自侧面窗口，形成单侧光
视觉效果：柔和的明暗过渡，皮肤质感自然，有生活温度
适用场景：真实感人像、生活方式人像

棚拍光（人工布光）：
经典三点布光：主光、补光、轮廓光的标准配置
视觉效果：立体感强，光影精确，专业感
适用场景：商业人像、时尚摄影

户外自然光人像：
黄金时刻（日落前一小时）：低角度暖色光，面部有金色光晕
阴天漫射光：均匀柔和，无硬阴影，皮肤色彩真实
逆光：人物轮廓有光晕，有梦幻感，面部略暗（需补光）

**风格类型**
时尚人像：精准的构图和光线，服装是重要视觉元素，整体有杂志质感
胶片人像：胶片颗粒感，低对比，偏暖或偏绿的特定色调，有年代感
情绪人像：情绪和感受优先于人物外貌，光线和构图服务于情绪
街头人像：真实环境中的自然状态，决定性瞬间，无摆拍感

**色彩推导**
人像摄影的色调通常由以下决定：光线温度（暖/冷）、后期风格（电影调色/日系/德系）、拍摄环境
暖色人像（黄金时刻、棚拍暖光）：橙黄调，皮肤温暖，整体亲和
冷色人像（蓝调户外、白天阴影）：蓝灰调，有疏离感，时尚感
低对比胶片调：中间调压缩，黑位提亮，有胶片年代感

**创意参考方向**
- 浅景深虚化：人物清晰，背景形成美丽的散景（Bokeh），人物与背景有清晰分离
- 逆光轮廓：人物站在光源前，轮廓发光，面部轻微曝光不足，有神秘感
- 环境人像：人物在真实环境中，与环境有交互关系，不是孤立的人物展示

---

### 1.2 风景/自然摄影风格

**适用场景**
自然风景、城市风景、旅行摄影、星空摄影、微距自然。

**摄影参数设定**
风景摄影通常用小光圈（f/8-f/16）保证全景清晰
快门速度根据情境变化（长曝光拍瀑布/星轨，快门冻结飞溅的水滴）
广角镜头（16-24mm）展现宏大感，长焦（70-200mm）压缩景深制造层次

**风景摄影类型与视觉方向**

自然风景：
黄金时刻：低角度暖色阳光，长影子，天空色彩丰富（橙红紫）
蓝调时刻（日出前/日落后）：天空深蓝，有神秘宁静感
风暴光线：云层中的戏剧性光束，强明暗对比，有力量感

城市/建筑摄影：
蓝调夜晚：建筑灯光开启，天空还有最后一抹蓝，冷暖对比美丽
长曝光轨迹：车流光轨，制造动感和时间流逝感
几何构图：建筑的线条和对称感，有设计感的视角

星空/夜间摄影：
银河：深蓝紫的天空，密集的星点，通常配合前景剪影（山、建筑、人物）
星轨：星星的圆弧轨迹（长曝光效果），时间感强
光绘：手电筒或光源在长曝光中制造的光绘效果

微距摄影：
极浅景深：只有焦点处极小区域清晰，背景完全虚化
被摄对象：花朵、昆虫、水珠、食物细节
光线：侧光或透射光，强化微距对象的质感

**色彩推导**
风景摄影的色调主要由时间和天气决定：
黄金时刻：暖橙、玫瑰红、金黄，浓郁而有层次
蓝调时刻：深蓝、冷紫、有宁静感的低饱和
阴天：低对比、低饱和，但细节丰富，有静谧感
夜景：暖色人工光加冷蓝天空，强烈的色温对比

---

### 1.3 产品/静物摄影风格

**适用场景**
产品摄影、食物摄影、静物艺术摄影。

**摄影参数设定**
通常用中等焦段（50-100mm）避免畸变
光圈根据景深需求：f/2.8-f/5.6（局部虚化）或f/8以上（全部清晰）

**产品/静物摄影类型**

极简产品摄影：
纯白或单色背景，产品清晰呈现
布光均匀，无硬阴影，产品颜色准确
适用：商业产品图，电商主图

氛围产品摄影：
有场景感的背景（大理石台面、木质台面、布艺背景）
营造生活使用场景，有情绪温度
适用：生活方式产品图，品牌社交媒体

食物摄影：
食欲感是第一优先级，暖色侧光强化食物颜色
有机道具（木质托盘、亚麻布、新鲜香草）增加自然感
45度俯视是最通用的食物角度

**色彩推导**
纯白背景产品摄影：白色背景，产品颜色主导，光线均匀
氛围产品摄影：背景质感的颜色（木质暖棕、大理石冷灰）加产品颜色，整体有温度感
食物摄影：暖色光，食物本身的颜色最突出，背景色补充食欲感

---

### 1.4 纪实/街头摄影风格

**适用场景**
街头摄影、纪实类摄影、日常生活场景的真实感呈现。

**摄影特征**
纪实/街头摄影最重要的特质是"真实感"——像是真实发生的一个瞬间被恰好记录下来，没有摆拍的刻意感。

技术特征：
快速抓拍感（有轻微的不完美，如轻微的运动模糊、非完美构图）
自然光为主，无明显人工布光
有现场感的背景（繁忙的街道、真实的室内场景）
胶片质感处理（颗粒感、轻微的色偏）增加真实感

决定性瞬间：
情绪高点（笑声、专注、惊讶）
有叙事性的动作（握手、奔跑、挥手）
场景与人物的关系（人物在特定环境中有意义的存在）

**色彩推导**
街头摄影通常保留现场真实色调，不做过度调色
胶片风格：低对比，提亮黑位，有轻微的色偏（暖黄或冷绿）
黑白处理：纪实摄影的黑白版本有更强的时间感和情绪感

---

## 二、摄影风格图通用规范

### 2.1 摄影质感关键描述词

在提示词中传递摄影质感的关键描述：
光学质感：浅景深、散景虚化、镜头光晕、焦外虚化
相机质感：胶片颗粒、高感噪点、快门冻结动态
光线描述：黄金时刻光、窗边自然光、棚拍三点布光、逆光轮廓光
品质描述：商业摄影质感、杂志摄影级别、真实摄影感

### 2.2 摄影参数到提示词的转换

描述摄影风格图时，摄影参数要转化为视觉效果描述：
"f/1.4大光圈" → "背景大面积虚化成美丽的散景，主体与背景有清晰分离"
"黄金时刻" → "低角度温暖橙色阳光，有金色光晕，长影子"
"50mm标准镜头" → "自然透视感，无明显畸变，接近人眼视角"
"长曝光" → "运动物体形成拖尾或轨迹，静止物体清晰"
