# 包装设计概念场景

## 场景说明

包装设计是产品与消费者在货架上的第一次对话，也是产品进入用户家里后每天发生的品牌接触。包装的视觉任务有三层：在货架上被看见（从竞争中脱颖而出）、被选择（传递正确的价值信号）、被珍视（开箱和使用过程中的情感体验）。

**包装概念图与实际包装设计的区别**
本文件生成的是包装的视觉概念图——展示包装设计方向和视觉效果，通常是将平面设计渲染在3D产品形态上的效果图，或者包装在使用场景中的展示图。不是可以直接印刷的刀版文件。

---

## 一、子场景识别与创意策略

### 1.1 包装效果展示图（Packaging Mockup）

**使用场景**
包装方案确认时的效果预览、提案展示、社交媒体发布的包装视觉。将平面设计方案渲染在真实产品形态上，让客户看到最终效果。

**创意策略**
包装效果图的核心是让包装设计看起来真实可信，同时展示包装最好看的一面。

展示角度的选择：
四分之三俯视角：最常用的包装展示角度，能同时看到正面和侧面，立体感强
正面平视角：强调包装的正面设计，适合平面设计细节展示
组合展示：同一产品的多个包装（不同口味/颜色/规格）同框展示，展示系列感

背景与环境：
纯色或渐变背景：最大化包装本身的视觉呈现，适合提案和说明用途
生活场景背景：包装在使用环境中的自然状态，适合品牌传播用途
Studio摄影感背景：专业布光的摄影棚效果，适合官方产品图

**色彩推导**
场景维度：品质感与信任感场景（高端包装）或亲和力场景（大众消费品）
主题维度：完全由包装设计本身的色彩主导，背景色服务于包装色
配色方案：背景色通常选择与包装主色形成对比或呼应的颜色，让包装突出

**推荐风格**：写实风（产品感强）、极简奢华风（高端品牌）

**创意参考方向**
- 极简压迫构图：包装居中放大，背景干净，设计细节清晰可见
- 对称构图：多个相同包装左右对称排列，整体感强
- 深度层次构图：包装在前景，场景元素在背景，传递产品的使用状态

---

### 1.2 货架场景图（Shelf Scene）

**使用场景**
包装在零售货架上的视觉效果展示，用于零售商谈判、品牌传播、货架表现分析。

**创意策略**
货架场景图要回答一个问题：这个包装在货架上能不能被看见？货架是高度竞争的视觉环境，周边会有大量竞品。包装的差异化视觉要在这个环境中脱颖而出。

货架竞争力的视觉要素：
色彩辨识度：在周边大量产品中，这个包装的颜色是否足够独特
轮廓辨识度：包装的形态或图形在远处是否有辨识度
品牌标识的可见性：品牌名称在货架距离（约1-2米）下是否清晰可读

**创意参考方向**
- 正面货架陈列构图：一排产品从正面展示，突出货架面的整体视觉效果
- 货架角度透视构图：从侧面或斜角展示货架，更接近真实购物者的视角

---

### 1.3 开箱体验视觉（Unboxing Visual）

**使用场景**
电商品牌的包装体验展示、社交媒体开箱内容、礼盒包装的体验设计。

**创意策略**
开箱体验视觉要传递"拆开这个包装的一瞬间的惊喜感和仪式感"。这是近年品牌包装设计越来越重视的维度——包装不只是保护产品，更是品牌体验的一部分。

开箱场景的视觉元素：
外箱：第一印象，品牌标识要有辨识度
内衬与填充：高端品牌用丝绒、棉纸、定制内托，传递被精心呵护的感觉
产品露出的方式：产品在包装中的位置和角度，让第一眼看到产品时有惊艳感
随附物品：卡片、礼品袋、样品，细节传递品牌用心程度

**构图特点**
俯视开箱构图：从正上方俯视打开的包装，清晰展示内容物的排列方式
45度开箱构图：斜角展示，立体感更强，更接近真实开箱体验
过程感构图：展示包装逐层打开的过程，有叙事感

---

### 1.4 礼盒包装视觉

**使用场景**
节日礼盒、限定礼盒、品牌礼物套装。礼盒包装兼具产品功能和礼品价值，视觉要传递"值得送给重要的人"的珍贵感。

**创意策略**
礼盒的视觉任务与普通包装不同：送礼者在购买时，脑海中想的是收礼者打开礼盒时的反应。礼盒视觉要让送礼者感受到"打开这个礼盒的人会很惊喜"。

礼盒视觉的核心要素：
包装材质感：哑光纸、烫金、特种纸的质感在视觉上要有高档感
色彩与节日氛围：节日礼盒要有与节日对应的色彩，但要有品牌调性的克制
开箱惊喜感：内部的陈列设计要有视觉冲击，第一眼打开的感受

**节日礼盒色彩推导**
春节礼盒：红金为主，国潮元素，喜庆但有品牌质感
中秋礼盒：深蓝加金色，月色感，高端克制
情人节礼盒：玫瑰红加香槟金，浪漫精致
圣诞礼盒：深绿加金色加红色点缀，温暖喜庆

---

### 1.5 包装系列视觉（Packaging Series）

**使用场景**
同一品牌下多个SKU（不同口味、颜色、规格）的系列包装展示。展示系列包装的整体视觉协调性和差异化。

**创意策略**
系列包装的视觉挑战是：每个单品要有独立的差异化识别（用户能区分口味或规格），同时整个系列要有统一的家族感（用户能一眼认出都是同一品牌）。

系列感的视觉建立方式：
统一的版式结构：所有产品使用相同的排版框架，差异化只在颜色和图案
统一的品牌元素：品牌名称、品牌符号在所有产品上的位置和比例固定
色彩系统化：不同SKU用不同颜色区分，颜色之间有协调的系统感（同色系渐变，或互补色系统）

**展示方式**
系列排列展示：所有产品并排展示，突出系列感和色彩体系
扇形展开展示：多个产品以扇形或弧形排列，视觉上有展开和对比感
组合场景展示：系列产品在真实使用场景中集体出镜

---

## 二、包装视觉规范

### 2.1 材质质感表现

包装概念图需要精确传递材质感，不同材质的视觉处理：
哑光纸：漫射光，无高光反射，颜色饱和均匀
光面/UV印刷：有定向反射高光，图案有光泽感
烫金/烫银：金属反射光，局部高光，与周边形成材质对比
特种纸（磨砂、布纹）：纹理细节在侧光下明显
玻璃/透明材质：透光性，背景颜色透过包装可见

### 2.2 包装图的参考图调用规则

如用户提供了包装设计稿：【图生图：商品图】，保留设计稿的颜色、图案、文字，改变背景和展示角度
如用户只描述包装风格：【文生图】，根据描述生成包装效果
如用户提供了品牌参考图：【图生图：场景参考图】，参考品牌调性和色彩风格，不直接复制
