# 户外广告（OOH）场景

## 平台特征与创意底层逻辑

户外广告（Out of Home）在公共空间中展示，观众处于移动或短暂停留状态，注意力极度分散。OOH的第一法则：**3秒传达，5米可读**。所有创意决策都服务于这个前提——信息极度精简，视觉有压倒性冲击力，在嘈杂公共环境中能被瞬间识别。

**OOH与数字媒体的根本差异**
数字媒体可以用细节和信息量说服用户，OOH只能靠一瞬间的视觉冲击留下印象。OOH不追求信息传达的完整性，而是追求品牌印象的强烈程度。文字越少越好，画面越简单越有力量。

**OOH创意的核心矛盾**
品牌想说的话很多，但观众给的时间极少。所有OOH创意的核心工作是做减法——从所有想说的事情里找出那一件最重要的事，用最简单的视觉方式说清楚。

---

## 一、子场景识别与创意策略

### 1.1 大型户外广告牌（Billboard）

**使用场景**
高速公路、城市主干道、楼顶广告牌。观看距离50米以上，车速60-120km/h，有效观看时间3-5秒。是OOH中信息承载量最低、视觉冲击力要求最高的形式。

**创意策略**
文字极限是7个字，最理想是品牌名加一句话。超过7字的广告牌在高速行驶中无法被读完，多余的文字等于不存在。

视觉主体必须极度简单，一个强烈的画面元素胜过十个复杂元素。问自己：如果把这张图缩成一个邮票大小，还能识别出核心信息吗？能识别才算合格。

色彩对比要极强。广告牌要在阳光直射、阴天、夜晚等不同光线条件下都清晰可见。低对比度配色在户外光线变化下会消失。

品牌标识要放在固定的显眼位置，通常右下或左上，大小不能牺牲给创意。

**广告牌内容类型与视觉方向**

品牌形象广告牌
目标是品牌曝光和情感印象，不推销具体产品
视觉：一张有极强情绪感染力的图片加品牌名，文字最少
色彩：品牌主色系，视觉情绪与品牌价值观一致

产品上市广告牌
目标是让路人知道有这个新产品
视觉：产品图加品牌名加极简的产品名称或一句话利益点
信息量：品牌名加产品名加一句话，不超过三个信息层

促销活动广告牌
目标是传递优惠信息，驱动线下到店或线上搜索
视觉：核心利益数字（如"5折"）要做到整张海报最大的视觉元素
信息量：折扣加品牌加时间或门店，文字略多但数字必须极大

**色彩推导**
场景维度：强视觉冲击场景
配色方案：双色强对比方案，背景色和主视觉色的对比度要达到极致。黑白、红白、黄黑是经典高对比组合，在各种光线条件下都保持可读性

**推荐风格**：极简奢华风、简约风、平面风

**尺寸规范**
标准横版：14:3（约840x180cm）
竖版：3:4 或 9:16
横版宽屏：16:3 或更宽

**创意参考方向**
- 极简压迫构图：主视觉放大到撑满画面，文字只保留品牌名和一句话
- 比例颠覆：把产品或人物放大到超常规尺寸，制造震撼感
- 留白力量：大面积留白加一个极简视觉元素，反差产生记忆点

---

### 1.2 地铁广告（站内/车厢）

**使用场景**
地铁站台、站厅、车厢内壁。观众处于等待或乘坐状态，有5-30秒停留时间，比高速公路广告牌有更多信息承载空间。且有大量重复曝光机会（每天上下班路过同一广告）。

**创意策略**
地铁广告是OOH中少数可以讲一个完整小故事的场景。重复曝光的特性让用户在第一次看到时可以接受较高的信息密度，因为之后的每次路过都是对信息的强化记忆。

地铁用户通常低头看手机或发呆，强视觉的第一帧必须能打断这种状态。第一秒要抓住注意力，接下来的30秒才能传递更完整的信息。

地铁灯箱广告的光源是背光，色彩会比设计稿更鲜艳更饱和。设计时要适当降低饱和度预留这个余量，否则印刷后会过于刺眼。

**地铁广告类型与创意方向**

站台灯箱（通道连续多幅）
多幅连续展示，有讲故事的空间
创意方向：连续多幅可以讲一个故事的不同段落，或同一品牌的不同产品，整体构成一个视觉叙事

站厅大幅灯箱（单幅）
单张大图，有较长停留时间
创意方向：完整的故事性画面，可以有更多信息层级，人物表情和场景细节可以更丰富

车厢内贴（横版宽幅）
观众距离极近（50cm以内），停留时间长（整段行程）
创意方向：可以有更多文字和细节，适合有阅读价值的内容，如科普类广告、长文案广告

包柱广告（环绕式）
圆柱形展示，设计要考虑环绕视觉效果
创意方向：利用环绕的特点做360度连续画面，或设计成"包裹"某个物体的视觉效果

**色彩推导**
场景维度：强视觉冲击场景，兼顾品质感（高端品牌地铁广告）
主题维度：与品牌调性一致，注意背光灯箱会增强色彩饱和度
配色方案：高对比方案为主，但比路边广告牌可以有更多色彩层次；设计稿饱和度适当降低10-15%以补偿背光增强效果

**推荐风格**：简约风、写实风、平面风

**尺寸规范**
地铁灯箱（标准）：1500x1000mm（3:2横版）
竖版灯箱：1000x1500mm（2:3竖版）
车厢贴纸：根据具体地铁型号，通常为超宽横版

**创意参考方向**
- 张力构图：主体偏一侧，另一侧留出大面积文字区或情绪延伸区
- 深度层次构图：地铁广告尺寸大，适合有纵深感的场景构图
- 连续叙事构图（多幅系列）：每幅图是完整场景，连续看是完整故事

---

### 1.3 楼宇电梯框架广告

**使用场景**
写字楼、商场、住宅楼电梯内广告框。观众距离近（50-100cm），停留时间30-120秒，是OOH中信息承载量最高的形式。高频重复曝光，同一用户每天看同一广告多次。

**创意策略**
电梯广告是OOH中唯一可以有较多文字的场景，观众无处可逃，有时间阅读。但即便如此，视觉层级依然要清晰——第一眼（1秒内）必须传递品牌和核心利益，后续10秒才是详细信息。

高频重复曝光意味着创意要有耐看性。太激进的视觉和太强的促销感会在每天多次曝光后令人厌烦。要找到一个"看了很多次还不烦"的视觉点——通常是有美感、有趣味或有思考价值的内容。

写字楼和住宅楼的受众差异大：写字楼受众是商务白领，偏专业感和效率感；住宅楼受众是家庭用户，偏生活感和温度感。

**电梯广告类型与创意方向**

写字楼电梯广告
受众：25-45岁上班族，购买力强，时间敏感
创意方向：专业感、效率感、品质感；B2B产品的有效触达场景；职场相关内容有高共鸣
色彩：品质感和信任感场景，专业主题色调，不能廉价

住宅楼电梯广告
受众：家庭用户，包括父母、年轻夫妇
创意方向：生活感、家庭温度感、实用价值；食品、家居、亲子类产品的有效场景
色彩：亲和力场景，温暖感色调

商场电梯广告
受众：消费者，购物决策中
创意方向：产品展示和即时消费引导；促销信息的有效场景
色彩：与产品调性一致，轻微促销感

**色彩推导**
场景维度：品质感与信任感场景（写字楼）或亲和力场景（住宅楼）
配色方案：比路边广告牌更克制细腻，可以有渐变色和多层次色彩，因为观众距离近能看到更多细节

**推荐风格**：简约风、写实风（根据品牌调性）

**尺寸规范**
标准电梯框架：A3（297x420mm）或A4（210x297mm），竖版为主
框架外尺寸：通常为50x70cm 或 40x60cm

**创意参考方向**
- 中心构图：电梯框架是固定的小空间，中心构图最稳定最有存在感
- 极简压迫构图：产品或人物放大占满画面，文字精简但清晰
- 张力构图：适合有对话感或故事感的创意

---

### 1.4 商场大屏与数字OOH（LED屏）

**使用场景**
商场中庭LED大屏、地标建筑外墙屏、街头数字广告牌。通常循环播放多个广告，每条广告5-15秒。本文件聚焦静态画面设计（作为动态视频的关键帧或纯静态展示）。

**创意策略**
数字OOH的静态关键帧要在1秒内传递完整的品牌和核心信息，即使用户只看到一帧也有完整印象。商场大屏通常在高亮度环境下显示，色彩要有足够的亮度和对比度，否则在强环境光下会显得暗淡。

裸眼3D效果是近年数字OOH的流行趋势，关键在于利用屏幕边框制造"突破边界"的视觉错觉，设计时需要精确计算画面元素与屏幕边框的位置关系。

**商场大屏类型与创意方向**

商场中庭大屏
环境：购物状态的消费者，有购买决策意愿
创意方向：产品展示和品牌形象，与购物环境高度匹配；奢侈品和高端品牌的重要传播渠道
色彩：高亮度高对比，暗背景亮主体方案在商场强环境光下效果最佳

地标建筑外墙屏
环境：街头行人，低速行走或驻足
创意方向：城市地标级的品牌展示，视觉要有配得上地标位置的震撼感；裸眼3D效果在此场景冲击力最强
色彩：最高对比度方案，夜晚环境下高饱和色彩视觉效果极强

**色彩推导**
场景维度：强视觉冲击场景
配色方案：高亮度高饱和方案，暗背景亮主体；LED屏的色域比印刷更广，可以使用更鲜艳的色彩

**推荐风格**：科技风、极简奢华风、平面风

**尺寸规范**
商场大屏：根据具体屏幕尺寸，通常为16:9横版
地标外墙屏：根据建筑面积，通常为极宽横版或极高竖版

**创意参考方向**
- 极简压迫构图：主视觉撑满屏幕，无任何多余元素
- 比例颠覆：产品或人物放大到超常规尺寸，利用大屏的物理尺寸制造震撼
- 突破边框构图（裸眼3D）：主体元素"突破"屏幕边框进入现实空间的视觉错觉

---

### 1.5 公交站牌与街边灯箱

**使用场景**
公交站候车亭灯箱、街边单立灯箱、商业街道灯箱。观众有5-30秒停留时间（等公交），或3-5秒路过时间（步行）。

**创意策略**
公交站广告介于高速公路广告牌和地铁广告之间，有等待公交的用户会在短时间内仔细看，也有步行路过的快速观看。设计要同时满足两种观看场景：第一眼视觉冲击力强，进一步停留时有内容可看。

公交站广告的受众是步行人群和公共交通用户，通常是城市年轻人、上班族等，与高速公路广告牌的汽车用户人群有差异。

**色彩推导**
场景维度：强视觉冲击场景，兼顾亲和力（生活类产品）
配色方案：高对比方案，灯箱背光效果同地铁灯箱，需降低饱和度补偿

**尺寸规范**
公交站候车亭灯箱：1.8x1.2m（3:2横版）或1.2x1.8m（2:3竖版）
单立灯箱：根据具体尺寸，通常为1:2竖版

**创意参考方向**
- 张力构图：视觉主体偏一侧，另一侧核心文字信息
- 极简压迫构图：产品大图加极简文字

---

## 二、OOH视觉设计通用原则

### 2.1 文字密度规范

路边广告牌：最多7字，品牌名加1句话是极限
地铁广告（单幅）：最多20字，主标题加副标题加行动引导
电梯广告：最多50字，可以有完整的产品介绍
公交站灯箱：最多15字

### 2.2 视觉简化原则

每张OOH作品只传递一个核心信息，不要试图同时说多件事。信息越多，每条信息被记住的概率越低。
视觉元素不超过3个（品牌、主视觉、文字），多了就是视觉噪音。
背景要干净，主视觉和背景之间要有清晰的视觉分离，不能让主体消失在背景中。

### 2.3 色彩可见性原则

设计要在以下条件下都能清晰识别：强烈阳光直射、阴天漫射光、夜晚人工照明
避免低对比度配色，灰色系在户外光线变化下容易消失
背光灯箱（地铁、公交站）的色彩比设计稿更鲜艳，设计时适当降低饱和度预留余量
LED屏色域比印刷更广，可以使用更鲜艳的色彩

### 2.4 尺寸与距离的视觉关系

观看距离越远，文字要越大，细节要越少：
50米以上观看：只保留最大的视觉元素，文字最小可读字号在200pt以上
10-50米观看：可以有两个层级的文字，次要文字最小在60pt以上
1-5米观看（电梯）：可以有三个文字层级，最小字号20pt以上
