# 音乐封面与艺人宣传图场景

## 场景说明

音乐视觉是声音的第一个视觉入口。专辑封面在用户还没有听到一个音符之前，就在传递音乐的情绪和世界观。好的音乐视觉让听众在看到封面的瞬间，已经能感受到这张专辑大概是什么感觉——是治愈还是力量，是孤独还是喧嚣，是简单还是复杂。

**音乐视觉的特殊性**
本场景生成的是概念性音乐视觉，不生成真实艺人的肖像。如需展示人物，使用概念性人物形象、剪影或局部（背影、手、轮廓等）。如用户要求特定艺人，说明这一限制并提供替代方案。

---

## 一、子场景识别与创意策略

### 1.1 专辑/单曲封面

**使用场景**
数字音乐平台（流媒体）封面、实体专辑封面、单曲封面、EP封面。是音乐内容在各平台的核心视觉标识，决定用户的第一印象和点击决策。

**创意策略**
专辑封面的任务是用一个静态画面传递整张专辑的情绪世界。最好的专辑封面是"一看到这张图，就能感受到这张专辑是什么氛围"——不需要文字说明，图片本身就是音乐情绪的完整传递。

**音乐风格与视觉方向**

流行/Pop：
视觉语言：清晰的人物形象（概念性）或强烈的色彩画面，有明确的记忆点
色调：高饱和或对比鲜明的配色，有流行感的视觉冲击力
设计感：简洁但有识别度，在流媒体小图状态下依然清晰

电子/EDM：
视觉语言：抽象几何、光效粒子、数字化视觉元素
色调：霓虹色系（青紫蓝），高对比，未来感
光效：强烈的发光效果，激光、频谱、波形可视化

摇滚/金属：
视觉语言：强力量感，黑暗感，有冲突感的构图
色调：深黑加血红/骨白，高对比，有粗粝感
质感：做旧感、撕裂感、噪点质感

民谣/Indie：
视觉语言：手工感、自然感，有情绪温度的生活场景
色调：低饱和的自然色调，胶片感，温柔的光感
质感：胶片颗粒，褪色感，真实感

古典/器乐：
视觉语言：优雅的抽象构图，乐器的视觉化，音符/波形的图形化
色调：奶白、深蓝、金色，有质感和年代感
设计感：克制优雅，不过度装饰

嘻哈/Hip-hop：
视觉语言：街头感、潮流感、个性强烈的人物姿态（概念性）
色调：高对比，金色/黑色/白色的经典组合，或高饱和撞色
字体：粗体设计感文字是嘻哈封面的重要视觉元素

R&B/Soul：
视觉语言：感性、性感、有情绪深度的人物或场景
色调：暖橙、深红、蜜糖黄，光感性感温暖
质感：丝绒感、暖光感，有触感的视觉处理

**色彩推导**
场景维度：根据音乐风格和情绪主题推导，无固定场景维度
主题维度：与音乐的情绪核心深度匹配，这是音乐视觉最重要的设计原则
配色方案：专辑封面的色彩通常有极强的个性，可以比其他商业视觉更大胆

**推荐风格**：根据音乐风格对应选择，流行用写实风/平面风，电子用科技风，独立用自然有机风

**尺寸规范**
数字封面：1:1正方形，最小1000x1000px，标准3000x3000px
实体CD封面：12x12cm（正方形）
实体黑胶封面：31.4x31.4cm（正方形）

**创意参考方向**
- 极简压迫构图：一个强烈的视觉元素占满画面，无干扰，记忆点极强
- 抽象情绪表达：用色彩、纹理、光效等抽象元素传递音乐情绪，不需要具象形象
- 符号化表达：用一个强烈的视觉符号代表整张专辑的主题

---

### 1.2 巡演/演唱会海报

**使用场景**
演唱会/巡演的宣传海报、音乐节海报、现场演出宣传图。需要传递演出的现场感和期待感，同时清晰传递时间地点信息。

**创意策略**
演出海报的任务是让看到海报的人产生"我要去现场"的冲动。视觉要能传递演出现场的情绪氛围——是宏大震撼的还是亲密治愈的，是疯狂躁动的还是深情动人的。

演出海报文字层级：
艺人名称/演出名称：视觉最突出，字号最大
时间信息：日期，字号次之，清晰可读
地点信息：场馆名称，字号次之
票务信息：购票渠道/价格，第三层级
主办信息：最小字号，底部

**演出类型与视觉方向**

流行/偶像演唱会：
概念性人物形象加华丽的舞台灯光效果
色调：高饱和，流光溢彩，有梦幻感
视觉情绪：期待感、梦幻感、盛大感

摇滚音乐节：
能量爆发感，多乐队/艺人的视觉并排
色调：黑色加强烈的高饱和色，有力量感
视觉情绪：躁动、自由、力量

电子音乐节：
激光和频闪效果，抽象光效背景
色调：深黑加霓虹色（青紫蓝），超未来感
视觉情绪：迷幻、亢奋、未来感

古典音乐会：
优雅的音乐厅场景或乐器视觉化
色调：金色加深色背景，高贵感
视觉情绪：典雅、仪式感、高格调

**色彩推导**
场景维度：文化感与仪式感场景（古典）或强视觉冲击场景（流行/摇滚/电子）
配色方案：与艺人/乐队的视觉品牌保持一致，演出场景的灯光色通常是主色系

---

### 1.3 单曲/MV宣传图

**使用场景**
新歌发布的宣传图、MV上线预告图、社交媒体推广配图。

**创意策略**
单曲宣传图的视觉要传递这首歌的核心情绪，同时包含足够的信息（歌名、艺人名、发布平台）。与专辑封面相比，单曲宣传图通常更直接传递这首歌特定的情绪，不需要代表整体风格。

**情绪类型与视觉方向**

失恋/悲伤情歌：
视觉：雨中场景、空旷的城市夜景、孤单的人物背影
色调：冷蓝、暗灰、低饱和，有压抑感
视觉情绪：孤独、心碎、思念

甜蜜/爱情歌曲：
视觉：温暖的自然光场景、双人互动的剪影
色调：暖橙、粉、金，温柔有爱意
视觉情绪：甜蜜、温暖、心动

励志/力量歌曲：
视觉：日出、山顶、突破障碍的意象
色调：金色、暖橙、明亮渐变，有希望感
视觉情绪：力量、突破、希望

---

### 1.4 音乐人/乐队品牌视觉

**使用场景**
音乐人/乐队的社交媒体主页视觉、个人品牌视觉系统、粉丝运营配图。

**创意策略**
音乐人品牌视觉要建立一个独特的视觉世界——听众在看到这些图片时，立刻能联想到这个艺人。视觉风格是艺人人设和音乐风格的延伸，需要有长期的一致性。

品牌视觉的核心要素：
独特的视觉符号或元素（艺人的标志性视觉）
固定的色调方向（艺人品牌色）
统一的质感处理（胶片感、数字感、手工感等）

---

## 二、音乐视觉通用规范

### 2.1 流媒体平台小图适配

音乐封面最重要的展示状态是流媒体平台的小图状态（约150x150px）。在这个尺寸下：
复杂的细节会变成噪点
文字通常无法阅读
只有色彩和大形状能被识别

设计时要在1:1正方形画布的缩略图状态下检验视觉效果，确保核心视觉元素在小图状态下仍有辨识度。

### 2.2 音乐视觉的参考图调用规则

专辑封面：通常为【文生图】，根据音乐风格和情绪描述生成
演出海报：通常为【文生图】，生成与演出氛围对应的视觉
如有特定的视觉参考（不涉及真实艺人肖像）：【图生图：场景参考图】
