# 信息图与数据可视化场景

## 场景说明

信息图的核心任务是让复杂信息变得易于理解和记忆。好的信息图不是把文字变成图片，而是找到信息的内在逻辑结构，用最匹配这个结构的视觉形式来表达，让用户看一眼就能理解如果读文字需要花几分钟才能理解的内容。

**信息图与普通配图的根本区别**
普通配图服务于情绪和氛围，信息图服务于理解和记忆。信息图的美感不是目的，而是手段——让用户愿意看、看得懂、记得住，才是真正的成功。

---

## 一、信息图类型识别与创意策略

### 1.1 流程图（Process Infographic）

**适用场景**
步骤说明、操作流程、工作流程、事件时间线、因果关系展示。

**核心设计逻辑**
流程图的视觉要传递"顺序感"和"因果关系"，用户看图要能清晰理解：这是第几步？下一步是什么？每步之间的关系是什么？

线性流程（A→B→C）：水平或垂直的箭头连接，方向明确，步骤编号显眼
循环流程（A→B→C→A）：圆形或环形排列，传递循环往复的逻辑
分支流程（如有则A，否则B）：树形或决策树结构，分叉清晰
时间线（过去→现在→未来）：水平时间轴，关键节点标注

**视觉设计要点**
每个步骤用统一的视觉容器（圆形、方形、六边形）呈现，容器大小和风格一致
箭头方向清晰，无歧义，连接关系一目了然
步骤编号要显眼，方便用户"在这里"定位
关键步骤可以用颜色或大小差异突出，但不超过两个重点步骤

**色彩推导**
流程图的色彩通常以主色为基础，步骤间用同色系深浅变化区分
强调重要步骤可以用对比色单独处理
整体背景干净（白色或浅灰），让步骤内容成为视觉主体

---

### 1.2 对比图（Comparison Infographic）

**适用场景**
两个或多个选项的对比（产品对比、方案对比、前后对比、优劣势对比）。

**核心设计逻辑**
对比图的视觉要传递"公平感"和"差异清晰"，用户看图要能立即识别哪里相同、哪里不同、哪个更好。

两项对比（A vs B）：左右对称是最直观的方式，中间可以有分隔线
多项对比（A vs B vs C）：表格形式最清晰，行是维度，列是对比项
前后对比（Before/After）：上下或左右排列，同一视觉处理方式，差异显而易见
优劣势对比（Pro/Con）：上下分区或左右分区，勾叉图标视觉上最直观

**视觉设计要点**
两项对比时，每侧的视觉处理方式要完全对称，避免一侧信息量明显多于另一侧
推荐的选项可以用颜色或视觉权重差异轻微突出，但要保持整体的公平视觉
表格型对比图的行列分隔线要足够细，不能喧宾夺主
关键差异数据要在视觉上最突出

**色彩推导**
两侧用不同颜色区分，通常是品牌主色vs中性灰，或互补色对
如有推荐项，推荐项用更鲜艳/更重的颜色，非推荐项用更淡的颜色

---

### 1.3 数据可视化图（Data Visualization）

**适用场景**
数量对比（柱状图）、比例关系（饼图、环形图）、趋势变化（折线图）、分布关系（散点图）、地理分布（地图）。

**核心设计逻辑**
数据可视化要让数字变得可感知。用户看到一个数字时往往没有直观感受，但看到一个高度是另一个两倍的柱子，立刻能感受到"两倍"的概念。图表类型的选择要匹配数据的逻辑类型。

图表类型选择原则：
对比不同项目的数量 → 柱状图（水平或垂直）
展示各部分占整体的比例 → 饼图或环形图（不超过5个部分，超过5个用堆叠柱状图）
展示随时间变化的趋势 → 折线图
展示两个变量之间的关系 → 散点图
展示地理分布 → 地图热力图

**视觉设计要点**
图表的核心数据要最突出（最高的柱、最大的扇区、关键的数据点）
坐标轴要简洁，刻度线能少则少，网格线用极浅的颜色
数据标签（数字）要直接标在图表元素上，不要让用户查坐标轴
颜色数量控制在3-5种，颜色过多会让图表难以解读
图表标题要直接说明"这个图说明了什么"，不是"什么数据的什么图表"

**色彩推导**
单一数据系列：品牌主色贯穿，深浅变化区分数量高低
多数据系列对比：互相区分的多色方案，颜色要在不同粗细和大小下都能区分
热力图：从冷色（低值）到暖色（高值）的渐变，直觉性强

---

### 1.4 结构关系图（Structure Infographic）

**适用场景**
组织架构、分类体系、知识框架、层级关系、模块组成。

**核心设计逻辑**
结构图要传递"层级感"和"归属关系"，用户看图要能理解：这个元素属于哪一层级？它与其他元素的关系是什么？整体有多少层级？

树状结构（由上而下的层级）：适合组织架构、知识分类
辐射结构（中心向外扩散）：适合核心概念加外延关系
矩阵结构（二维分类）：适合按两个维度分类的内容
嵌套结构（大圈套小圈）：适合包含关系、子集关系

**视觉设计要点**
层级差异用大小、颜色深浅或位置明确表达
连接线要简洁，直线优于折线，折线优于曲线
同一层级的元素要有统一的视觉处理（大小相同、颜色一致）
整体布局要留出足够的空间，避免元素拥挤

---

### 1.5 统计数据展示图（Stats Infographic）

**适用场景**
报告中的核心数据展示、调研结果发布、品牌数据背书、社会议题数据。

**核心设计逻辑**
统计数据展示图的目标是让关键数字被记住。不是把所有数据都放进去，而是选出最有冲击力的3-5个数字，用视觉强化它们的印象。

大数字展示：把最重要的数字放大到撑满该区域，是统计图最有效的手法
数字的视觉解释：用图标或小插图辅助理解数字的含义（例：3亿用户 + 人形图标群）
数字对比：用大小对比展示数字间的差距，比单独列出数字更有冲击力

**视觉设计要点**
最重要的数字在字号和颜色上要最突出
数字的单位和说明文字字号要明显小于数字本身
整体排版要有节奏感，大字和小字交替，不能所有数字字号一样
背景要干净，让数字成为绝对主角

---

### 1.6 指南/教程型信息图（How-To Infographic）

**适用场景**
操作指南、使用说明、保养指南、急救知识、生活技巧。

**核心设计逻辑**
指南型信息图的目标是让用户能照着做。清晰性是第一位的，美观是第二位的。如果用户看完图不知道该怎么做，这张图就失败了。

**视觉设计要点**
步骤编号要最显眼，用户在执行时需要快速定位"我在第几步"
每个步骤的操作动作要有图示（手势图、示意图、产品特写），文字只是辅助
重要的注意事项用醒目的视觉警示（红色、感叹号图标）
整体布局要方便用户边看边操作，不能需要频繁翻页或缩放

---

## 二、信息图通用规范

### 2.1 视觉层级原则

信息图的视觉层级通常有4层：
第一层（标题）：整张图要传递什么，字号最大，颜色最突出
第二层（关键数据/结论）：最重要的信息，字号次之
第三层（说明文字）：支撑关键信息的解释，中等字号
第四层（来源/注释）：数据来源和补充说明，字号最小，颜色最淡

### 2.2 颜色使用规范

信息图的颜色数量要控制：
单一主题信息图：1-2种颜色加灰色
多维度对比信息图：3-5种颜色，每种颜色对应一个维度
避免颜色超过6种，颜色越多信息图越难解读
颜色要有足够的对比度，确保文字在任何颜色背景上都可读

### 2.3 字体规范

信息图通常只用1-2种字体：
标题用粗体（强调力量感和权威感）
正文用常规字重（保证可读性）
数字字体选择数字形态清晰的字体，避免数字容易混淆的字体
最小字号：印刷版不低于8pt，数字版不低于14px

### 2.4 信息图的参考图调用规则

数据可视化图：通常为【文生图】，根据数据内容生成对应图表
品牌数据展示图：如有品牌产品图可用【图生图：商品图】辅助
地理分布图：【文生图】，生成地图底图加数据覆盖层
