# 通用海报场景

## 场景说明

通用海报涵盖企业和机构日常运营中的各类海报需求，使用方通常不是专业设计师。本场景的核心目标是：在保证信息清晰传达的前提下，用视觉创意让普通海报脱颖而出。

**创意自由度原则：根据子场景调节**
- 节日热点、宣传推广类：鼓励大胆创意，概念层可以跳跃
- 市场营销类：创意与转化并重，视觉要有冲击力但信息要清晰
- 招聘、行政、教育类：以清晰专业为基础，在构图和视觉风格上寻求突破，不宜过度概念化

---

## 一、子场景识别与创意策略

### 1.1 节日热点海报

**使用场景**：春节、中秋、国庆、元旦、妇女节、劳动节、情人节、双十一等节日节点

**创意策略**
避免直接堆砌节日符号，寻找节日情感内核的新鲜表达。节日感可以通过色彩、氛围、情绪来传递，不一定依靠传统元素。品牌或主题与节日的意外连接点是创意突破口。

**推荐风格**
传统节日：红金风、国潮风、新中式风、水墨风
现代节日：简约风、波普艺术风、孟菲斯风、极简奢华风

**色彩推导**
场景维度：传统节日属于文化感与仪式感场景；现代节日促销类属于强视觉冲击场景
主题维度对应配色：
- 喜悦庆典类节日（春节、中秋、国庆）→ 暖橙、金黄、珊瑚红、玫瑰金，高饱和暖色调
- 浪漫情感类节日（情人节、妇女节、七夕）→ 玫瑰红、香槟金、丁香紫、珍珠白，温柔克制
- 活力促销类节日（双十一、618）→ 高饱和撞色，品红与电蓝，荧光黄绿，强对比
配色方案：传统节日用主色加点缀方案（红主金辅）；情感类节日用渐变色或双色撞色；促销类节日用高对比双色撞色

**创意参考方向**
- 情绪具象化：把节日情感（团圆、期待、喜悦、浪漫）转化为具体视觉意象
- 矛盾融合：传统节日元素与现代生活场景的意外组合
- 比例颠覆：放大某个节日细节到占据整个画面，营造沉浸感
- 场景置换：将节日氛围移植到意想不到的环境中

---

### 1.2 宣传推广海报

**使用场景**：品牌活动、新品发布、公益宣传、政府机构宣传、城市活动

**创意策略**
找到宣传核心主张的最强视觉表达，一张海报只讲一件事。公益类可使用强情绪、强对比手法；商业宣传类注重品质感；政府机构类注重大气庄重。

**推荐风格**
高端商业：写实风、极简奢华风
大众亲和：商业插画风、简约风
公益情感：写实摄影风、概念艺术风

**色彩推导**
场景维度：品质感与信任感场景为主
主题维度对应配色：
- 品牌价值宣传 → 专业信任主题 → 深蓝、藏青、白灰，稳重大气
- 公益环保宣传 → 自然健康主题 → 草木绿、天空蓝、土地棕，有温度感
- 社会活动宣传 → 活力年轻主题 → 中高饱和撞色，有活力
- 政务机构宣传 → 专业信任主题 → 中国红加深蓝或金色，庄重大气
配色方案：整体色彩不超过三色；品牌宣传用中性色加强调色；公益类用主色加点缀；政务类用主色加点缀方案

**创意参考方向**
- 核心隐喻：找到一个强有力的视觉隐喻来承载宣传主张
- 局部叙事：用一个细节暗示整体故事，引发联想
- 场景置换：把宣传主题放入意外的视觉环境中制造记忆点

---

### 1.3 市场营销海报

**使用场景**：促销活动、产品推广、会员招募、限时优惠、新品发布

**创意策略**
视觉要在0.5秒内传递核心利益点，创意不能牺牲信息传达效率。促销感和品质感需要平衡，紧迫感通过视觉动态感传递，而非单纯堆砌文字。

**推荐风格**
高端促销：极简奢华风、写实风
大众促销：高饱和平面风、孟菲斯风
互联网促销：简约风加高饱和点缀

**色彩推导**
场景维度：强视觉冲击场景
主题维度对应配色：
- 大促优惠类 → 喜悦庆典主题 → 暖橙、金黄、明红，高饱和高对比，冲击力强
- 高端产品推广 → 神秘高端主题 → 深紫、墨黑、冷金，低饱和克制奢华
- 新品发布 → 力量突破主题 → 深色背景加单一高亮强调色，突出产品本身
- 会员权益推广 → 浪漫美好主题 → 香槟金、珍珠白、玫瑰金，渐变质感
配色方案：大众促销用双色撞色方案，对比度要高；高端促销用中性色加强调色；新品发布用主色加点缀方案

**创意参考方向**
- 张力构图：核心利益点在视觉上占据主导地位
- 比例颠覆：放大产品或关键数字，制造视觉震撼
- 情绪具象化：把优惠的爽感、稀缺感转化为视觉形态

---

### 1.4 招聘海报

**使用场景**：校园招聘、社会招聘、内部招募、实习生招募

**创意策略**
招聘海报同时传递岗位信息和公司吸引力两件事。创意应体现公司文化和调性，而非通用职场形象。校园招聘可相对活泼，社会招聘偏专业稳重。如用户提供了品牌色，优先使用品牌色。

**推荐风格**
科技公司：科技风、简约风
互联网公司：商业插画风、平面风
传统行业：写实风、简约风
校园招聘：孟菲斯风或活泼商业插画风

**色彩推导**
场景维度：品质感与信任感场景为主，校园招聘兼顾亲和力场景
主题维度对应配色：
- 科技类公司 → 专业信任加力量突破主题 → 深蓝、科技蓝、冷白，冷色系主导
- 创意类公司 → 活力年轻主题 → 中饱和撞色，有活力但不廉价
- 传统行业 → 专业信任主题 → 深色稳重色调，藏青、深灰、白
- 校园招聘 → 活力年轻主题 → 明快中高饱和色，渐变或双色撞色
配色方案：科技类用主色加点缀方案；创意类用双色撞色方案；传统行业用中性色加强调色方案；校园招聘用渐变色或双色撞色方案

**创意参考方向**
- 场景置换：把工作场景放入有想象力的视觉环境
- 深度层次构图：营造空间感和专业感
- 情绪具象化：把成长、机会、活力等抽象概念视觉化

---

### 1.5 行政人事海报

**使用场景**：员工活动、企业文化宣传、通知公告、培训活动、节日祝福、表彰奖励

**创意策略**
信息传达优先，视觉辅助。风格选择上体现企业调性，员工活动类可以更活泼，通知公告类保持简洁专业。构图和配色是主要的创意发挥空间。

**推荐风格**
员工活动：商业插画风、孟菲斯风
企业文化：简约风、写实风
通知公告：平面风、简约风
表彰奖励：极简奢华风、简约风

**色彩推导**
场景维度：亲和力与温度感场景（员工活动）或品质感场景（企业文化、表彰）
主题维度对应配色：
- 员工活动庆典 → 喜悦庆典主题 → 暖色调为主，明快饱和，氛围感强
- 企业文化宣传 → 专业信任主题 → 企业品牌色为主，稳重协调
- 培训通知 → 专业信任主题 → 中性蓝灰为主，清晰简洁
- 表彰奖励 → 神秘高端加喜悦庆典主题 → 金色加深色背景，庄重有仪式感
配色方案：活动类用多色和谐方案；企业文化用主色加点缀方案；通知类用单色或中性色加强调色方案；表彰类用黑金或深色加金点缀方案

**创意参考方向**
- 张力构图：用不对称构图避免呆板感
- 框中框构图：制造层次感和设计感
- 对角线构图：为本来稳重的画面增加动感

---

### 1.6 教育宣传海报

**使用场景**：课程招募、培训宣传、学校活动、知识科普、公开讲座、儿童教育

**创意策略**
传递专业感和可信度的同时保持亲和力。课程类要突出价值感，让受众感受到学了会有收获。儿童教育类风格可以更鲜明活泼。科普类可用视觉简化复杂概念。

**推荐风格**
成人专业课程：简约风、写实风
在线教育平台：商业插画风、平面风
儿童教育：商业插画风、孟菲斯风
学术讲座：极简奢华风、简约风

**色彩推导**
场景维度：亲和力与温度感场景为主，高端课程兼顾品质感场景
主题维度对应配色：
- 成人职业技能课程 → 专业信任主题 → 深蓝、藏青、白，稳重中有活力，中饱和
- 儿童教育课程 → 活力年轻主题 → 高饱和明快多色，色彩丰富统一饱和度
- 创意艺术类课程 → 浪漫美好加活力主题 → 中高饱和有设计感色彩，渐变或撞色
- 知识科普类 → 自然健康加专业信任主题 → 蓝绿系为主，清新专业
- 学术讲座 → 神秘高端主题 → 深色背景加金色或白色，克制高级
配色方案：儿童向用多色和谐方案，成人向用主色加点缀方案，色彩数量随受众年龄增大而减少

**创意参考方向**
- 核心隐喻：用视觉隐喻传递学习和成长的核心价值
- 比例颠覆：放大知识符号或学习成果，制造震撼感
- 深度层次构图：营造向上、向前的空间感

---

## 二、通用海报文字层级与内容生成规则

### 2.1 各子场景文字层级

**节日热点海报**
- 主标题：节日名称或祝福语，字号最大，2-8字，有情感温度
- 副标题：品牌名称或活动主题，一句话补充主标题
- 辅助说明：slogan或情感延伸语句，小字，可选
- 落款：品牌名称加年份，最小字号

内容生成示例：主标题"中秋快乐"，副标题"愿此刻团圆温柔了岁月"，落款"XX品牌 2025中秋"

用户未提供文字时：根据节日推导情感方向，主标题直接点题，副标题写情感延伸句，落款写品牌名加年份节日

---

**宣传推广海报**
- 主标题：核心主张或活动名称，4-14字，简短有力
- 副标题：说明性文字，补充主标题，一句话
- 活动信息：时间、地点、参与方式等功能信息
- 主办方或品牌名称

内容生成示例：主标题"城市因你而美"，副标题"第五届城市公益摄影大赛正式启动"，信息"投稿截止2025年9月30日 详情扫码了解"，落款"XX公益基金会"

用户未提供文字时：主标题提炼核心主张，动词开头更有力；时间地点如未提供写"时间另行通知"

---

**市场营销海报**
- 主标题：核心利益点或促销主题，直接有力
- 副标题：活动说明或产品名称
- 强调信息：关键数字、折扣、时间限制，视觉上要突出
- 行动引导：如"立即抢购"、"扫码参与"
- 品牌名称或渠道信息

内容生成示例：主标题"全场五折起"，副标题"年终感恩回馈 精选好物等你发现"，强调"仅限3天 12月20日至22日"，行动引导"扫码立即参与"，落款"XX品牌官方"

用户未提供文字时：核心利益点必须在主标题中直接呈现；时间如未提供写"限时特惠"；行动引导必须包含

---

**招聘海报**
- 主标题：招聘主题，6-16字，简洁吸引
- 副标题：公司名称加核心价值主张，一句话说明为什么来
- 岗位信息：招聘岗位列表，简洁列举
- 待遇亮点：薪资范围或核心福利，可选
- 投递信息：简历投递方式或联系方式
- 截止日期：可选

内容生成示例：主标题"加入我们 共创未来"，副标题"XX科技2025春季校园招聘正式启动"，岗位"产品经理 算法工程师 数据分析师 UI设计师"，待遇"薪资面议 六险一金 弹性工作"，投递"简历投递 hr@xxtech.com"

用户未提供文字时：根据用户描述的公司类型推断典型岗位；投递方式如未提供写"详情请扫描二维码"；公司名称如未提供写"XX公司"占位

---

**行政人事海报**
- 主标题：活动名称或通知主题
- 副标题：slogan或简短说明，员工活动类可以活泼
- 关键信息：时间、地点、参与要求或通知内容
- 组织方：部门或公司名称
- 联系人或报名方式，可选

内容生成示例：主标题"2025年度员工运动会"，副标题"活力竞技 团结奋进"，信息"时间：10月15日上午9点 地点：公司篮球场 报名截止：10月10日"，组织方"XX公司人力资源部"，报名"扫码报名或联系HR"

用户未提供文字时：主标题直接写活动或通知名称；时间地点如未提供写"时间地点待定"；组织方如未提供写"公司人力资源部"

---

**教育宣传海报**
- 主标题：课程或活动名称，清晰直接
- 副标题：核心价值一句话，说明学了能得到什么
- 讲师或背书信息：讲师姓名、资质、机构背书，可选
- 课程细节：时间、形式、适合人群、费用
- 报名方式：二维码说明或联系方式
- 主办机构名称

内容生成示例：主标题"Python数据分析实战营"，副标题"从零到一 掌握数据驱动决策的核心能力"，课程信息"开课时间：11月1日 线上直播 共12课时 适合零基础学员"，费用"原价999元 限时优惠699元"，报名"扫码立即报名 名额有限"，机构"XX教育"

用户未提供文字时：主标题写完整课程名称；副标题写学习后能获得的具体能力；费用如未提供写"详询价格"；报名方式如未提供写"扫码了解详情"

---

## 三、高频视觉元素参考

以下元素可根据场景和风格选择性加入提示词，丰富画面细节层次。

**节日类**
传统节日：祥云纹样、灯笼、月亮、梅花、松柏、烟花、红包、福字、中国结、莲花
现代节日：礼盒、气球、彩带、星光、玫瑰、心形、香槟杯、彩色纸屑

**宣传推广类**
宏大感元素：山峰剪影、海浪、星空、城市天际线、俯拍大地
动感元素：飞散的粒子、流动的光线、飞扬的布料
光线效果：丁达尔光束、放射状光线、光晕、逆光

**招聘教育类**
向上感元素：阶梯、攀登人物、向上延伸的光源、开阔地平线
专业感元素：建筑内部空间、城市天际线、抽象几何图形、书籍
人物状态：侧影剪影、专注工作状态、团队协作场景

**行政活动类**
活动感元素：彩带飘落、聚光灯、舞台光效、运动轨迹、欢呼人群剪影
团结感元素：手握在一起、圆形向心构图

---

## 四、尺寸与构图适配

竖版海报（9:16或3:4）：视觉层次从上到下流动，核心视觉在画面中上部，文字信息区在下方三分之一，底部保留品牌和功能信息区域

横版海报（16:9或4:3）：左右分区布局，左侧视觉右侧文字，或中央视觉两侧留白，文字信息量可以相对更多

方版海报（1:1）：中心构图或对角线构图，视觉重心突出，文字需精简，适合社交媒体传播

如用户未说明尺寸，默认按竖版海报设计构图逻辑。
