# 游戏视觉与游戏海报场景

## 场景说明

游戏视觉是所有视觉场景中世界观建构要求最高的类型。游戏的一切视觉——海报、宣传图、角色立绘、场景概念图——都必须服务于同一个世界观和美术风格方向。玩家对游戏视觉的审美标准极高，对风格一致性的敏感度也远超其他受众。

**游戏视觉与其他场景的核心差异**
其他场景的视觉通常服务于现实世界的产品或信息，游戏视觉服务于一个虚构世界的建构。色彩、光影、人物造型都可以脱离现实逻辑，但必须在自己建立的世界规则内保持一致性。

---

## 一、子场景识别与创意策略

### 1.1 游戏宣传海报/Key Visual

**使用场景**
游戏发布前的主视觉宣传图、版本更新宣传图、赛季主题宣传图。代表游戏对外传播的核心视觉，是游戏最想展示的世界观和视觉高度。

**创意策略**
游戏宣传海报呈现游戏世界中最震撼的一个场景，或最具代表性的角色状态。视觉要传递两件事：这个游戏的世界观是什么，以及玩这个游戏会有什么体验感。

**游戏类型与视觉方向**

MMORPG/史诗奇幻：
宏大世界观场景，多英雄阵容，史诗感光效
远景深邃（千山万壑、废墟城市、神话空间），前景人物/英雄
色调：金色史诗光、宏大蓝调、神圣白光

FPS/战术射击：
紧张感、动态感，枪械细节和都市/战场环境
角色的战术姿态，武器清晰可见
色调：冷蓝战场色、城市灰调、爆炸暖色点缀

MOBA/竞技：
英雄角色的强势姿态，每个英雄有独特的技能视觉光效
高饱和色彩，能量爆发感，技能粒子效果密集
色调：高对比，英雄专属色系

恐怖/悬疑游戏：
氛围压迫，光线极度克制，暗部细节若隐若现
心理恐惧感的视觉化，异常感和不安感
色调：深黑、腐败绿、暗红，高度去饱和

休闲/卡通游戏：
明快色彩，可爱角色，轻松愉快的场景
无威胁感的视觉语言，圆润的造型语言
色调：高饱和明快色，橙黄绿，无阴郁

二次元/日式RPG：
精致人物立绘，日式美学场景（樱花、神社、星空）
柔和光感，人物与场景的唯美融合
色调：柔和渐变色，低对比度，梦幻感

开放世界/生存：
宏大的自然或废土场景，人物在环境中的渺小感
自然光感（黄昏、晨曦、暴风雪），场景有探索感
色调：写实自然色调，偶有末日感的冷色处理

**色彩推导**
场景维度：强视觉冲击场景（竞技/动作类）或神秘高端场景（奇幻/悬疑类）
主题维度：
- 暗黑奇幻 → 神秘高端主题 → 深紫、暗红、骨白，对比强烈
- 史诗幻想 → 力量突破主题 → 金色、王者蓝、神圣白，宏大感
- 现代竞技 → 专业信任加力量突破主题 → 深色背景加高饱和强调色
- 休闲卡通 → 喜悦庆典主题 → 高饱和明快色系，对比鲜明
- 二次元 → 浪漫美好主题 → 柔和渐变色，低对比度柔光感
配色方案：游戏视觉通常用高对比双色或主色加点缀方案，能量感和视觉冲击是优先级

**推荐风格**：概念艺术风（奇幻/科幻类）、商业插画风（二次元/卡通类）、写实风（写实类）

**创意参考方向**
- 极限景深构图：超远景的世界观场景，极近景的角色细节，制造宏大史诗感
- 能量爆发构图：能量或技能效果从中心向四周爆发，充满画面的动态感
- 人物与世界的对比：渺小的人物站在宏大的世界观场景前，史诗感和代入感

---

### 1.2 角色概念设计图（Character Concept Art）

**使用场景**
游戏开发阶段的角色设计稿、新角色发布宣传、角色皮肤展示、角色关系图。

**创意策略**
角色概念图要传递角色的性格、能力、背景故事。角色的外观设计是第一战场——配色、服装、武器、体态传递角色的一切信息，不需要文字说明，看一眼就能感受到这个角色是谁。

**角色类型与视觉语言**

战士/坦克型角色：
体型壮实，装甲厚重，武器巨大
姿态强势有重量感，低重心
色调：深沉厚重，金属质感，暗色主导

法师/魔法型角色：
体型纤细，袍服飘逸，法杖或魔法书
周身有魔法粒子光效，姿态飘逸或威严
色调：魔法色（深蓝紫、神秘金、能量青），高光感

刺客/敏捷型角色：
体型修长，装备轻薄，双武器或暗器
姿态动态感强，有速度感和危险感
色调：暗色为主，有反光感，隐匿感

射手/远程型角色：
弓箭或枪械，装备轻便实用
姿态有瞄准感或就位感，精准感
色调：中性色为主，强调武器的视觉细节

支援/治愈型角色：
装备柔和，有光感和温暖感
姿态开放友好，有保护感
色调：暖白、金色、治愈绿，光感柔和

**角色展示规范**
全身立绘：正面直立，清晰展示角色全貌，通常有白底或简洁背景
动态战斗立绘：角色在技能释放或战斗状态中的姿态
多角度展示：正面加侧面加背面，展示角色设计的完整性
技能特效展示：角色释放招牌技能的视觉效果

---

### 1.3 游戏场景概念图（Environment Concept Art）

**使用场景**
游戏世界观建构、关卡场景设计、宣传物料背景、游戏发布展示。

**创意策略**
场景概念图要让玩家感受到"想要进入这个世界探索"的冲动。场景要有深度、有细节、有叙事性——每一个角落都在讲故事，传递这个世界的历史、文化和生态。

**场景类型与视觉方向**

奇幻/魔法场景：
飘浮的岛屿、巨大的古树、发光的水晶洞穴
魔法光效，超自然的色彩，违反物理的构造
光感：魔法光源，神秘感强

末日/废土场景：
破败的城市遗迹、生锈的机械、荒芜的大地
写实质感，细节丰富的毁坏细节
色调：去饱和，冷灰或暖橙（火焰/日落），压抑感

未来科技场景：
高耸的科技建筑，霓虹灯光，悬浮的载具
干净的几何形态，发光的界面和全息投影
色调：深夜蓝加霓虹色（赛博朋克感），或高洁白加科技蓝（高级未来感）

自然/写实场景：
真实感的自然环境，草原、森林、海洋
自然光感，季节感，生态细节
色调：顺应自然色彩，光感变化是情绪核心

**场景构图原则**
场景图通常采用横版宽幅（16:9或更宽）
远景要有景深，传递空间的宏大感
有光源就有阴影，光影关系是场景真实感的基础
前景有细节，中景有内容，远景有延伸

---

### 1.4 游戏UI界面视觉

**使用场景**
游戏主界面、加载界面、活动界面的视觉设计。

**创意策略**
游戏UI界面视觉要在功能性和美观性之间找平衡，同时要与游戏的整体美术风格高度一致。界面是玩家每次打开游戏都会看到的内容，视觉疲劳感要低，信息传达要高效。

**界面视觉要点**
功能区域（按钮、数字、状态栏）的视觉清晰度优先
装饰元素要与游戏世界观匹配，但不能干扰功能区域
加载界面可以更具表现力，是展示游戏概念艺术的好机会

---

### 1.5 游戏周边与联名视觉

**使用场景**
游戏周边产品视觉（实体卡牌、手办、服装）、品牌联名宣传图。

**创意策略**
游戏周边视觉要在游戏世界观和现实产品之间建立连接，让粉丝感受到"拥有这个就拥有了游戏世界的一部分"。

---

## 二、游戏视觉通用规范

### 2.1 世界观一致性原则

游戏视觉最重要的原则是世界观一致性。在生成游戏视觉前，要明确：
美术风格方向：写实/卡通/二次元/像素等
世界观设定：奇幻/科幻/现实/末日等
色调系统：整体偏冷/暖，饱和度高/低
视觉参考坐标：与哪类已有游戏风格最接近

### 2.2 分辨率与格式要求

游戏宣传海报：通常竖版9:16（移动端）或横版16:9（PC端）
角色立绘：通常透明背景PNG，竖版比例
场景概念图：通常横版宽幅，16:9或21:9
