# 电商场景

## 场景说明

电商场景的核心目标是在竞争激烈的商品列表中抢夺注意力，同时建立消费者对产品和品牌的信任感。电商图片几乎都基于用户上传的产品图进行图生图处理，提示词需要明确保留产品本体，只替换背景、光影、场景和氛围。

**参考图调用标签规范**

每张图的提示词输出时，必须在最顶部标注参考图调用标签，让下游生图节点准确判断是否需要调用用户上传的图片。

标签类型共四种：

【图生图：商品图】
需要调用用户上传的商品参考图。生图时保留产品原有外观、颜色、形态、品牌标识，只替换背景、台面、光线、氛围和场景环境。产品角度可根据需要调整，但外观细节必须忠实于参考图。
适用图类：主图头图、主图卖点图、主图细节图、主图场景图、详情页焦点展示图、详情页功能说明图、详情页细节工艺图、详情页使用场景图

【图生图：模特图】
需要调用用户上传的模特参考图。生图时保留模特形象，替换背景、服装搭配或场景环境。
适用图类：有模特出镜的主图或场景图（仅当用户上传了模特参考图时使用此标签）

【图生图：场景参考图】
需要调用用户上传的场景参考图作为环境氛围参考，不需要保留参考图中的具体元素，只参考其空间、光线、氛围。
适用图类：场景图（仅当用户上传了场景参考图时使用此标签）

【文生图】
不需要调用任何参考图，完全由提示词生成。
适用图类：详情页竞品对比图、详情页售后保障图、详情页香调解析等纯图文设计类页面，以及无需出现产品实物的概念性画面

标签使用规则：
- 每张图提示词的第一行必须是参考图标签，不可省略
- 用户上传了多张图时，标签中需注明调用哪张，如【图生图：商品图-上传图1】
- 同一张图如需同时参考商品图和场景图，标签写【图生图：商品图+场景参考图】
- 文生图类提示词中不得出现"基于参考图"等描述

**创意自由度原则：根据品类区分**
- 3C数码、美妆护肤、珠宝配饰：偏写实，产品清晰展示为主，创意在背景、光影、场景氛围上发挥
- 食品饮料、家居家纺、母婴宠物：可以更有场景感和生活感，产品融入使用场景
- 服装箱包：写实与创意并重，质感展示同时可以有概念化场景
- 户外运动、工业工具：强调产品性能感，背景和光影服务于产品力的传达

**输出数量判断原则**
收到用户需求后，先判断输出范围：
- 用户说"生成一套完整物料"→ 输出主图组（至少描述头图加2-3张副图）加详情页组（5-8张）
- 用户说"生成主图"或"生成详情页"→ 只输出对应模块
- 用户说"生成某一张"→ 只输出单张提示词
- 用户上传产品图要求"出图"但未说明类型→ 询问用户需要哪类物料，或默认先输出主图头图
- 店铺首页Banner独立于单品物料之外，用户明确要求时才输出，不纳入"一套物料"的默认范围

---

## 一、品类特征分析矩阵

拿到任何电商产品需求后，先用以下五个维度分析产品特征，再进入主图组和详情页的内容规划。这套分析框架适用于所有品类，通过交叉判断推导出该产品的说服逻辑和内容重心，避免套模板。

### 维度一：决策驱动因素

判断用户购买这类产品的核心动机，决定整套物料的内容重心。

视觉驱动
用户看到就想买，外观、氛围、场景感是最大说服力。
典型品类：服装、家居软装、食品饮料、鲜花绿植、设计师单品
内容重心：头图和场景图权重高，技术说明图可以少，氛围和生活感优先

功效驱动
用户需要相信产品有效才会买，功效可视化和成分说明是关键。
典型品类：护肤品、保健品、功能性食品、减脂产品、母婴用品
内容重心：功效说明图、成分可视化、使用前后对比是必要内容，卖点说明图需要多张

信任驱动
用户需要相信品质和品牌才会买，工艺背书和品牌故事是关键。
典型品类：珠宝、高端家电、奢侈品、定制类产品、新品牌产品
内容重心：细节工艺图、材质说明、品牌背书、竞品对比权重高

性能驱动
用户需要相信产品性能参数达标才会买，数据和技术是说服核心。
典型品类：3C数码、电动工具、运动装备、汽车周边、专业器材
内容重心：功能说明图、参数对比、技术原理图是必要内容

价格驱动
用户的核心决策因素是性价比，需要快速传递值这个价。
典型品类：日用品、快消品、低客单价标品
内容重心：直接展示产品和核心卖点即可，篇幅精简，不需要复杂技术说明

---

### 维度二：客单价区间

客单价决定用户决策时间和疑虑深度，影响详情页篇幅和信任背书比重。

低客单价（100元以下）：用户决策快，详情页宜精简5-6张，核心卖点快速传递
中客单价（100-500元）：用户会对比，需要清晰卖点和一定品质背书，7-9张较合适
高客单价（500-2000元）：用户决策谨慎，需要充分工艺细节和竞品对比，9-12张
超高客单价（2000元以上）：需要深度建立信任，品牌故事和权威认证都重要，可以更长

---

### 维度三：标品 vs 非标品

标品：用户已知道这类产品是什么，核心问题是为什么买你
说服重心：差异化卖点、竞品对比、性价比
典型品类：数据线、充电器、基础护肤品、日用品、食品

非标品：用户需要先理解产品是什么才能评估是否需要
说服重心：产品故事、设计理念、使用场景展示
典型品类：设计师单品、定制类产品、新品类产品、创意产品

半标品：用户了解品类但不了解这个具体产品的差异化
说服重心：品类认知简介加自身差异化卖点
典型品类：功能性食品、新技术家电、特色护肤品

---

### 维度四：功效是否可视化

功效可直接视觉化：效果可以被看见或感受，用前后对比或场景图展示
典型品类：美妆护肤、家居软装、食品
处理方式：使用效果展示图或场景对比图，情绪感和代入感优先

功效需间接视觉化：效果本身不可见，需用成分、原理、数据来可视化
典型品类：保健品、功能性食品、技术类产品
处理方式：成分拆解图、原理示意图、数据对比图，让不可见的功效变得可信

功效不是核心卖点：卖点是设计、材质、品牌，不需要强调功效
典型品类：服装、珠宝、家居装饰
处理方式：材质细节、场景氛围、品牌调性是内容重心

---

### 维度五：使用场景丰富度

场景单一：产品只在一个场景下使用，场景图1张足够
典型品类：专业工具、单一功能电器

场景丰富：产品有多个使用场景或多类目标用户，场景图可安排2-3张覆盖不同场景
典型品类：服装、背包、食品饮料、多功能电器

场景即卖点：产品的核心价值就是它带来的生活方式，场景图是整套物料的灵魂
典型品类：家居软装、香薰、户外装备、生活方式类产品
处理方式：场景图权重最高，头图本身也可以是强场景感的图

---

### 分析矩阵使用示例

示例1：护肤品精华液，客单价300元
功效驱动 + 中客单价 + 半标品 + 功效需间接视觉化 + 场景适中
推导：详情页8-9张，必须有成分说明和功效可视化图（2-3张），卖点说明图（2张），使用场景图（1张），竞品对比（1张），保障图（1张）

示例2：设计师陶瓷马克杯，客单价80元
视觉驱动 + 低客单价 + 非标品 + 功效不是卖点 + 场景丰富
推导：详情页5-6张，头图和场景图是重心（2-3张），工艺细节图（1张），品牌设计说明（1张），保障图（1张），不需要竞品对比

示例3：无线耳机，客单价500元
性能驱动 + 中高客单价 + 标品 + 性能需间接视觉化 + 场景适中
推导：详情页9-10张，功能技术说明图（2-3张），卖点说明图（2张），细节工艺图（1-2张），场景图（1-2张），竞品参数对比（1张），保障图（1张）

---

## 二、子场景识别与创意策略

### 1.1 商品主图组

**使用场景**
商品列表页展示，用户搜索后第一眼看到的图。主图通常是一组图片（淘宝/天猫最多9张，京东建议5张以上），由头图加多张副图组成，整组图片风格统一。

**核心任务**
头图在0.3秒内让用户停下滑动的手指，副图在用户浏览时逐步补充说服力。

**主图组规划原则**
主图组没有固定模板，张数和每张的内容需要根据产品特点来决定，不要套用固定结构。规划前先分析产品：

第一步：识别产品的核心差异点
产品最大的卖点是什么？是材质工艺、功能技术、使用场景、设计外观、还是成分配方？不同的核心差异点决定哪类图需要更多张。

第二步：判断产品的视觉说服难度
视觉就能直接说服的产品（外观好看的产品、食品、生活用品）：场景图和头图权重更高，细节图可以少
需要解释才能说服的产品（技术类产品、功效类产品、工艺复杂的产品）：卖点说明图和功能图需要更多张
用户信任感低的品类（新品牌、高客单价）：工艺细节和品质背书图需要更多张

第三步：规划每张图的任务
头图：必须有，第一张，视觉冲击力最强，产品最佳状态展示
其余图：根据产品特点灵活组合，可用的图类型包括——
- 卖点说明图：聚焦单一卖点，图文结合，可以有1-4张（卖点多的产品多安排）
- 细节工艺图：放大关键局部，可以有1-3张（工艺复杂或材质是卖点的产品多安排）
- 场景生活图：产品在使用场景中，可以有1-3张（生活类产品、场景丰富的产品多安排）
- 功能示意图：技术原理或功能可视化，可以有1-2张（技术类产品使用）
- 对比展示图：产品与竞品或使用前后的对比，可以有1张（可选）
- 促销图：价格或赠品信息，有促销活动时才安排（可选）

整组图片需保持：背景色系统一、光影方向统一、产品展示角度在组内有变化

**创意策略**
头图：产品必须是绝对主角，背景和装饰服务于产品。背景氛围、光影质感、场景选取是主要创意空间。
卖点说明图：每张聚焦一个信息点，不要在一张图里塞多个卖点。
细节图：光线和放大角度是核心，要让材质和工艺自己开口说话。
场景图：生活感和代入感优先，避免刻意摆拍感。

品类创意方向：
- 3C数码：科技感和精密质感，深色背景加产品高光，极简白底加光影雕塑感
- 美妆护肤：产品质地和成分感，液体流动、气泡、植物提取物微观细节
- 食品饮料：食欲感优先，蒸汽、液体飞溅、新鲜食材堆叠
- 家居家纺：生活场景感，真实家居环境，氛围光线
- 服装箱包：材质质感和使用状态，平铺特写或场景搭配
- 珠宝配饰：光泽和精致感，微距特写和极简背景
- 母婴宠物：温暖和安全感，柔和光线和温馨场景
- 户外运动：动感和产品性能，运动场景和极端环境

**推荐风格**
3C数码：科技风、写实风、极简奢华风
美妆护肤：写实风、极简奢华风、自然有机风
食品饮料：写实风、手绘风、自然有机风
家居家纺：写实风、简约风、自然有机风
服装箱包：写实风、极简奢华风
珠宝配饰：写实风、极简奢华风
母婴宠物：商业插画风、写实风
户外运动：写实风、科技风

**色彩推导**
场景维度：品质感与信任感场景为主
主题维度对应配色：
- 3C数码 → 专业信任加力量突破主题 → 深黑、太空灰、科技蓝、冷白，主色加点缀方案
- 美妆护肤 → 浪漫美好加神秘高端主题 → 玫瑰金、珍珠白、深紫、裸粉，渐变色或主色加点缀
- 食品饮料 → 喜悦庆典加自然健康主题 → 暖橙、奶白、草木绿，主色加点缀方案
- 家居家纺 → 温柔关怀加自然健康主题 → 米白、暖棕、莫兰迪灰绿，中性色加强调色方案
- 服装箱包 → 根据产品定位，高端款黑金米白，年轻款撞色
- 珠宝配饰 → 神秘高端主题 → 深色背景加金银点缀，中性色加强调色方案
- 母婴宠物 → 温柔关怀主题 → 粉白米黄浅绿，低饱和暖色系
- 户外运动 → 力量突破主题 → 深色加高饱和强调色，双色撞色或主色加点缀

**创意参考方向**
头图：极简压迫构图或深度层次构图，产品质感最大化
卖点图：张力构图，产品加文字左右分区或上下分区
细节图：极简压迫构图，局部特写，光线强化质感
场景图：深度层次构图，前景虚化、中景产品、远景环境

---

### 1.2 详情页图组

**使用场景**
用户点击进入产品页后向下滚动看到的一组图片，通常5-8张，最终由商家拼接为一张长图。每张图承担不同的说服任务，整组风格统一。

**详情页规划原则**

详情页没有固定张数和固定顺序，5-12张都是合理的，取决于产品需要讲清楚的事情有多少。规划前先分析产品需要完成哪些说服任务，再决定用哪些图、每张讲什么。

第一步：分析产品的说服路径
用户点进详情页通常带着几个问题：这是什么、有什么用、凭什么买你、买了会不会后悔。详情页的任务是按顺序回答这四个问题。

第二步：识别产品的内容重心
卖点多且复杂的产品（技术类、功效类）：卖点说明图和功能图需要更多张，每个重要卖点单独一张
工艺和材质是核心差异的产品：细节工艺图需要更多张，从不同角度和部位展示
使用场景丰富的产品：场景图可以安排多张，覆盖不同使用场景
新品牌或高客单价产品：工艺背书、竞品对比、用户评价的权重更高
功能简单、外观即卖点的产品：场景图和氛围图权重高，技术说明图可以少甚至没有

第三步：从可用图类型中按需选取和组合
以下是详情页可以使用的图类型，不需要全部使用，根据产品特点选取：

焦点展示图（强烈建议有，通常是第1张）
产品最佳状态大图，情感化、场景感、建立第一印象

卖点说明图（根据卖点数量决定张数，1-4张）
每张聚焦单一卖点，图文结合，数据或对比可视化。卖点多的产品可以安排多张，不要把多个卖点塞进同一张

功能说明图（技术类或功能复杂产品使用，1-3张）
产品功能拆解说明，技术原理可视化，用标注图或示意图呈现

细节工艺图（材质和工艺是差异点的产品使用，1-3张）
放大关键部位，展示材质、纹理、工艺精细度，建立品质信任

使用场景图（生活类产品强烈建议，1-3张）
产品在真实使用场景中的状态，覆盖不同使用场景或用户人群

竞品对比图（有明确竞争优势可视化时使用，0-1张）
与同类竞品对比，突出自身优势，视觉公平客观，有则用，无明显优势可以不安排

用户评价图（有真实评价内容时使用，0-1张）
真实用户反馈的视觉化，增加社会认同感，可选

售后保障图（建议有，通常是最后1张）
品牌承诺、售后政策、质量认证，消除购买最后顾虑

生成详情页组时，先输出内容规划（每张图的编号和任务），再逐张输出提示词。整组色彩、风格、字体调性保持统一。

**核心任务**
用户已经点进来，说明有购买意向。详情页的任务是逐步消除疑虑、强化购买欲望、最终促成下单。

**推荐风格**：与主图风格保持一致，焦点展示图可以更有故事感和情绪感

**色彩推导**
与主图色彩体系保持一致，整体色调比主图更舒展，留白比例更高，文字可读性优先

**各类型图的创意参考方向**
焦点展示图：场景置换、局部叙事、深度层次构图，情绪感优先
卖点说明图：张力构图，图文左右或上下分区，单张只讲一件事
功能说明图：示意图或标注图风格，清晰胜于美观
细节工艺图：极简压迫构图，微距特写，光线强化质感
场景图：深度层次构图，前景中景远景三层，生活感优先
对比图：左右对称构图，数据突出，视觉公平
保障图：中心构图或四宫格，图标化视觉语言，专业稳重

---

### 1.3 促销活动主图

**使用场景**
大促节点（双十一、618、年货节等）或日常促销活动的主视觉，通常作为主图替换或活动专区首图，单张输出。

**核心任务**
在0.3秒内传递"有优惠、要抢购"，视觉冲击力和利益点第一位。

**创意策略**
促销主图的创意必须服务于转化，信息传达效率优先。促销感和品质感需要平衡，廉价的视觉堆砌会损害品牌调性。

品类促销特点：
- 大众消费品：可以用更高饱和、更热闹的视觉风格
- 高端品类（美妆、珠宝、3C旗舰）：促销感要克制，用"限时礼遇"而非"大甩卖"的视觉语言
- 季节性品类：结合季节氛围，情绪感比数字感更重要

**推荐风格**
大众促销：高饱和平面风、孟菲斯风、波普艺术风
高端促销：极简奢华风、简约风
季节促销：写实风结合季节元素

**色彩推导**
场景维度：强视觉冲击场景
主题维度对应配色：
- 大众大促 → 喜悦庆典主题 → 暖红、亮橙、金黄，高饱和高对比，双色撞色方案
- 高端品类促销 → 神秘高端主题 → 深色背景加金色，克制奢华，中性色加强调色方案
- 季节限定 → 结合季节主题 → 春季嫩绿裸粉，夏季清爽蓝白，秋季暖橙深棕，冬季深蓝金白

**创意参考方向**
- 比例颠覆：放大关键数字或产品，制造视觉震撼
- 张力构图：核心利益点在视觉上占据最主导位置
- 情绪具象化：把抢购紧迫感、优惠爽感转化为视觉动态感

---

### 1.4 店铺首页Banner

**使用场景**
店铺首页顶部轮播图，用户进入店铺后第一眼看到的图，通常为横版宽图。Banner独立于单品物料之外，传递的是品牌整体调性而非某个商品。

**重要说明**
生成单品物料（主图组加详情页组）时，Banner不纳入默认输出范围。只有用户明确要求"生成店铺Banner"或"生成完整店铺视觉"时才输出。

**核心任务**
建立"这是一家什么样的店"的品牌印象，引导用户向下浏览或进入活动专区。

**创意策略**
不需要急于卖货，而是建立品牌感。视觉要有整体感，多张轮播图之间需要保持风格统一。

使用场景细分：
- 日常品牌Banner：传递品牌调性和核心产品，无明确促销信息
- 活动专题Banner：结合活动主题，引导点击，需要有清晰的行动引导
- 季节上新Banner：结合季节氛围展示新品，情绪感为主

**色彩推导**
场景维度：品质感与信任感场景
配色方案：品牌主色系为主，保持统一；活动Banner可在品牌色基础上加入活动强调色；整体色彩克制不超过三色

**创意参考方向**
- 极简压迫构图或张力构图：大气留白，视觉重心突出
- 深度层次构图：横版画面适合纵深感，前景中景远景拉开空间
- 局部叙事：展示产品使用场景的精彩瞬间，让用户产生代入感

---

## 二、电商场景文字层级与内容生成规则

### 2.1 各子场景文字层级

**商品主图（头图）**
头图文字极度精简，部分平台要求纯白底主图不加文字：
- 核心卖点：1句话，最重要的产品差异点，字号最大（如有文字）
- 产品名称：简短版本，字号次之（如有文字）

**商品主图（副图）**
卖点图：卖点标题（大字）加简短说明（小字），文字清晰可读
细节图：部位名称或工艺名称（小标注），可以极少量文字
场景图：可以无文字，或只有一句情感化slogan

**详情页各页文字层级**
焦点展示图：产品名称或系列名（主标题）加价值主张一句话（副标题），文字少而精
卖点图：卖点标题大字 + 数据或说明小字，每张聚焦1-2个卖点
功能说明图：功能名称加简短说明，可以有多个标注点，文字密度中等
细节工艺图：材质或工艺名称的标注文字，简洁精准
场景图：可无文字或只有一句情感化描述
竞品对比图：对比维度名称加数据，表格化文字，客观清晰
用户评价图：引用真实评价关键句，标注用户身份标签
售后保障图：保障条目标题加简短说明，图标化排版，权威感强

**促销活动主图**
- 活动名称或促销主题：主标题，字号最大
- 核心利益点：折扣或优惠金额，视觉上最突出
- 活动说明：时间限制或参与条件，中等字号
- 行动引导：立即抢购或点击领券，小按钮样式
- 品牌名称：最小字号，角落位置

**店铺首页Banner**
- 品牌slogan或活动主题：主标题，大字有品牌感
- 副标题：一句话说明活动或产品系列
- 行动引导：立即查看或进入专场，可选
- 品牌名称：融入logo位置

---

### 2.2 文字内容生成原则

用户未提供文字时，按以下原则生成：
- 主图头图：根据产品品类推断最核心的差异化卖点，用最简洁的语言表达
- 详情页卖点图：根据产品特点推断2-3个主要卖点，每张图聚焦一个
- 详情页功能图：根据产品可见功能点列举，逐一标注说明
- 促销图：核心利益点必须最突出，价格数字如未提供写"限时特惠"
- Banner：生成有品牌感的slogan，避免直白的促销语言

---

## 三、各品类高频视觉元素参考

**3C数码**
产品质感：金属拉丝质感、玻璃反光、精密电路纹理
背景元素：深色渐变、光线扫射、几何光效、粒子光点
场景元素：桌面办公场景、户外使用场景、极简白色空间

**美妆护肤**
产品质感：液体流动、气泡、植物提取物微距、粉质飞散
背景元素：大理石台面、丝绸布料、花瓣、植物叶片
场景元素：梳妆台、浴室、自然光窗边

**食品饮料**
食欲感元素：蒸汽、液体飞溅、食材横截面、新鲜食材堆叠
背景元素：木质台面、石板、粗麻布、厨房场景
场景元素：餐桌、户外野餐、烹饪过程

**家居家纺**
生活场景：自然光线、温暖灯光、植物绿植
空间元素：卧室、客厅、浴室、书房局部
质感元素：布料纹理特写、木质纹理、棉麻质感

**服装箱包**
质感元素：面料纹理特写、拉链五金细节、缝线工艺
场景元素：街头、咖啡馆、旅行、办公室
光线元素：自然光、柔和侧光、逆光剪影

**珠宝配饰**
质感元素：金属光泽、宝石折射光、镶嵌工艺微距
背景元素：深色绒布、大理石、镜面反射
光线元素：点光源聚光、棱镜折射光效

**母婴宠物**
温暖元素：柔和自然光、棉麻布料、木质玩具、草地
场景元素：儿童房、家庭生活场景、户外草地
情感元素：亲子互动、宝宝专注使用产品的状态

**户外运动**
动感元素：运动轨迹、速度感模糊、极端天气环境
场景元素：山顶、海边、赛道、极端自然环境
氛围元素：黎明光线、云雾、雪山、海浪

---

## 四、电商场景尺寸与构图适配

### 4.1 主图尺寸规范

**淘宝天猫**
主图尺寸：800x800（1:1）或 800x1200（2:3竖版），头图建议使用竖版以在移动端占据更大展示面积
副图尺寸：统一与头图保持一致比例
视频封面：800x800（1:1）

**京东**
主图尺寸：800x800（1:1）或 1920x1080（横版用于部分展位）
建议主图5张以上，头图加4张副图

**拼多多**
主图尺寸：800x800（1:1）
移动端展示为正方形裁切，核心视觉必须在正方形安全区内

**抖音小店**
主图尺寸：800x800（1:1）或 9:16竖版视频封面
商品卡展示以正方形为主

**小红书商城**
主图尺寸：3:4竖版（1242x1660），小红书以竖版为主流
笔记配图：3:4或1:1

### 4.2 详情页尺寸规范

**通用详情页**
宽度：750px（移动端标准）
每张高度：750-1200px不等，根据内容量决定
整体长图：各张图拼接后总高度通常在5000-15000px

**PC端详情页**
宽度：750px或790px（居中展示）
部分品类（如家居、3C）会有PC端专属宽图版本，宽度1920px

### 4.3 店铺首页Banner尺寸规范

**淘宝天猫**
移动端Banner：750x400（约1.875:1）或750x750（1:1）
PC端Banner：1920x600（约3.2:1）或1920x700

**京东**
店铺首页Banner：1920x700（PC端）
移动端：750x390

**拼多多**
店铺Banner：750x200至750x400

**抖音店铺**
店铺背景图：1125x633（16:9）

### 4.4 构图与尺寸的对应关系

**正方形（1:1）主图**
中心构图或张力构图，产品居中或偏上，背景简洁，核心视觉在画面中央60%的安全区内，四周留出一定边距防止平台裁切

**竖版（3:4 或 2:3）主图**
上下分区构图，上部70%为视觉区，下部30%为文字信息区，或全图视觉无文字，适合场景感强的品类

**横版Banner（约2:1至3:1）**
左右分区构图：左侧产品右侧文字，或左侧文字右侧产品
中央聚焦构图：产品居中，两侧对称留白
注意两侧安全区，核心视觉放在画面中央80%宽度范围内，防止不同设备下被裁切

**详情页单张图（750宽度）**
每张图根据内容类型选择对应构图：
焦点展示图用深度层次构图，卖点图用张力构图左右分区，细节图用极简压迫构图，场景图用深度层次构图，对比图用左右对称构图，保障图用中心图标化构图
