# 抖音视觉场景

## 平台特征与创意底层逻辑

抖音是一个以短视频和直播为核心的平台，用户的注意力极度稀缺——平均每条视频的判断时间不超过3秒。这决定了抖音视觉有几个根本性的特征：

**3秒法则是一切的前提**
封面图要在缩略图状态下就传递出"值得点击"的信号。标题文字和封面视觉必须配合，传递出明确的内容价值。模糊的、平淡的、没有信息量的封面会直接导致用户划走。

**冲击力优先于精致感**
与小红书的低饱和克制美学不同，抖音的主流视觉语言是高对比、强冲击、信息密度高。不是说不能精致，而是精致也要在第一眼就能被感知到。

**情绪驱动传播**
抖音的传播路径是点赞→分享→刷到相似内容。强情绪（搞笑、惊喜、感动、愤怒、共鸣）是传播的核心驱动力，视觉要能快速激活这些情绪。

**文字是视觉的重要组成部分**
抖音封面上的文字通常字号很大，甚至比主视觉还重要。文字风格（字体、颜色、排版）和内容本身一样需要精心设计。

---

## 一、内容类型识别与创意策略

### 1.1 视频封面图

**核心任务**
封面图的唯一任务是让用户点击。在信息流的缩略图状态下，封面必须在0.3秒内传递出"这个视频值得看"的信号。

**封面类型与创意策略**

人物出镜封面
适用：vlog、人物访谈、知识分享、情感内容
创意要点：人物表情是最强的情绪载体，惊讶、开心、认真、感动的表情比平静更吸引点击；人物占画面比例要大，能在缩略图状态下清晰识别；背景要干净或与主题高度相关

场景封面
适用：探店、旅行、美食、生活方式
创意要点：场景最有代表性的角度或瞬间，光线和色调要有吸引力；在场景图上叠加大字文字，说清楚这个场景是什么

产品展示封面
适用：好物推荐、测评、开箱
创意要点：产品清晰，有视觉冲击力的摆放或背景；标注关键信息如价格、卖点

信息图封面
适用：知识科普、干货教程、观点分享
创意要点：标题大且清晰，传递明确的信息价值；配色对比强烈，在小屏幕上也能清晰识别

**封面文字规范**
主标题：3-10字，字号极大，在手机小屏幕的缩略图状态下清晰可读
文字颜色：高对比，白底黑字、黑底白字、彩底白字都是常用方案
文字位置：通常在画面的上三分之一或中部，不能被平台UI元素遮挡（底部通常有用户名和按钮）
情绪词汇：震惊、绝了、必看、干货、真相、第一次等高情绪词汇能提升点击率

**色彩推导**
场景维度：强视觉冲击场景为主
主题维度：根据内容类型
- 娱乐搞笑内容 → 活力年轻主题 → 高饱和明快色，双色撞色方案
- 知识干货内容 → 专业信任主题 → 深色背景加冷白，主色加点缀方案
- 情感共鸣内容 → 温柔关怀主题 → 暖色调，低饱和温暖感
- 美食美景内容 → 喜悦庆典加自然健康主题 → 暖色明快，食欲感或自然感
配色方案：封面整体对比度要高，无论选什么主色，文字和背景的对比度必须极高

**推荐风格**：简约风（信息图封面）、写实风（场景封面）、平面风（活动封面）

**尺寸规范**
竖版封面（主流）：9:16，1080x1920px
横版封面（横屏内容）：16:9，1920x1080px
正方形（部分内容）：1:1，1080x1080px

**创意参考方向**
- 极简压迫构图：主体放大占满画面，文字叠加在视觉核心旁边
- 张力构图：人物或主体偏一侧，另一侧放大字标题
- 对角线构图：主体沿对角线分布，动感强，适合运动户外内容

---

### 1.2 直播间视觉物料

**使用场景**
直播间背景图、直播间贴片、直播预告图、开播封面图。直播间视觉直接影响用户进入直播间后的停留时长和信任感。

**直播间背景图**
核心任务：建立直播间的专业感和品牌感，让用户感受到"这个主播是认真的"
创意策略：
- 电商直播间：产品陈列背景，突出品类和品牌，色调与产品相符
- 知识分享直播：简洁专业的演讲背景，书架或纯色背景都是常用方案
- 娱乐互动直播：有趣有个性的背景，与主播个人风格高度一致
- 带货直播：突出品牌和当期促销信息，产品展示区背景要干净

背景图设计原则：
主播位置留出清晰区域（通常中间偏下），不要在主播站立区域放置视觉干扰元素；背景文字信息如有，要在主播出境后依然清晰可读；整体色调要与产品和主播调性协调

**直播预告图**
核心任务：吸引粉丝准时观看，传递直播内容价值和时间信息
文字层级：直播主题（最突出）→ 时间信息 → 主播信息 → 预告内容亮点
视觉风格：比视频封面有更多设计感，类似海报的处理方式

**色彩推导**
场景维度：强视觉冲击场景（预告图）或品质感场景（背景图）
主题维度：与直播内容和主播人设高度匹配
配色方案：预告图用双色撞色或主色加点缀方案；背景图用主色加点缀，克制专业

**尺寸规范**
直播间背景图：16:9，1920x1080px 或竖版9:16，1080x1920px（根据直播画面方向）
直播预告图：9:16，1080x1920px（用于视频发布）或1:1（用于动态发布）

---

### 1.3 账号主页视觉

**使用场景**
抖音账号的头像、主页背景图、账号封面。主页视觉是用户决定是否关注账号的重要因素。

**主页背景图**
核心任务：一眼传递账号的内容方向和人设调性
创意策略：
- 个人IP账号：体现主播人设和内容方向，有辨识度
- 品牌账号：品牌视觉语言，产品或品牌故事
- 垂类内容账号：直接展示内容领域的标志性视觉

**色彩推导**
与账号整体视觉体系保持高度一致，是账号品牌色的集中展示

**尺寸规范**
主页背景图：16:9，1500x500px（比例接近横版banner）

---

### 1.4 短视频内容配图

**内容特征**
抖音图文功能（"图集"模式）近年增长迅速，用户可以发布多张图片配合文字和音乐，形成类似幻灯片的浏览体验。图文内容的推荐逻辑与短视频相同，但创作门槛更低，适合知识分享、好物推荐、生活记录等内容类型。

**与视频封面的核心区别**
视频封面只有一张，图文内容有多张，每张图都会被用户逐一浏览，叙事逻辑接近小红书的图文笔记，但风格要更符合抖音的审美偏好（对比更强、节奏更快）。

**内容类型与创意策略**

好物推荐图文
适用：产品种草、测评、对比
创意要点：第一张图决定是否继续滑动，要有视觉冲击力；产品图要清晰有质感；文字信息要大而直接；每张图节奏感要比小红书更快
视觉节奏：第1张强冲击吸眼，第2-4张产品细节或使用状态，最后1张总结或引导关注

生活记录图文
适用：日常vlog式的图文记录，旅行、美食、穿搭
创意要点：有故事线，图片有叙事顺序感；每张图有独立美感；色调统一
视觉节奏：开场建立场景，中间展开细节，结尾情绪收尾

知识干货图文
适用：技巧攻略、科普知识、经验总结
创意要点：信息图样式，每张图有清晰的信息点；字号大，在快速滑动中也能被读取；色彩体系统一，有品牌感
视觉节奏：第1张点明主题，中间逐一展开要点，最后1张总结加引导关注

**色彩推导**
场景维度：强视觉冲击场景（好物推荐）或亲和力场景（生活记录）
主题维度：与内容主题一致，整体饱和度高于小红书同类内容
配色方案：好物推荐用双色撞色或主色加点缀；生活记录用统一色调；干货图文用主色加强调色，每张图保持色彩一致性

**推荐风格**：简约风（干货）、写实风（生活记录）、高饱和平面风（好物推荐）

**尺寸规范**
图文配图：9:16 竖版（1080x1920px）为主，与视频逻辑一致
每组图片：建议3-12张，节奏比小红书更快，单张信息量不宜过多

**创意参考方向**
- 每张图独立成立：单张图拿出来也有视觉完整性
- 节奏感构图：从第一张到最后一张有明确的视觉节奏，不平铺
- 强文字叠加：文字是图片的重要组成部分，字号要大，位置要稳定

---

### 1.5 图文类内容（文字图片混合）

**内容特征**
抖音的图文笔记形式，以文字为主，图片为辅，类似公众号文章的浏览体验。用户滑动阅读，图片起到视觉间隔和情绪强化的作用。这类内容在情感类、故事类、经验类内容中有较高的互动率。

**与短视频内容配图的核心区别**
短视频配图是"图为主、文为辅"，图文类内容是"文为主、图为辅"。图片不需要独立承担信息传达，而是服务于文字叙事的情绪和节奏。

**内容类型与创意策略**

情感故事类图文
适用：情感经历分享、人生感悟、心理共鸣内容
创意要点：图片要有情绪感染力，强化文字的情感温度；不需要高信息量，氛围感优先；背影、夜景、空旷场景比人物正面更有故事感
配图节奏：开场图建立情绪基调，中间图维持情绪流动，结尾图做情绪升华

观点表达类图文
适用：个人观点、社会话题评论、生活哲学
创意要点：金句或核心观点可以做成大字版式图，强化观点的传播力；背景简洁，文字是绝对主角
配图节奏：金句图和场景图穿插，给文字密集的段落提供视觉呼吸

干货笔记类图文
适用：知识科普、经验总结、工具推荐
创意要点：清晰的信息图辅助文字，减少阅读负担；每张图有清晰的章节感

**色彩推导**
场景维度：亲和力与温度感场景（情感类）或品质感场景（观点类）
主题维度：与内容情绪一致，整体克制有质感
配色方案：低饱和主色加点缀方案，给文字留出视觉空间，不与文字竞争注意力

**推荐风格**：简约风、自然有机风

**尺寸规范**
图文配图：9:16 竖版（1080x1920px）
单篇配图数量：3-8张，根据文章长度

**创意参考方向**
- 情绪具象化：把文章情绪转化为视觉氛围，图片是情绪的可视化延伸
- 极简压迫构图：大面积留白加核心元素，配合文字形成呼吸感
- 金句图设计：有力量感的短句用大字加简洁背景呈现，传播力强

---

## 二、抖音视觉规范

### 2.1 文字设计要点

抖音封面的文字设计比其他平台更重要，几个核心原则：

字号要大：在手机缩略图（约150x250像素）状态下主标题必须清晰可读，实际字号通常需要是画面高度的10%-20%

高对比配色：文字颜色和背景颜色的对比度要极高，以下方案最稳定：
白字加黑色描边（适用于任何背景）
黑色半透明蒙层加白字
纯色色块加对比色文字

情绪化表达：抖音标题的情绪词汇密度远高于其他平台，"绝绝子"、"震惊"、"必看"、"真的会谢"等词汇在这个平台有更高的点击驱动力

文字位置安全区：避开底部150px区域（通常有用户名和互动按钮），避开右侧120px区域（有关注和互动按钮）

### 2.2 整体调性要点

抖音视觉与小红书的核心差异：
- 饱和度更高：抖音主流审美接受更高饱和度的色彩
- 对比更强：明暗对比和色彩对比都要更强烈
- 信息更密：封面可以承载更多信息量（但不等于要堆满）
- 冲击感优先：第一眼的视觉冲击比长时间欣赏的精致感更重要

在提示词中传递抖音质感的关键描述：
高对比度、强视觉冲击、色彩饱和鲜明、文字清晰突出、第一眼抓眼球
