# 概念艺术与插画场景

## 场景说明

概念艺术和插画是创意视觉的核心领域，从游戏/影视前期的世界观构建，到书籍封面、品牌插画、独立艺术创作，都在这个场景的覆盖范围内。这是视觉创作中自由度最高的场景——受到的现实约束最少，创意空间最大。

**这个场景的核心能力**
创造一个从未存在过的视觉画面，或以全新的方式重新诠释已有的现实。不是记录现实，而是创造新的视觉现实。

---

## 一、子场景识别与创意策略

### 1.1 科幻概念艺术

**适用场景**
科幻影视/游戏的前期概念图、科幻题材插画、未来世界视觉构建、太空/星际主题创作。

**核心视觉元素**
太空环境：星云、星系、黑洞、行星、宇宙飞船轨道
未来城市：垂直城市、悬浮建筑、全息投影、光污染夜景
科技感细节：全息界面、机械结构、能量光效、数字化元素
人类与技术：穿着航天服或机械外骨骼的人物，人类与宏大宇宙的比例对比

**视觉质感方向**
硬科幻（技术细节精确）：机械结构清晰，有工程感，写实的材质
软科幻（情感和社会主题）：更多关注人与技术的关系，视觉更有情感温度
赛博朋克：霓虹灯光、雨中反光、高科技低生活，深夜城市
太空歌剧：宏大感优先，宇宙的浩瀚和渺小的人类

**色彩推导**
主题维度：专业信任加神秘高端主题
代表性色彩：深太空蓝、星云紫、能量青、冷白、科技蓝
配色方案：深色背景加高饱和发光体，暗处的宏大感加光点的精确感
渐变色方案：宇宙场景通常有大面积的深色渐变背景，冷暖双色渐变制造景深

**推荐风格**：概念艺术风、科技风

**创意参考方向**
- 极限景深构图：太空场景的无限纵深，让视觉在画面中不断延伸
- 比例操控：渺小的人类/飞船对比宏大的宇宙结构，制造震撼的比例冲击
- 光源创造：在黑暗中创造光源（发光的城市、引擎的火焰、星球的反光），光是科幻艺术的灵魂

---

### 1.2 奇幻概念艺术

**适用场景**
奇幻影视/游戏的前期概念图、奇幻题材插画、神话/传说主题创作、魔法世界视觉构建。

**核心视觉元素**
自然奇观：飘浮的岛屿、发光的森林、巨大的古树、魔法水晶洞穴
建筑与文明：古城遗迹、魔法塔楼、精灵树屋、矮人要塞
生物：龙、凤凰、独角兽等奇幻生物，要有生命感和重量感
魔法效果：法术粒子、魔法阵、元素能量（火水土风的视觉化）

**奇幻风格分类**
高幻想（史诗奇幻）：宏大史诗，金色神圣光，高度细节的建筑和环境
黑暗奇幻：压抑阴暗，腐败和死亡的视觉意象，高对比低饱和
东方奇幻：水墨质感，仙气飘飘，云雾缭绕，古典中式美学
中世纪奇幻：写实的中世纪质感，铁质盔甲，石头建筑，有历史感

**色彩推导**
主题维度：神秘高端主题（黑暗奇幻）或力量突破主题（史诗奇幻）
代表性色彩：
- 史诗奇幻：金色、王者蓝、神圣白、史诗紫
- 黑暗奇幻：深紫、暗红、骨白、腐败绿
- 东方奇幻：水墨黑白、仙气蓝绿、朱砂红
- 中世纪奇幻：铁灰、暖棕、石头灰、旗帜红

**推荐风格**：概念艺术风、商业插画风（东方奇幻）

**创意参考方向**
- 环境叙事：场景中的每个细节都在讲故事，废墟暗示过去的战争，生长的植物暗示时间的流逝
- 光源神圣化：魔法光源从画面中心或关键点射出，制造神圣感或神秘感
- 生物与场景的融合：奇幻生物要与场景有机融合，不能像是贴上去的

---

### 1.3 角色插画

**适用场景**
虚构角色的全身立绘、角色设计展示、书籍/漫画角色插画、游戏角色概念图、个人艺术创作。

**角色设计的视觉维度**
角色插画要通过视觉传递角色的一切：
性格特征：颜色倾向、表情状态、姿态角度传递人物性格
背景故事：服装、武器、配件、伤疤传递角色的来历
能力特征：技能的视觉表现、与能力相关的光效或元素

**角色类型与视觉方向**

英雄/主角型：
通常有清晰的面部和眼神，传递人物的精神和坚定感
色调：与阵营或能力对应的颜色，视觉上有光感和力量感
姿态：战斗准备姿态或代表性动作，有动态感

反派/villain型：
通常有更强烈的视觉设计，不对称或有缺损感，传递危险感
色调：暗色或冷色为主，有腐败感或压迫感
姿态：俯视或统治性姿态，有压迫感

普通人/平民角色：
写实的服装和外观，没有夸张的战斗感
有生活质感，服装有磨损或个性化的细节

**风格分类**
写实风角色：真实人体比例，细节丰富，有摄影质感的光影
日系二次元角色：大眼睛，精致线条，平涂上色，柔和光感
美式漫画角色：夸张的肌肉或曲线，bold的线条，高对比色彩
欧式奇幻角色：写实与奇幻的融合，丰富的服装细节，画油画质感

**尺寸与格式**
全身立绘：通常2:3或3:4竖版
半身像：1:1或4:3
头像：1:1正方形

---

### 1.4 场景插画/环境艺术

**适用场景**
书籍/杂志插画、品牌场景插画、概念环境图、独立艺术创作的环境场景。

**核心设计逻辑**
场景插画要让观者感受到"想要进入这个场景"的冲动。光线、大气感、细节的叙事性，是场景插画的三大核心要素。

**场景插画的情绪维度**
治愈/宁静场景：柔和自然光，有生活感的场景细节，低饱和暖色
壮阔/史诗场景：宏大的自然或人造景观，戏剧性光影，有纵深感的构图
神秘/探索场景：幽深的路径，若隐若现的光源，有未知感的远景
恐怖/不安场景：异常的环境细节，扭曲的光影，有压迫感的构图

**色彩推导**
场景插画的色彩完全服务于情绪目标：
治愈场景：暖白、草木绿、日光橙，低对比柔和感
史诗场景：戏剧性冷暖对比，金色日光加蓝灰阴影
神秘场景：深色为主，局部冷色光源，高对比
恐怖场景：高度去饱和，异常的色彩（病态绿、腐败黄），强对比

---

### 1.5 商业插画/品牌插画

**适用场景**
品牌吉祥物设计、产品配套插画、书籍/杂志封面插画、广告配图插画、网页/APP插画。

**与概念艺术的核心区别**
商业插画服务于品牌传播和内容辅助，创意要在品牌调性的框架内。概念艺术有更大的自我表达空间，商业插画的视觉语言要让目标受众看懂并产生共鸣。

**商业插画风格方向**
扁平插画（Flat Illustration）：几何化、简洁、配色有限、无立体感
2.5D插画：有等距视角，介于2D和3D之间，科技/商务类常用
水彩风插画：手工质感，边缘柔和，自然有机感，适合食品/生活类
线条插画：精细的线条，无填充或极简填充，干净专业感
立体/3D风格插画：模拟3D渲染效果，现代感强，科技类品牌常用

**品牌插画的视觉规范**
色彩要与品牌色系严格对应，不能用品牌禁用色
风格一致性是系列插画的核心，不同场景的插画必须是同一视觉语言
角色/吉祥物的比例、表情、动态要有统一的规范

---

## 二、概念艺术与插画通用规范

### 2.1 风格描述要素

生成概念艺术和插画时，提示词需要明确描述的维度：
世界观/题材：科幻/奇幻/现实/其他
风格参考：与哪类已有视觉风格最接近
色调方向：冷/暖，高/低饱和，明/暗
光源设定：自然光/人工光，位置和强度
细节密度：简洁极简/中等细节/极度丰富细节

### 2.2 参考图调用规则

概念艺术通常为【文生图】，完全由创意描述驱动
如有特定的风格参考图：【图生图：场景参考图】，参考氛围而非复制内容
如有特定的角色设定图：【图生图：商品图】（将角色设定稿作为"商品图"调用），保留角色外观特征
