# 品牌视觉与品牌故事图场景

## 场景说明

品牌视觉的任务不是展示产品，而是传递"这个品牌是谁"。品牌故事图、品牌形象图、品牌理念视觉，都在回答同一个问题：这个品牌代表什么价值观，它的用户是什么样的人，它与竞争对手有什么本质不同。

**品牌视觉与产品视觉的根本区别**
产品视觉以产品为主角，品牌视觉以品牌的精神、价值观和生活方式为主角。产品可以出现，但它是品牌世界观的道具，不是视觉核心。一张好的品牌视觉图，拿掉产品和logo，看到的依然应该能感受到这个品牌的气质。

---

## 一、子场景识别与创意策略

### 1.1 品牌形象主视觉（Brand Key Visual）

**使用场景**
品牌官网首屏、品牌发布会主视觉、品牌年度主题图。是品牌视觉体系的最高层级，代表品牌在当前时期最想传递的核心主张。

**创意策略**
品牌形象主视觉通常有一个"品牌主张"（Brand Statement）作为创意出发点，视觉创意的任务是把这个抽象主张转化为一个具体、有冲击力的视觉意象。

创意路径：
主张具象化：把品牌主张（如"突破边界"、"回归自然"）转化为具体的视觉场景或符号
情绪视觉化：把品牌想让用户感受到的情绪，转化为对应的色彩、光线、空间状态
用户镜像：展示使用品牌产品/服务的人的生活状态，让目标用户产生"这就是我想成为的人"的共鸣

**品牌类型与视觉方向**

科技品牌：未来感、精密感、突破感；深色背景加冷光加几何元素；极简但有力量
奢侈/高端品牌：神秘感、工艺感、独特性；大面积留白、精致细节、克制色调
生活方式品牌：真实感、温度感、美好生活状态；自然光、生活场景、情感共鸣
户外/运动品牌：力量感、自由感、挑战精神；自然背景、动态感、高对比色彩
食品/饮料品牌：自然感、新鲜感、愉悦感；明亮色彩、食材质感、温暖光线

**色彩推导**
场景维度：品质感与信任感场景（高端品牌）或亲和力场景（生活方式品牌）
主题维度：与品牌核心价值观深度匹配，品牌视觉的色彩是品牌性格的直接表达
配色方案：品牌视觉通常有固定的品牌色系，在此基础上根据年度主题做适度延伸

**推荐风格**：根据品牌调性，不受单一风格限制

**创意参考方向**
- 情绪具象化：把品牌精神（自由、突破、温柔）转化为可感知的自然意象或人物状态
- 比例颠覆：人物或产品与环境的非常规比例关系，传递品牌的非凡感
- 符号化表达：用一个强烈的视觉符号代表整个品牌主张

---

### 1.2 品牌故事图（Brand Story Visual）

**使用场景**
品牌官网的"关于我们"页面、品牌发展历程展示、创始人故事、品牌理念传播图。目标是建立用户对品牌的情感认同，让用户不只是买产品，而是认同品牌的价值观。

**创意策略**
品牌故事图要有叙事性，不能只是漂亮的静态画面。每张图在品牌故事的叙事线上都有位置：起点（品牌缘起）、发展（关键时刻）、当下（品牌状态）、未来（品牌方向）。

人物是品牌故事的最佳载体。创始人、工匠、核心用户的真实形象和状态，比任何概念视觉都更有说服力。如果是概念图而非真实摄影，要追求"看起来像真实故事的一部分"的质感。

**故事类型与视觉方向**

创始人故事
视觉：创始人在工作/思考状态中，自然光，真实的工作场景
情绪：真实、专注、有信念感
避免：过于正式的摆拍感，商业广告感

工艺/品质故事
视觉：产品制作过程中的关键工序，工匠的手部特写，材料细节
情绪：精益求精、用心、工艺传承
光线：侧光强化材质质感，暖色调传递手工温度

品牌历史/里程碑
视觉：时间感强的图片，旧照片质感，历史场景重现
情绪：沉淀、传承、积累
色调：可以有意做旧处理，低饱和暖棕色调

用户故事/社群故事
视觉：真实用户在使用品牌产品时的自然状态
情绪：归属感、认同感、共同价值观
避免：摆拍感和广告感

**色彩推导**
场景维度：文化感与仪式感场景，兼顾亲和力
主题维度：根据品牌调性，故事类图片整体色调比品牌主视觉更温暖、更有人情味
配色方案：品牌故事图通常偏低饱和、有历史感的温暖色调，与品牌主视觉形成层次

**推荐风格**：写实风、自然有机风

**创意参考方向**
- 局部叙事：用一个有象征意义的细节（工匠的双手、磨损的工具、第一件产品）暗示整个品牌故事
- 深度层次构图：人物在有质感的工作环境中，前中后景传递故事的时间感和空间感
- 情绪具象化：品牌精神（坚持、匠心、热爱）的视觉具象化

---

### 1.3 品牌理念传播图（Brand Values Visual）

**使用场景**
品牌的社会责任传播、品牌价值观表达、品牌态度声明。不销售产品，只传递品牌立场和价值观。

**创意策略**
品牌理念图是品牌对话的最高层级，它在说"我们相信什么"而非"我们卖什么"。这类图通常配合有力量的文案，视觉和文字共同传递品牌立场。

核心创意要点：
真诚感：品牌理念图一旦显得虚伪或走形式，会引发强烈的负面反应。视觉要传递真实、有温度、有底气的立场
与产品的连接：理念不能脱离品牌的实际产品和业务，要找到理念和产品之间真实的内在连接
普世情感：最有传播力的品牌理念是能让大多数人产生共鸣的普世情感——家庭、自然、成长、创造

**色彩推导**
场景维度：文化感与仪式感场景（严肃话题）或亲和力场景（温暖话题）
主题维度：与品牌理念的情感基调高度匹配
配色方案：品牌理念图通常用更克制、更有思考感的配色，避免过于商业的高饱和色彩

---

### 1.4 品牌联名视觉（Collaboration Visual）

**使用场景**
两个品牌联名合作的宣传视觉，要同时传递两个品牌的调性，并展示联名的化学反应。

**创意策略**
联名视觉最大的挑战是平衡两个品牌的视觉语言，不能让一方完全主导而另一方消失。同时要展示"1+1>2"的联名价值——为什么这两个品牌的合作是有意义的？

视觉平衡策略：
两个品牌视觉元素的均等呈现，避免一方明显强势
找到两个品牌的共同美学语言作为联名视觉的基础
联名产品本身作为视觉主角，两个品牌的标识作为辅助

**色彩推导**
两个品牌色系的融合或对比，通常选择一个品牌主色加另一个品牌的点缀色
避免两个品牌色系直接冲突，需要找到视觉和谐的融合方案

---

### 1.5 品牌周年/纪念视觉

**使用场景**
品牌重要周年庆典、品牌历史纪念活动、限定纪念版产品发布。

**创意策略**
周年视觉要同时传递两件事：对过去的致敬（历史感、沉淀感）和对未来的展望（活力感、前瞻感）。数字（周年数字）通常是视觉的核心元素，要做到视觉最突出。

历史感的视觉处理：旧照片元素、年份数字的时间线展示、创始之初的视觉符号
活力感的视觉处理：现代的设计语言、当下的品牌美学、未来的视觉方向暗示

**色彩推导**
周年庆通常用品牌经典色加金色，金色传递珍贵感和纪念感
如是重要整数周年（10、20、50年），可以用更戏剧化的色彩处理

---

## 二、品牌视觉通用规范

### 2.1 品牌一致性原则

品牌视觉的所有图片要在品牌色系、字体风格、构图语言上保持高度一致性。一致性本身就是品牌资产——用户通过视觉风格识别品牌，这种识别需要长期积累。

在生成品牌视觉前，需要明确：
品牌主色系：品牌的核心色彩，所有视觉的基础
品牌调性：高端/大众、年轻/成熟、严肃/轻松、全球/本土
品牌禁区：不属于这个品牌的视觉元素和色彩

### 2.2 真实性原则

品牌视觉最大的陷阱是"看起来像是任何品牌都可以用的通用图片"。好的品牌视觉要有辨识度，拿掉logo也能认出是哪个品牌。

创意中要主动加入品牌的独特性：特定的产品特征、品牌专属的视觉符号、与品牌历史相关的元素。
