# 任务执行指南

*轻量级知识库 - 法规层*

## 任务分类

### 1. 定时性例行任务

**定义**: 按固定频率执行的标准化任务

**判断特征**:
- ✅ 频率固定（每日/每周/每月）
- ✅ 产出格式稳定
- ✅ 执行逻辑可标准化

**示例**:
- 每日晨间检查
- 每周综合复盘
- 每日进化任务

**执行流程**:
```
1. 检查任务节奏表 (task_rhythm.json)
2. 加载相关知识节点
3. 执行标准化流程
4. 更新案例库（如果产生新经验）
5. 生成产出物（如果有）
```

### 2. 日常突发任务

**定义**: 用户临时提出的有一定规模的需求

**判断特征**:
- ⚡ 触发时机不固定
- 🔗 需要跨知识库节点协同
- 📊 有一定复杂度

**执行流程**:
```
1. 理解需求本质
2. 查询用户画像 (user_profile.json)
3. 查询历史案例 (memory/kb/nodes/)
4. 制定执行方案
5. 报备并获取确认
6. 执行并记录
7. 沉淀到案例库
```

### 3. 日常沟通应答

**定义**: 即时交互、信息确认、状态查询

**判断特征**:
- ⚡ 响应即时性要求高
- 📝 不产生长期文件产出
- 💬 需遵循沟通风格原则

**执行原则**:
- 快速响应
- 简洁明了
- 符合沟通风格

## 任务执行模板

### 模板 1: 定时任务

```bash
# 检查任务
bash skills/lightweight-kb/scripts/query.sh task [任务名]

# 加载配置
source <(jq -r '.weekly[] | "task_\(.id)=\(.)"' data/task_rhythm.json)

# 执行
if [ "$task_35_enabled" = "true" ]; then
    echo "执行综合复盘..."
fi
```

### 模板 2: 突发任务

```bash
# 1. 查询用户画像
PROFILE=$(bash skills/lightweight-kb/scripts/query.sh profile | jq '.')
echo "$PROFILE" | jq '.traits'

# 2. 查询历史案例
CASES=$(find memory/kb/nodes -name "*.json" -exec jq -c '. | select(.type == "task_execution")' {} \;)
echo "$CASES" | jq -s '.'

# 3. 制定方案（根据用户特质）
# ...

# 4. 报备用户
echo "方案已制定，是否执行？(确认/取消)"
```

### 模板 3: 沟通应答

```bash
# 快速查询
RESULT=$(bash skills/lightweight-kb/scripts/query.sh [类型] [关键词])
echo "$RESULT"

# 自然语言回复（避免技术细节）
echo "根据你的情况，我建议..."
```

## 验收标准

### 定时任务验收

| 检查项 | 标准 |
|--------|------|
| 执行时间 | 在规定时间±30min 内 |
| 产出文件 | 位于 `outputs/` 目录 |
| 知识更新 | 索引文件已更新 |
| 案例沉淀 | 如有新经验，已记录 |

### 突发任务验收

| 检查项 | 标准 |
|--------|------|
| 需求理解 | 准确重述用户需求 |
| 方案定制 | 考虑用户特质和历史模式 |
| 执行记录 | 完整记录在案例库 |
| 用户确认 | 获得用户确认 |

## 知识库节点依赖

### 常用查询

**查询用户特质**:
```bash
bash query.sh profile "traits"
```

**查询任务节奏**:
```bash
bash query.sh task
```

**查询历史案例**:
```bash
find memory/kb/nodes -name "*.json" | xargs jq '.'
```

## 任务执行检查清单

### 执行前

- [ ] 理解任务目标
- [ ] 加载相关配置
- [ ] 检查知识库状态
- [ ] 确认资源就绪

### 执行中

- [ ] 遵循沟通风格
- [ ] 定期更新进度（如需要）
- [ ] 处理异常情况
- [ ] 记录关键步骤

### 执行后

- [ ] 验证产出质量
- [ ] 更新知识索引
- [ ] 沉淀方法论（如适用）
- [ ] 通知用户完成

## 异常处理

### 常见异常

| 异常 | 处理方式 |
|------|----------|
| API 调用失败 | 重试 3 次，失败则报备 |
| 文件不存在 | 检查路径，更新索引 |
| 用户未确认 | 暂停执行，等待确认 |
| 超时 | 停止并报备，说明原因 |

### 报备格式

```
⚠️ 任务执行异常

任务: [名称]
异常: [描述]
已尝试: [处理措施]
建议: [后续方案]

是否继续？(确认/取消)
```

---

**最后更新**: 2026-02-05
