# The Mental Load — Research Summary

## What It Is
The mental load (also: cognitive labor, invisible work, worry work) is the behind-the-scenes cognitive and emotional work of managing a household and relationships. It's not the *doing* — it's the *thinking about what needs doing*.

## The Four Stages (Daminger, 2019)
1. **Anticipating** — noticing a need before it becomes urgent
2. **Identifying** — researching options and solutions
3. **Deciding** — choosing among options
4. **Monitoring** — tracking progress and following up

## Six Types of Cognitive Labor (Dean et al., 2019)
1. Planning and strategizing
2. Monitoring and anticipating needs
3. Meta-parenting (thinking about parenting approaches)
4. Knowing (holding knowledge about family members' needs, preferences, schedules)
5. Managerial thinking (delegating, coordinating)
6. Self-regulating (managing one's own emotional responses)

## Why It Matters
- Falls disproportionately on one partner (typically women/mothers)
- Is invisible — the person not carrying it often doesn't know it exists
- Causes burnout, resentment, and relationship strain
- Cannot be "helped with" by asking "what do you need me to do?" — that itself adds to the load

## What This Skill Does Differently
Instead of adding MORE to think about, this skill **takes things OFF the mental load** by:
- Anticipating needs so the user doesn't have to
- Tracking important dates, milestones, and relationships
- Proactively suggesting actions at the right time
- Gently nudging without nagging
- Building a knowledge base about the user's people over time

The goal: make the user a better partner, parent, friend, and family member — not by doing more work, but by having less invisible work to carry.
