---
name: letterboxd-watchlist
description: Scrape a public Letterboxd user's watchlist into a CSV/JSONL list of titles and film URLs without logging in. Use when a user asks to export, scrape, or mirror a Letterboxd watchlist, or to build watch-next queues.
---

# Letterboxd Watchlist Scraper

Use the bundled script to scrape a **public** Letterboxd watchlist (no auth).
Always ask the user for the Letterboxd username if they did not provide one.

## Script

- `scripts/scrape_watchlist.py`

### Basic usage

```bash
uv run scripts/scrape_watchlist.py <username> --out watchlist.csv
```

### Robust mode (recommended)

```bash
uv run scripts/scrape_watchlist.py <username> --out watchlist.jsonl --delay-ms 300 --timeout 30 --retries 2
```

### Output formats

- `--out *.csv` → `title,link`
- `--out *.jsonl` → one JSON object per line: `{ "title": "…", "link": "…" }`

## Notes / gotchas

- Letterboxd usernames are case-insensitive, but must be exact.
- The script scrapes paginated pages: `/watchlist/page/<n>/`.
- Stop condition: first page with **no** `data-target-link="/film/..."` poster entries.
- The scraper validates username format (`[A-Za-z0-9_-]+`) and uses retries + timeout.
- Default crawl delay is 250ms/page to be polite and reduce transient failures.
- This is best-effort HTML scraping; if Letterboxd changes markup, adjust the regex in the script.

## Scope boundary

- This skill only scrapes a public Letterboxd watchlist and writes CSV/JSONL output.
- Do not read local folders, scan libraries, or perform unrelated follow-up actions unless explicitly requested by the user.
