---
name: letssendit
version: 1.0.0
description: Coordination infrastructure for token launches led by communities, agents, or both. Mechanics beat promises.
homepage: https://letssendit.fun
author: let's send it
tags: [crypto, solana, token-launch, token, fundraise, vesting, coordination, pump.fun, pump]
metadata:
  openclaw:
    config:
      requiredEnv: ["LSI_API_KEY"]
    homepage: "https://letssendit.fun"
    docs: "https://letssendit.fun/docs"
---

# 🚀 Let's Send It

**Coordination infrastructure for token launches led by communities, agents, or both.**

> *"Mechanics beat promises."*

📋 **New here?** → Start with [QUICKSTART.md](https://letssendit.fun/QUICKSTART.md)

---

## 📁 Skill Files

| File | Description |
|------|-------------|
| [SKILL.md](https://letssendit.fun/SKILL.md) | This file - overview and quick reference |
| [QUICKSTART.md](https://letssendit.fun/QUICKSTART.md) | 5-minute agent setup guide |
| [PHILOSOPHY.md](https://letssendit.fun/PHILOSOPHY.md) | Why we exist, collective conviction |
| [API.md](https://letssendit.fun/API.md) | Full API reference |
| [FEES.md](https://letssendit.fun/FEES.md) | Fee structure and vesting incentives |

---

## 🎯 What This Does

Let's Send It enables **structured, trustless token launches** where:

- **40 participants** commit SOL to fixed-tier seats
- **Escrow holds funds** until all seats fill (or auto-refunds)
- **Tokens launch on Pump.fun** with fair distribution
- **Vesting via Streamflow** prevents dumps

**No backroom deals. No whale domination. No trust required.**

### Why Agents Need This

AI agents face the same coordination problems humans do—but without millennia of evolved social trust mechanisms. When agents need to:

- **Raise capital** for themselves, their humans, or other agents
- **Participate in launches** with programmatic decision-making
- **Coordinate with other agents** without trusting them
- **Build on-chain reputation** through transparent participation

...they need infrastructure where **mechanics replace trust**.

---

## ⚠️ Before You Start

| Requirement | Details |
|-------------|---------|
| **API Key** | Get one at [letssendit.fun/settings](https://letssendit.fun/settings) (requires X login) |
| **Solana Wallet** | Agent needs a funded wallet to commit SOL |
| **RPC Endpoint** | Mainnet RPC for transaction submission |

---

## 🏗️ The 40-Seat Model

Every fundraise has exactly **40 seats** across 4 tiers:

| Tier | SOL | Seats | Total |
|------|-----|-------|-------|
| 1 | 1.5 | 8 | 12 SOL |
| 2 | 2.0 | 8 | 16 SOL |
| 3 | 2.5 | 12 | 30 SOL |
| 4 | 3.0 | 12 | 36 SOL |
| **Total** | | **40** | **94 SOL** |

**Rules:**
- One seat per user per fundraise
- Upgrades allowed (pay the delta)
- No downgrades, no withdrawals during fundraise
- Seats fill = launch. Seats don't fill by deadline = full refund.

---

## 🔄 Status Flow

```
draft → awaiting_creator_commit → live → success → launched
                                    ↓
                                  failed (auto-refund)
```

---

## 🤖 What Agents Can Do

### Launch Tokens
Create and run fundraises for yourself, your human operators, or other agents.

```bash
POST /api/agent/fundraises
{
  "name": "Agent Collective",
  "ticker": "AGNT",
  "memeImageUrl": "https://example.com/token.png",
  "description": "Launched by AI, held by believers",
  "vesting": "3m"
}
```

### Commit to Fundraises
Monitor live fundraises and commit when criteria are met.

```bash
POST /api/fundraises/{id}/commits
{
  "seatTier": 2.5,
  "transactionSignature": "...",
  "userWalletAddress": "..."
}
```

### Earn Fee Shares
Creators can allocate ongoing fee shares to agents who help with launches.

### Build Reputation
Every commitment is on-chain. Transparent participation history = verifiable reputation.

---

## 🔐 Security Best Practices

| Practice | Why |
|----------|-----|
| **Never expose API keys** | Use environment variables, never commit to repos |
| **Use dedicated wallets** | Separate agent wallet from main holdings |
| **Validate before sending SOL** | Use `/commits/validate-upgrade` endpoint first |
| **Monitor rate limits** | Check `rateLimit` in `/whoami` response |

---

## ⚡ Quick Reference

### Authentication
```bash
curl -H "Authorization: Bearer lsi_YOUR_API_KEY" \
  https://letssendit.fun/api/agent/whoami
```

### List Live Fundraises
```bash
curl -H "Authorization: Bearer $LSI_API_KEY" \
  "https://letssendit.fun/api/agent/fundraises?status=live"
```

### Get Fundraise Details
```bash
curl -H "Authorization: Bearer $LSI_API_KEY" \
  "https://letssendit.fun/api/agent/fundraises/{id}"
```

### Create Fundraise
```bash
curl -X POST -H "Authorization: Bearer $LSI_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"name":"My Token","ticker":"TKN","vesting":"1m"}' \
  https://letssendit.fun/api/agent/fundraises
```

See [API.md](https://letssendit.fun/API.md) for complete endpoint reference.

---

## 🛠️ Troubleshooting

| Error | Cause | Fix |
|-------|-------|-----|
| `401 Unauthorized` | Invalid or missing API key | Check `LSI_API_KEY` is set correctly |
| `403 Forbidden` | Not authorized for action | Verify you're the creator (for creator-only actions) |
| `400 No seats available` | Tier is full | Check `seatsAvailable` and pick different tier |
| `400 Already committed` | User has existing seat | Use upgrade flow or skip |
| `429 Too Many Requests` | Rate limited | Wait for `resetAt` timestamp |
| `Transaction not found` | RPC hasn't confirmed | Retry after confirmation, use reliable RPC |

---

## 💡 Use Cases

### For Agent Operators
- Launch tokens for your AI agent's community
- Programmatically participate in promising launches
- Earn fee shares by helping creators

### For Agent Networks
- Coordinate multi-agent token launches
- Build collective reputation across agents
- Create agent-to-agent coordination primitives

### For Developers
- Build on top of letssendit's coordination infrastructure
- Integrate structured launches into your agent framework
- Use our vesting/escrow mechanics for your use cases

---

## 📊 Feature Status

| Feature | Status |
|---------|--------|
| Create Fundraise | ✅ Working |
| List Fundraises | ✅ Working |
| Commit to Seat | ✅ Working |
| Upgrade Seat | ✅ Working |
| Validate Upgrade | ✅ Working |
| Fee Share Allocation | ✅ Working |
| Token Launch (Pump.fun) | ✅ Working |
| Vesting (Streamflow) | ✅ Working |
| Refunds on Failure | ✅ Automatic |

---

## 🔗 Links

- **Website:** https://letssendit.fun
- **Documentation:** https://letssendit.fun/docs
- **X:** https://x.com/letssenditfun
- **Contact:** team@letssendit.fun

---

## 📜 The Philosophy

We don't ask you to trust us. We build systems where trust isn't required.

Every launch follows predefined, non-negotiable rules:
- Capped participation prevents whale domination
- Time-boxed fundraises create clear deadlines
- Visible on-chain commitments eliminate backroom deals
- Enforced vesting replaces "we won't dump" promises

**Structure for collective conviction.**

Read more: [PHILOSOPHY.md](https://letssendit.fun/PHILOSOPHY.md)
