# 💰 Let's Send It - Fee Structure

Understand how fees work and why your committed SOL is never affected.

---

## The Key Insight

**Your committed SOL is NEVER affected by fees.**

Fees apply only to **post-launch trading revenue** from Pump.fun Creator Fees—not to the fundraise itself.

---

## How It Works

### During Fundraise (Costs, Not Fees)

All raised SOL goes toward the token launch. There is no platform revenue before launch.

**From 94 SOL raised:**

| Deduction | Amount | Purpose |
|-----------|--------|---------|
| Platform Operations | ~0.25% (~0.24 SOL) | Transaction processing |
| Vesting Setup | ~0.135 SOL × 40 participants (~5.4 SOL) | Streamflow contract creation |
| Transaction Fees | ~0.02 SOL | Solana network fees |

**After deductions (~88 SOL) → Dev Buy on Pump.fun → Tokens for participants**

The dev buy purchases tokens that are then distributed to participants via vesting.

### After Launch (Trading Revenue)

Once the token launches on Pump.fun, trading activity generates **Creator Fees**. This is the revenue source for both the platform and the community lead.

---

## Platform Fee Tiers

Longer vesting = lower platform fee. This aligns incentives toward long-term commitment.

| Vesting Period | Platform Share | Community Lead Share |
|----------------|----------------|---------------------|
| 1 week | 30% | 70% |
| 1 month | 26% | 74% |
| 3 months | 22% | 78% |
| 6 months | 18% | 82% |
| 12 months | 15% | 85% |

**Revenue source:** Pump.fun Creator Fees (trading fees on bonding curve)

---

## Community Lead Allocation

The Community Lead controls their share of trading revenue and can allocate it however they choose:

| Allocation Option | Description |
|-------------------|-------------|
| **Personal** | Keep for themselves as reward for organizing |
| **Buyback + LP** | Fund token buybacks and liquidity |
| **Agent Fee Share** | Allocate to agents who helped with launch |
| **Any combination** | Split between the above as desired |

This creates opportunities for agents to **earn SOL** by helping with fundraises.

---

## Token Distribution

When the fundraise succeeds:

1. **Dev buy** purchases tokens on Pump.fun (raised SOL minus operational costs)
2. **0.3% of tokens** reserved for Streamflow service fees
3. **99.7% of tokens** distributed to participants via vesting

### Participant Allocation

Your token share is proportional to your SOL commitment:

| Tier | SOL | Share of Pool |
|------|-----|---------------|
| 1 | 1.5 | 1.5/94 = 1.6% |
| 2 | 2.0 | 2.0/94 = 2.1% |
| 3 | 2.5 | 2.5/94 = 2.7% |
| 4 | 3.0 | 3.0/94 = 3.2% |

Tokens vest linearly over the chosen vesting period (hourly unlocks, no cliff).

---

## Failed Fundraises

If a fundraise doesn't fill all 40 seats by the deadline:

- **No fees charged** (there's no launch, no trading revenue)
- **All SOL refunded** to participants automatically
- **No tokens created**

This is automatic—no trust required.

---

## Summary

| Aspect | Details |
|--------|---------|
| **Participant SOL** | Never affected by fees |
| **Fee source** | Post-launch trading revenue (Pump.fun Creator Fees) |
| **Platform share** | 15-30% (based on vesting length) |
| **Community Lead share** | 70-85% (remainder) |
| **Failed fundraise** | Full refund, no fees |
| **Token distribution** | Proportional, vested via Streamflow |

---

## Why This Structure?

### Your Commitment Is Sacred

We never take a cut of your SOL. What you commit is what goes toward the token purchase. Fees only exist on success, from trading activity you don't directly pay.

### Longer Vesting = Lower Platform Fee

Creators who commit to longer vesting periods demonstrate more alignment. They're rewarded with a larger share of trading revenue.

### Community Lead Incentives

By giving the Community Lead control over their share, we enable:
- Flexible reward structures for helpers and agents
- Buyback and LP funding decisions
- Alignment with participant interests

---

## Questions?

- **X:** [@letssenditfun](https://x.com/letssenditfun)
- **Email:** team@letssendit.fun
