# LetsPing OpenClaw Adapter

OpenClaw integration for LetsPing Agent Credentials & Behavioral Firewall.

This package provides a `letsping_ask(tool_name, args_json, risk_reason)` skill for OpenClaw agents. It routes high-risk actions through LetsPing’s firewall and (optionally) human-in-the-loop console using the same agent identity and guardrail model as other frameworks (LangGraph, CrewAI, Vercel AI SDK, custom Python). OpenClaw is just one adapter on top of LetsPing’s agent-first architecture.

Payloads are encrypted client-side using AES-GCM with the pairing secret. The relay server and database store only ciphertext.

## Installation

Clone into your OpenClaw workspace:

```bash
git clone https://github.com/CordiaLabs/openclaw-skill ~/.openclaw/workspace/skills/letsping
```

Install dependencies:

```bash
cd ~/.openclaw/workspace/skills/letsping
npm install
```

Restart the OpenClaw gateway.

## Configuration

Add to `~/.openclaw/openclaw.json`:

```json
{
  "skills": {
    "entries": {
      "letsping": {
        "env": {
          "LETS_PING_SECRET": "lp_live_..."
        }
      }
    }
  }
}
```

*Note: The Supabase URL and Key are pre-configured for LetsPing. You can override them with `LETSPING_SUPABASE_URL` and `LETSPING_SUPABASE_ANON_KEY` for self-hosting.*

Obtain `LETS_PING_SECRET` by pairing at https://letsping.co/openclaw/pair, or by using LetsPing’s Agent Credentials API to provision a dedicated agent key for your OpenClaw gateway.

## Usage

Add the following to your agent's system prompt or `AGENTS.md`:

```
You have full authority for safe actions: reading files, logs, web searches, data analysis without side effects.

You MUST call letsping_ask BEFORE any high-risk action. NEVER execute high-risk actions directly.

High-risk includes:
- Financial: Spending money, bookings, transactions > $10
- Destructive: Delete/overwrite files, DB rows, configs
- Social: Posting, sending DMs/emails to new/public contacts
- Infrastructure: Modifying DNS, env vars, deployments, infra APIs

Provide:
- tool_name: exact tool name
- args_json: stringified JSON of arguments
- risk_reason: clear justification

After call:
- APPROVED: Use ONLY authorized_payload (may be patched)
- REJECTED or timeout: Abort, retry safely, or ask for guidance

Example:
letsping_ask(tool_name: "vercel_deploy", args_json: "{\"project\":\"my-app\",\"env\":\"production\",\"force\":true}", risk_reason: "Production deployment with force flag")
```

## Security Model

Payloads are encrypted on the agent using AES-GCM derived from `LETS_PING_SECRET`. Only ciphertext is sent to the relay and stored in Supabase. Decryption occurs solely on paired devices using the same secret from local storage.

The relay cannot read payloads.

## How It Works

1. Agent calls `letsping_ask` for a high risk action.
2. Skill encrypts payload locally and sends ciphertext to relay.
3. Relay stores request and notifies paired device.
4. Human reviews (decrypts), optionally edits, then approves/rejects.
5. On approval, relay returns patched ciphertext (or original).
6. Agent decrypts and resumes with authorized payload.

Default timeout: 10 minutes.

## Troubleshooting

- Skill not loading: Check gateway logs (`openclaw gateway --log-level debug`). Ensure `npm install` succeeded.
- Agent skips call: Use strong models (Claude Opus, GPT-4o). Add more prompt examples.
- No notifications: Verify pairing and browser permissions.
- Timeout errors: Agent should handle gracefully.

Issues/PRs: https://github.com/CordiaLabs/openclaw-skill

https://letsping.co