# Legiit Playbook

Internal reference for agents using the `legiit-marketplace` skill.
Use this to think through a situation quickly; **do not** output it verbatim.

---

## Quick Triage

Clarify these points fast, then choose a path:

- **Buyer goal:** one-time task, recurring work, long-term partner, or rescue a troubled order?
- **Constraints:** budget ceiling, due date, required quality bar, communication expectations.
- **Stage:** pre-order, in-order, revision, or completion (delivery acceptance).

---

## Buyer Intake – Ask Up To 3 Questions

Use only as needed, and ask **max 3 at a time**:

1. What exact output must be delivered (file type, length, format, outcome)?
2. What deadline is fixed, and what’s flexible?
3. What is the maximum budget for this, including possible revisions?
4. What examples define “good enough” quality for you?
5. Which part of the scope is non-negotiable?
6. Which risk matters most: missed deadline, weak quality, poor communication, or budget overrun?

If you still lack details, state simple assumptions and move on.

---

## Simple Offer Comparison (No Scoring)

When the user is choosing between 2–3 services, mentally check these:

- **Scope Fit**
- Does the description clearly match the deliverables and constraints?
- Are there obvious gaps (channels, file types, quantities) vs what the user needs?

- **Proof / Evidence**
- Does the seller show relevant examples or portfolio?
- Are results and samples aligned with the buyer’s niche / style / complexity?

- **Timeline Realism**
- Is the delivery time realistic for the requested scope?
- Does it look rushed for the level of work?

- **Communication & Clarity**
- Is the description clear and concrete?
- If they’ve already talked, are their answers specific and confident?

- **Revisions & Terms**
- Do revision terms match what the buyer expects?
- Any obvious mismatch (“1 revision only” vs “iterative creative work”)?

- **Price vs Outcome**
- Does the price seem reasonable for the outcome, not just cheap?

**Heuristic:**
- If **most checks look solid** → recommend proceeding with that option.
- If **2 or more areas feel weak or unclear** → advise:
- “Do not buy yet — send a clarification message,” or
- “Expand the shortlist and look for a clearer match.”

No numeric scores. Just a clear yes/lean/no based on the above.

---

## Red Flags Checklist

Escalate risk when you see any of:

- Very broad promises but **vague deliverables**.
- Seller avoids specifics on files, turnaround, or where scope stops.
- **Unrealistic timelines** for complex work.
- Requirements have **changed a lot** from what the seller originally quoted.
- Delayed or inconsistent communication during pre-order.
- Pressure to move work or payment **off-platform**.

When red flags are present:
- Recommend clarifying everything in writing on-platform.
- Use a `Do Not Buy Yet` note if the basics (deliverables, timeline, revisions) are unclear.

---

## Buyer Paths By Stage

### Pre-Order

1. Define the exact deliverable and acceptance criteria with the buyer:
- Files, formats, length/volume.
- “Done” definition and success criteria.
2. Help them create a **shortlist** of services that match scope + deadline.
3. Draft **clarifying questions** before purchase:
- What is included and excluded?
- What files will be delivered?
- How many revisions and what counts as a revision?
- What is the expected turnaround from brief handoff?
- Any dependencies that could delay delivery?
4. Recommend a service that best matches fit and clarity, not just lowest price.
5. If clarity is weak for all options, suggest **waiting** and sending a clarification message first.

### In-Order (Active Order)
1. Ensure the buyer sends **one structured kickoff message**:
- Outcome / goal
- Deliverables
- Must-haves and constraints
- Deadline and time zone
- Any examples or references
2. Confirm timeline checkpoints and expected update frequency.
3. Encourage keeping key decisions in the Legiit order thread (avoid scattered instructions).
4. If things drift, suggest a mid-order check-in:
- Reconfirm scope,
- Reconfirm deadline and any new constraints.

### Revision and Closeout

1. Tie revision requests to **explicit criteria**, not just preference:
- “This doesn’t match the agreed X because Y.”
2. Encourage **batched feedback**:
- One prioritized list instead of many small messages.
3. Before closure, confirm:
- All requested changes are addressed or explicitly accepted as exceptions.
4. Suggest the buyer confirm **final files and rights** (where relevant) before approving.

---

## Delivery Acceptance Checklist

Use this mentally before advising the buyer to accept:

- Files and formats match the agreed brief.
- Core requirements are complete and testable.
- Agreed revisions are complete or explicitly deferred by mutual agreement.
- Any promised **source/editable files** are included (where applicable).
- Final handoff is documented in the Legiit order thread.

If any of these fail, recommend a clear, objective revision request instead of accepting.

---