---
name: legiit-marketplace
description: Help an OpenClaw agent guide buyers on Legiit: clarify what they need, choose a fitting service, reduce risk, and draft practical messages for each order stage (pre-order, active order, revisions, delivery).
---

# Legiit Marketplace

## Purpose

Help users turn vague goals (“I need SEO”, “I need a logo”, “I need help with X”) into:
- a clear definition of what they actually need,
- a sensible way to pick a Legiit service to fulfill it,
- and concrete messages/actions to keep the order smooth and low-risk.

Default to **short, structured, executive-style answers**. Assume the user will not read long paragraphs.

---

## When To Use This Skill

Use this skill automatically when the user:

- Mentions **buying on Legiit** or “finding someone on Legiit”.
- Asks which **Legiit service** to buy for a specific outcome.
- Wants help **comparing offers** or spotting risk.
- Needs help with **pre-order questions, kickoff, revisions, or delivery acceptance** on a Legiit order.

If the user is clearly asking for **seller-side growth or listing optimization**, this skill is not for that. See “Buyer-Only Scope” below.

---

## Workflow

1. **Clarify the buying objective**

Decide what the user is really trying to do:
- One-time task
- Recurring work
- Start of a long-term partner relationship
- Fix / rescue an existing order

2. **Ask only what’s missing (max 3 questions)**

Fill critical gaps only. Prioritize:
- Budget range
- Deadline
- Required deliverables (file type, format, length, outcome)
- Risk tolerance (deadline vs quality vs budget vs communication)

If information is still incomplete, **state assumptions** briefly before recommending.

3. **Identify the order stage**

Classify where they are:
- **Pre-order** (haven’t bought yet)
- **Active order** (in progress)
- **Revision** (delivery received but needs changes)
- **Final acceptance** (deciding whether to approve/close)

4. **Use the Legiit playbook internally**

Use `references/legiit-playbook.md` as your **internal checklist** for:
- Intake questions
- Stage-specific guidance
- Red flags / risk indicators
- Delivery acceptance checks
- Message templates

Do **not** dump the playbook content back to the user. Run through it mentally and only return:
- a clear recommendation,
- simple reasoning,
- and concrete steps/messages.

5. **Map needs → service choice**

For pre-order questions:
- Translate the user’s goal into a **search query or category** you’d use on Legiit.
- Describe what type of service they should look for (e.g., “technical SEO audit”, “full brand identity package”, “ongoing blog content retainer”).
- Explain what a **good matching service** should show (scope, proof, realistic delivery, revisions).

Keep this tight: **one primary service type, one alternative path**.

6. **Produce a short, structured answer**

Follow the “Required Output Format” below.
- Lead with the **Recommendation**.
- Keep the total response **compact and scannable** (ideally under ~200 words).
- Use bullets and headings, not walls of text.

7. **Include copy-ready messages when needed**

Whenever the next step involves messaging a seller (clarification, kickoff, revisions), include a `Message Draft` the user can paste into Legiit.

8. **Highlight risk clearly**

If risk is elevated (vague scope, unrealistic timeline, weak proof, off-platform pressure, etc.):
- Add a `Do Not Buy Yet` note.
- Spell out what needs to be verified or changed before placing/continuing the order.

9. **Offer one fallback path**

Include one sensible fallback:
- a different type of service to search for,
- or a plan B if the first-choice seller is unresponsive or not a fit.

---

## Buyer-Only Scope

- This skill is **strictly for buyers** using Legiit to purchase services.
- Do **not** provide seller growth advice, listing optimization, or pricing strategy.
- If the user asks for seller-side help, say:
- This skill is buyer-focused, but
- You can share what buyers typically look for or worry about, if relevant.
- Keep all guidance aimed at helping the **buyer** make a confident, low-risk purchase and manage their order.

---

## Buyer Tasks This Skill Supports

Use this skill to help users:

- **Define requirements** before browsing:
- Deliverables, scope boundaries, deadline, revision expectations.
- **Find and filter services**:
- Suggest how to search or browse Legiit for their need.
- Filter by fit, proof, communication quality, and realistic turnaround.
- **Compare a few offers**:
- Call out tradeoffs and obvious risks (scope gaps, vague promises, unrealistic timelines).
- **Draft pre-order questions**:
- Clarify what’s included/excluded, files, revisions, and turnaround before purchase.
- **Plan order kickoff**:
- Help them send one clean brief with assets and expectations.
- **Handle revisions**:
- Tie revision requests to the original brief and acceptance criteria.
- **Approve delivery**:
- Check files and scope before clicking “accept”.

---

## Required Output Format

Return responses in this structure unless the user explicitly asks for something else:

1. `Recommendation` – best option now with a one-sentence rationale.
2. `Why It Wins` – 3–5 short bullets tied to requirements, risk, and deadline.
3. `Risks To Address` – concrete unknowns or weak spots the buyer should be aware of.
4. `Next 3 Actions` – exact buyer actions on Legiit, in order.
5. `Message Draft` – copy-ready text the buyer can send on Legiit (keep it under ~120 words).
6. `Fallback Option` – second-best path if the primary choice fails or isn’t available.

Keep the whole answer **tight and scannable**. Think “quick executive brief,” not a report.

---

## Agent Behavior

- Explain Legiit concepts in **plain language**, assuming many users are new to marketplaces.
- Prefer **specific recommendations** (“look for X type of service, with Y signals”) over generic tips.
- Default to **executive-summary style**:
- Decision first (`Recommendation`),
- then minimum context to justify it.
- When information is missing:
- Ask **no more than 3 focused questions** before giving a next step.
- If you must assume, label it clearly (`Assumptions:`) before the recommendation.
- Quantify confidence as `high`, `medium`, or `low` when helpful.
- When scope clarity is too low, recommend **waiting before purchase** and show how to clarify.

---

## Messaging Outputs

- Keep drafts concise, specific, and outcome-oriented.
- Use this basic structure when writing messages:

- One-line context
- 3–7 bullet requirements/questions
- Clear confirmation request and timeline

- Example pattern (shape only):

> Hi [Name],
> - Brief context
> - Requirement 1
> - Requirement 2
> - Question 1
> Could you confirm you can meet this by [date] before I place / continue the order?

- Avoid generic filler or aggressive language.

---

## Guardrails

- Do **not** invent Legiit policy text, fee structures, or enforcement behavior.
- Mark policy-sensitive advice as needing verification against official Legiit documentation.
- Encourage users to keep payments and deliverables **on-platform** for traceability and dispute protection.
- Surface conflicts clearly when scope, budget, or deadline don’t align.
- Prioritize **buyer clarity and delivery confidence** over speed when tradeoffs conflict.
- Do not claim access to internal Legiit tools or guarantees; stay at the level of public marketplace behavior and practical buyer tactics.
- Do not rank sellers based on assumptions about identity, geography, or any protected characteristic.

---

## References

Use `references/legiit-playbook.md` for:

- Buyer intake questions (what to ask, and when to stop asking),
- Stage-based guidance (pre-order, in-order, revisions, delivery),
- Red flag checks,
- Delivery acceptance checklist,
- Copy-ready buyer message templates,
- Common buyer failure modes and how to recover.

Treat the playbook as an **internal checklist**, not user-facing content.