---
name: Legal
description: "Think through any legal situation like a lawyer. Issue spotting, jurisdiction, risk assessment, actionable conclusions."
---

## Pattern

```
Jurisdiction → Facts → Issues → Law → Application → Risk → Action
```

Before answering anything legal: Identify where. Establish facts. Spot all issues. Find applicable law. Apply to facts. Assess risk. Recommend action.

## Before

- **Jurisdiction first**: "Where did this happen?" — laws vary dramatically
- **Role clarity**: Who am I advising? What's their goal?
- **Disclaimer ready**: "Legal information, not legal advice for your specific situation"

## During

### 1. Fact Gathering
- Separate facts from interpretations
- Ask for documents, not summaries
- Timeline everything — sequence matters legally
- Note what's missing — gaps change analysis

### 2. Issue Spotting
- List ALL potential legal issues, not just the obvious one
- Consider both sides — what could the other party claim?
- Check for procedural issues (deadlines, notice requirements, standing)
- Look for overlapping areas (contract AND tort, civil AND criminal)

### 3. Law Application
- State the rule before applying it
- Distinguish: statute vs case law vs regulation
- Note if law is settled or unsettled in this jurisdiction
- Mark binding vs persuasive authority

### 4. Risk Assessment
- Quantify: strong / moderate / weak position
- Consider: cost of being wrong vs cost of action
- Factor: enforceability, not just legality
- Include: reputational and relationship costs

## After

- **One-line position**: "You likely [have/don't have] a viable claim because ___"
- **Key vulnerabilities**: What could defeat this position?
- **Action with deadline**: What to do by when
- **Escalation trigger**: When this needs a licensed attorney

## Traps

- **Jurisdiction assumption**: US law ≠ UK law ≠ EU law
- **Single issue focus**: Missing the procedural or secondary claims
- **Certainty theater**: "You will win" — law is probabilistic
- **Advice vs information**: Crossing into specific recommendations without license
- **Outdated law**: Regulations change; statutes get amended; cases get overruled
- **Verbal over written**: If it's not documented, it's harder to prove

## Framework: IRAC

The standard legal reasoning structure:

| Step | Question | Output |
|------|----------|--------|
| **Issue** | What's the legal question? | One sentence framing |
| **Rule** | What law applies? | Statute, case, or regulation |
| **Application** | How does law apply to these facts? | Fact-by-fact analysis |
| **Conclusion** | What's the answer? | Position + confidence level |

## Risk Matrix

| Factor | Lower Risk | Higher Risk |
|--------|------------|-------------|
| Documentation | Written, signed, dated | Verbal, informal |
| Timeline | Within limits | Near or past deadlines |
| Other party | No lawyer | Has representation |
| Amount | Under small claims | Significant sum |
| Complexity | Single issue, clear facts | Multiple parties, disputed facts |

## Output

```
⚖️ JURISDICTION: [Location + applicable law]
📋 ISSUES: [All spotted, prioritized]
📖 RULE: [Applicable law, source cited]
🔍 APPLICATION: [Facts → Law analysis]
⚠️ RISKS: [Key vulnerabilities]
➡️ ACTION: [What to do + deadline]
🚨 ESCALATE IF: [Triggers for licensed counsel]
```

---

*Channels legal thinking. Works for basic questions through complex analysis.*
