---
name: learningx-cli
description: Run and troubleshoot the lx-agent Telegram + LearningX stack through its CLI commands. Use when you need to inspect config, list courses/assignments/files/announcements, run bot/serve modes, or execute operational checks from the command line. Never guess or substitute LMS domains; validate the configured Canvas URL first and treat single-host DNS failures as inconclusive.
---

# LearningX CLI

Use this skill to operate `lx-agent` via CLI.

## Command Bridge

Run commands through the bundled bridge script:

```bash
skills/learningx-cli/scripts/run-lx-agent-cli.sh <command> [args...]
```

Set `LX_AGENT_ROOT` when running outside the repository root.

## Domain Guardrails (Important)

- Treat `canvas.url` in `config.yaml` (or `CANVAS_URL`) as source of truth unless the user explicitly changes it.
- Never replace the LMS domain with other university domains by inference.
- Do not claim a domain is invalid from one resolver or one server network.
- If DNS check fails in current environment, report it as environment-scoped and ask for the user-confirmed LMS URL before changing config.
- Keep "Learning X" as product naming and `learningx` as technical identifier.

## Required URL Verification Flow

Run this sequence before concluding URL problems:

```bash
skills/learningx-cli/scripts/run-lx-agent-cli.sh config
getent hosts <canvas-host> || nslookup <canvas-host> || dig +short <canvas-host>
curl -I --max-time 10 https://<canvas-host>
```

If these checks fail from the current runtime:
- say "cannot verify from this server/runtime"
- do not claim global NXDOMAIN unless confirmed by multiple independent resolvers
- ask user to confirm LMS URL they use in browser

## Common Commands

```bash
skills/learningx-cli/scripts/run-lx-agent-cli.sh config
skills/learningx-cli/scripts/run-lx-agent-cli.sh courses
skills/learningx-cli/scripts/run-lx-agent-cli.sh assignments
skills/learningx-cli/scripts/run-lx-agent-cli.sh files
skills/learningx-cli/scripts/run-lx-agent-cli.sh announcements
skills/learningx-cli/scripts/run-lx-agent-cli.sh bot
skills/learningx-cli/scripts/run-lx-agent-cli.sh serve
```

## Notes

- The bridge runs `go run ./cmd/lx-agent ...`.
- Keep outputs concise and include command results directly in your response.
- For bot/serve runs, surface startup errors and required env/config clearly.
- For URL issues, follow `Domain Guardrails` and never auto-substitute a different domain.
