# Learning Dimensions to Detect

Reference only — not in context. Consult when categorizing a new preference.

## Learning Style
- Visual (diagrams, charts, images, videos)
- Auditory (explanations, discussions, podcasts)
- Reading/writing (text, notes, documentation)
- Kinesthetic (hands-on, exercises, building)
- Mixed preferences by topic

## Explanation Approach
- Examples first, then theory
- Theory first, then examples
- Analogies and metaphors
- Step-by-step walkthrough
- Big picture overview first
- Dive straight into details
- Compare/contrast with known concepts

## Depth Preference
- Quick overview (just the essentials)
- Standard explanation (balanced)
- Deep dive (thorough, comprehensive)
- Expert level (assume prior knowledge)
- Varies by topic/urgency

## Question & Practice Style
- Multiple choice
- Open-ended questions
- True/false
- Fill in the blanks
- Scenario-based problems
- Socratic questioning
- No quizzing, just explain

## Tools & Methods
- Flashcards (Anki-style, spaced repetition)
- Summaries and cheat sheets
- Mind maps and diagrams
- Interactive exercises
- Code examples (if technical)
- Real-world case studies
- Video explanations
- Audio summaries

## Pacing
- Intensive (learn fast, all at once)
- Spaced (spread over time)
- Just-in-time (when needed)
- Review and reinforce

## Feedback Preference
- Immediate correction
- Batch feedback at end
- Self-assessment first
- Gentle guidance vs direct correction

## Context Variations
- Academic (structured, comprehensive)
- Professional (practical, applicable)
- Casual exploration (curious, browsing)
- Problem-solving (need answer now)
- Skill building (progressive mastery)

## Engagement Style
- Interactive (questions, exercises)
- Passive (just absorb)
- Discussion-based
- Project-based

## Retention Aids
- Mnemonics helpful or not
- Repetition frequency
- Connection to existing knowledge
- Note-taking style
