# Criteria for Learning Preferences

Reference only — consult when deciding whether to update SKILL.md.

## When to Add

**Immediate (1 occurrence):**
- User explicitly says "I learn better with X"
- User asks for different format ("can you show me a diagram?")
- User skips or dismisses a teaching approach
- User says "that clicked" or "now I get it" after specific method

**After pattern (2+ occurrences):**
- User consistently engages more with certain formats
- User asks follow-up questions after specific explanation styles
- User retains information better from certain approaches

## When NOT to Add
- Topic-specific need (complex topic needed diagram, doesn't mean always)
- Time constraint ("just give me quick answer" when busy)
- One-off request

## How to Write Entries

**Ultra-compact — learning traits as keywords:**

Style examples:
- `visual learner`
- `examples before theory`
- `needs analogies`
- `prefers reading over video`
- `hands-on, learn by doing`

Format examples:
- `bullet points over paragraphs`
- `step-by-step walkthrough`
- `show code first, explain after`
- `compare with things I know`
- `big picture then details`

Tools examples:
- `flashcards: for languages`
- `diagrams: for systems`
- `summaries: for articles`
- `no quizzes, just explain`
- `interactive exercises: for code`

Never examples:
- `no long theory blocks`
- `no abstract without concrete`
- `avoid video when text works`
- `no dumbing down`
- `skip mnemonics`

## Context Qualifiers
Different preferences for different situations:
- `technical topics: deep, detailed`
- `business concepts: quick overview`
- `new languages: spaced repetition`
- `urgent: just answer, teach later`

## Detecting Success
Watch for signals that learning worked:
- User applies concept correctly later
- User builds on explanation without confusion
- User says "got it" and moves on confidently
- Fewer clarifying questions

## Maintenance
- Keep total SKILL.md under 35 lines
- Group similar: "visual" + "diagrams" + "charts" → "visual, diagrams"
- Note what DOESN'T work in Never section
