# 每周学习回顾指南

## 执行流程

### 1. 收集本周输入

```bash
# 查看本周的 memory 日志
ls memory/2026-02-*.md | tail -7

# 查看本周新增/修改的深度笔记
find notes/areas/deep-dives/ -mtime -7 -name "*.md"
```

从每日日志中提取：
- 调研主题和关键发现
- 代码改动和 PR
- 读过的论文/文档
- 遇到的技术问题

### 2. 评估学习深度

对每个输入项，判断：
- **只是看了** → 不算学习，不更新图谱
- **理解了原理** → 可以从 🔴 升到 🟡
- **有实战经验** → 可以从 🟡 升到 🟢

### 3. 更新知识图谱

编辑 `notes/areas/ai-knowledge-map.md`：
- 更新掌握程度标记
- 在升级日志中记录变更和原因
- 添加新发现的子领域

### 4. 生成周报

文件: `notes/areas/weekly-reviews/2026-Wxx.md`

```markdown
# 2026-Wxx 学习回顾

## 本周学了什么
- [主题1]: 从 X 升到 Y，因为 [具体原因]
- [主题2]: 新接触，标记为 🔴

## 本周产出
- [PR/文章/笔记列表]

## 知识图谱变更
| 主题 | 变更 | 原因 |
|------|------|------|

## 薄弱环节
- [还需要深入的领域]

## 下周计划
- 深度研究: [选 1-2 个主题]
- 实战目标: [计划贡献的项目/PR]
```

### 5. 发送摘要

通过飞书发送给青雲，包含：
- 本周学习亮点（2-3 句）
- 知识图谱变更数量
- 下周重点方向

## 质量标准

好的周报应该能回答：
1. 这周我在 AI 领域变强了吗？哪里变强了？
2. 哪些输入转化成了真正的知识？
3. 下周应该把精力放在哪里？
