---
name: learning-engine
description: Auto-analyze mistake and success patterns and reflect in skills
author: 무펭이 🐧
---

# learning-engine

System records mistakes and successes, automatically learns patterns to improve skills. Automates "don't repeat same mistake" principle.

## Learning Sources

### 1. memory/errors/
Extract failure patterns from error logs

```markdown
# memory/errors/2026-02-14.md

## 10:30 - insta-post failure
- Cause: PNG file upload → "Problem occurred" error
- Fix: Retry after JPG conversion → Success
- Lesson: Always convert to JPG before Instagram upload
```

### 2. self-eval Results
Extract improvement points from weekly self-evaluation

```markdown
# memory/self-eval/2026-W07.md

## This Week's Mistakes
- Too many browser snapshots (token waste)
- → Improvement: Call API directly via exec

## This Week's Successes
- 95% token savings with insta-cli v2 DM check
```

### 3. performance Data
Learn successful/unsuccessful patterns from performance tracking

```json
{
  "insight": "Posts at 7-9 PM get +30% likes",
  "rule": "Instagram posts recommended 19:00-21:00"
}
```

## Auto Rule Generation

Convert learned patterns to rules:

**Location**: `memory/learned-rules/`

```
memory/
  learned-rules/
    instagram-posting.md
    browser-automation.md
    api-usage.md
    error-recovery.md
```

### Rule Format

```markdown
# Instagram Posting Rules

## Rule #1: Always Convert to JPG
- **Situation**: Upload image to Instagram
- **Failure Pattern**: PNG file → "Problem occurred"
- **Solution**: `convert input.png -quality 92 output.jpg`
- **Evidence**: 2026-02-10, 2026-02-14 error logs
- **Applied Skills**: insta-post, cardnews, social-publisher

## Rule #2: 1:1 Ratio Required
- **Situation**: Instagram card news
- **Failure Pattern**: 16:9 horizontal → Cropped in feed
- **Solution**: Generate as 1024x1024 square
- **Evidence**: 2026-02-13 feedback
- **Applied Skills**: cardnews, nano-banana-pro
```

## Inject Rules into Skills

Auto-add learned rules to relevant skill SKILL.md:

**Location**: `skills/{skill-name}/SKILL.md`

```markdown
# insta-post

...

## Learned Lessons

### Image Processing
- ✅ Always convert to JPG (PNG causes errors)
- ✅ 1:1 ratio required (1024x1024 recommended)
- ✅ File size < 8MB

### Timing
- ✅ Posts at 19:00-21:00 get +30% engagement
- ❌ Avoid early morning posts

### Automation
- ✅ Call API via exec (0 snapshots)
- ❌ Minimize browser automation
```

## Weekly Learning Report

Auto-generated every Monday:

**Location**: `memory/learning/weekly-YYYY-Www.md`

```markdown
# 2026-W07 Learning Report

## New Learnings (5)

1. **Instagram PNG Ban**
   - 3 mistakes → Rule created
   - Applied: insta-post, cardnews

2. **Token Saving: exec > Browser**
   - v1: 5 snapshots → v2: 1 exec
   - 95% savings

3. **Optimal Posting Time**
   - 19:00-21:00 +30% likes

4. **Brand Tone Effect**
   - 무펭이 tone +40% engagement

5. **Auto Error Recovery**
   - browser-dependent failure → Browser restart

## Applied Skills
- insta-post (2 rules)
- cardnews (1 rule)
- performance-tracker (1 insight)

## Next Week Goals
- [ ] Build A/B testing system
- [ ] Add 3 auto-recovery patterns
```

## Event Publishing

Publish event when learning complete:

**Location**: `events/lesson-learned-YYYY-MM-DD.json`

```json
{
  "timestamp": "2026-02-14T23:00:00Z",
  "source": "learning-engine",
  "new_rules": 2,
  "updated_skills": ["insta-post", "cardnews"],
  "summary": "Learned 2 Instagram image rules"
}
```

## hook-engine Integration

- **on-error hook**: Error occurs → Record to memory/errors/ → learning-engine analysis
- **post-hook (self-eval)**: After weekly evaluation → Update learning rules
- **post-hook (performance)**: After collecting performance data → Learn patterns
- **scheduled hook**: Every Monday → Generate weekly learning report

## Learning Pipeline

```
Error occurs
  ↓
Record to memory/errors/
  ↓
learning-engine analysis
  ↓
Extract patterns + Create rules
  ↓
Save to memory/learned-rules/
  ↓
Auto-update relevant skill SKILL.md
  ↓
Publish event (lesson-learned)
  ↓
Reflect in weekly report
```

## Trigger Keywords

- "what did I learn"
- "learning"
- "lessons"
- "mistake patterns"
- "improvements"
- "learning report"
- "add rule"

## Usage Examples

```
"What did I learn this week?"
→ Generate weekly learning report

"Organize Instagram posting mistake patterns"
→ Analyze memory/errors/ + Create rules

"Learn from performance data"
→ Extract successful patterns + Update rules
```

## Auto-improvement Examples

### Before (Pre-learning)
```
Instagram post fails → Manually convert to JPG → Retry
(Repeat every time)
```

### After (Post-learning)
```
Execute insta-post → Auto-check/convert JPG → Success
(Rule injected into SKILL.md)
```

## Meta Learning

learning-engine itself also learns:

- "Which rules are used most?"
- "Which skills improve most?"
- "Which areas have slow learning?"

**Meta Learning Report**: `memory/learning/meta-YYYY-MM.md`

## Future Improvements

- [ ] Rule conflict detection (Rule A vs Rule B)
- [ ] Rule confidence score (based on usage frequency)
- [ ] Auto A/B testing (rule validation)
- [ ] Share learning with other agents

---

> 🐧 Built by **무펭이** — [Mupengism](https://github.com/mupeng) ecosystem skill
