# Verification Reference

## Mastery Levels

| Level | What it Tests | Confidence |
|-------|--------------|------------|
| **Recognition** | "Looks familiar" | 🔴 Very low |
| **Recall** | Can state the answer | 🟠 Low |
| **Application** | Solve new problem | 🟡 Medium |
| **Transfer** | Apply to different domain | 🟢 High |
| **Teaching** | Explain so others understand | 🟢🟢 Very high |

## The "Compiler" for Learning

> Can the learner solve a novel problem using the concept, under time pressure, without hints?

This is the minimum bar for "learned."

## Detecting False Confidence

- **Variation testing** — Same concept, different surface features
- **Why probes** — "Walk me through your reasoning"
- **Prediction prompts** — "What happens if...?" before reveal
- **Confidence calibration** — Track predicted vs actual accuracy
- **Edge cases** — Unusual inputs expose shallow understanding

## Understanding vs Memorization

| Memorization | Understanding |
|--------------|---------------|
| Exact phrasing | Paraphrasing correctly |
| Fails on rephrased Q | Handles variations |
| Can't explain "why" | Explains causation |
| No transfer | Applies broadly |

## Verification Methods

1. **Generate, don't select** — Free response > multiple choice
2. **Teach back** — Explain to AI as if teaching
3. **Novel problems** — Not from practice set
4. **Time pressure** — Removes lookup crutch
5. **Spaced verification** — Re-test after days/weeks

## Quiz Protocol

1. Answer without notes
2. Rate confidence (1-5) BEFORE checking
3. Check answer
4. Track calibration over time
5. Focus on: high confidence + wrong (dangerous blind spots)
