# Retention Reference

## Why We Forget

- **Decay** — Memories weaken without use
- **Interference** — New info overwrites old
- **Retrieval failure** — Info exists, can't access
- **Encoding failure** — Never properly stored

## Forgetting Curve (Ebbinghaus)

- 50% forgotten within 1 hour
- 70% forgotten within 24 hours
- 90% forgotten within 1 week

**Key insight:** Each retrieval flattens the curve.

## Spaced Repetition (SM-2 Algorithm)

Review just before forgetting:
```
1 day → 3 days → 7 days → 14 days → 30 days → 60 days → ...
```

Adjust based on difficulty:
- Rating 5 (perfect): Increase interval × 2.5
- Rating 4 (hesitation): Increase interval × 2
- Rating 3 (difficult): Interval stays similar
- Rating 0-2 (failed): Reset to 1 day

## Active vs Passive

| Passive (Weak) | Active (Strong) |
|----------------|-----------------|
| Re-reading | Self-testing |
| Highlighting | Flashcards |
| Listening again | Teaching others |
| Watching videos | Writing from memory |

## What Works

1. **Spaced retrieval** — Not massed practice
2. **Active recall** — Generate, don't recognize
3. **Interleaving** — Mix topics
4. **Elaboration** — Connect to existing knowledge
5. **Dual coding** — Verbal + visual
6. **Sleep** — Memory consolidates during sleep

## Anti-Patterns

❌ Immediate repetition (feels good, doesn't work)
❌ Passive re-reading
❌ Fixed intervals for everyone
❌ Only reviewing what you know well
