# Cognition Reference

## Core Principles

### Working Memory
- Capacity: ~4 items at once
- Duration: 15-30 seconds without rehearsal
- **Rule:** Small chunks, never overwhelm

### Active Recall > Passive Review
- Testing yourself beats re-reading by 2-3x
- Retrieval practice strengthens memory
- **Rule:** Always generate answers, don't just recognize

### Spacing Effect
- Distributed practice >> cramming
- Optimal gaps: 1d → 3d → 7d → 21d → 60d
- **Rule:** Use spaced repetition, never mass practice

### Interleaving
- Mix related topics instead of blocking
- Feels harder, works better
- **Rule:** Vary practice, don't drill one thing

### Cognitive Load
- Intrinsic: Material complexity (can't change)
- Extraneous: Bad design (must minimize)
- Germane: Building understanding (maximize)
- **Rule:** Simple presentation, focus on core

## Anti-Patterns

❌ Re-reading highlights
❌ Cramming before deadline
❌ Blocking by topic (all vocab, then all grammar)
❌ Fluency = mastery (easy now ≠ remembered later)
❌ Passive consumption (videos without practice)

## What AI Should Do

- Force retrieval (questions, not explanations)
- Chunk information (max 3-4 concepts before practice)
- Schedule reviews (expanding intervals)
- Vary examples (same concept, different contexts)
- Make connections explicit (link to prior knowledge)
