---
name: Learn
slug: learn
version: 1.0.2
description: Structure and track learning with spaced repetition and active recall across any domain.
changelog: Fixed data folder to match slug, removed vague cron reference
metadata: {"clawdbot":{"emoji":"🎓","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## Data Storage

```
~/learn/
├── topics/              # One folder per topic
│   └── {topic}/
│       ├── concepts.json   # Concepts with SR schedule
│       ├── notes.md        # Study notes
│       └── progress.md     # Mastery tracking
├── reviews/             # Due review queue
│   └── due.json
└── config.json          # Preferences
```

Create on first use: `mkdir -p ~/learn/{topics,reviews}`

## Scope

This skill:
- ✅ Creates learning plans in ~/learn/
- ✅ Tracks concepts with spaced repetition
- ✅ Generates quizzes for active recall
- ✅ Reminds user when reviews are due (stores schedule in ~/learn/reviews/)
- ❌ NEVER accesses external learning platforms without permission
- ❌ NEVER stores data outside ~/learn/

## Quick Reference

| Topic | File |
|-------|------|
| Cognitive principles | `cognition.md` |
| Spaced repetition math | `retention.md` |
| Verification methods | `verification.md` |

## Core Rules

### 1. Workflow
```
Goal → Plan → Study → Practice → Verify → Review
```

### 2. Active Recall Only
NEVER passive review. Always:
- Ask question first, user answers
- Then show correct answer
- User rates: easy / good / hard / wrong

### 3. Starting a Topic
1. User states what they want to learn
2. Create ~/learn/topics/{topic}/
3. Break down into concepts
4. Add to spaced repetition queue

### 4. Spaced Repetition
In concepts.json:
```json
{
  "concept_name": {
    "added": "2024-03-15",
    "interval_days": 1,
    "next_review": "2024-03-16",
    "ease_factor": 2.5,
    "reviews": 0
  }
}
```

After each review:
- Correct → increase interval (×ease_factor)
- Incorrect → reset to 1 day

### 5. Verification
Before marking "mastered":
- Generate 5 questions covering concept
- User must answer 4/5 correctly
- Track in progress.md (topic folder)

### 6. Configuration
In ~/learn/config.json:
```json
{
  "depth": "standard",
  "learner_type": "practical",
  "daily_review_limit": 20
}
```
