# Lead Magnets — Free-to-Paid Conversion Framework

Design lead magnets that attract qualified prospects and convert them to paying customers.
Sources: Hormozi ($100M Leads), Funnelytics, BusySeed (500+ clients), LeadsPicker research.
All outputs go to `workspace/artifacts/`.

## Use when
- Creating a free resource to capture emails/leads
- Designing a free-to-paid conversion funnel
- Choosing what to give away vs. what to charge for
- Building opt-in pages or gated content
- Planning content marketing that drives revenue (not just traffic)

## Don't use when
- Building paid products directly (use pricing-psychology skill instead)
- Writing cold outreach (use cold-outreach skill)
- Creating brand awareness content with no conversion goal
- SEO content that shouldn't be gated

## Negative examples
- "Write me a blog post" → No. Blog posts aren't gated lead magnets unless part of a funnel.
- "Help me price my service" → No. That's pricing-psychology.
- "Create a social media post" → No. That's content marketing, not lead capture.

## Edge cases
- Free skill on ClawHub → YES. It's a lead magnet for premium bundles/consulting.
- Free trial of SaaS → YES. Trials are lead magnets with built-in conversion mechanics.
- Webinar → YES. Live events are high-converting lead magnets (avg 20-40% attendance, 2-5% conversion to paid).
- Newsletter → Borderline. Only if each issue delivers standalone value. Generic newsletters are not lead magnets.

---

## Hormozi's Lead Magnet Principle

From $100M Leads: A lead magnet solves a **specific, narrow problem** for free, so well that the prospect thinks: *"If the free stuff is this good, the paid stuff must be incredible."*

### The Critical Rule
Your lead magnet must solve ONE step of a multi-step problem. It provides a quick win but reveals a bigger need that your paid offer addresses.

**Example chain:**
- Lead magnet: "5 SMS Templates That Book Massage Clients" (free, immediately useful)
- Reveals: "But I still need to automate sending these..." (the gap)
- Paid offer: Full SMS automation service at $149/mo (fills the gap)

### What Makes a Lead Magnet Convert

**3 Core Principles (Funnelytics):**

1. **Immediate Value** — Must deliver a result they can use NOW. No 30-page PDFs that feel like homework. Quick wins build trust fast.

2. **Trust Signals** — Include proof: "Used by 500+ agents," testimonials, your real name/photo, specific results. People hesitate without proof.

3. **Relevance to Their Current Pain** — Match what they're struggling with RIGHT NOW, not what they might need someday. Specificity converts; generality doesn't.

---

## The 7 Lead Magnet Types (Ranked by 2025-26 Effectiveness)

### 1. Templates & Plug-and-Play Tools ⭐⭐⭐⭐⭐
**Why they work:** Zero effort required. Download → use → get result.
**Conversion rate:** Highest among all types.
**Examples:**
- Funnel templates, email templates, spreadsheet calculators
- Config files, code snippets, workflow recipes
- "Agent Starter Kit" for OpenClaw (our play)

**For us:** Free OpenClaw AGENTS.md + SOUL.md template → leads to premium Agent Family Kit.

### 2. Interactive Quizzes / Assessments ⭐⭐⭐⭐⭐
**Why they work:** Personalized results + instant gratification. Users invest time answering = higher commitment.
**Conversion rate:** BusySeed client saw 68% increase in opt-ins replacing static PDF with quiz.
**Examples:**
- "Which AI automation fits your business?"
- "Rate your agent's security posture"
- "What's your outreach style?"

**For us:** "Is your OpenClaw agent secure?" quiz → leads to prompt-guard + ops-hygiene skills.

### 3. ROI / Cost Calculators ⭐⭐⭐⭐
**Why they work:** Quantifies the value of your solution in their specific numbers.
**Conversion rate:** One company attributed 45% of total revenue to a single calculator (BusySeed/Palisade Fence case study).
**Examples:**
- "How much are missed calls costing your business?"
- "Calculate your AI automation ROI"

**For us:** "Missed call cost calculator" for massage/service businesses → leads to Alfred-style automation.

### 4. "What NOT To Do" Lists ⭐⭐⭐⭐
**Why they work:** Pattern interrupt. Most content says what TO do. Mistake lists create urgency ("Am I making these?").
**Conversion rate:** High open rates + shares because they trigger loss aversion.
**Examples:**
- "7 Mistakes Killing Your OpenClaw Agent's Performance"
- "5 Cold Email Errors That Get You Blacklisted"

### 5. Mini-Courses / Email Sequences ⭐⭐⭐
**Why they work:** Drip value over days, building relationship. Each email is a touchpoint.
**Conversion rate:** Lower initial opt-in, but higher eventual purchase rate.
**Examples:**
- "5-Day Agent Masterclass" (one lesson per email)
- "Build Your First n8n Automation in 3 Days"

### 6. Checklists & Cheat Sheets ⭐⭐⭐
**Why they work:** Simple, actionable, easy to consume.
**Conversion rate:** Good for top-of-funnel, but lower conversion to paid unless the checklist reveals gaps.
**Examples:**
- "OpenClaw Security Hardening Checklist"
- "Pre-Launch Automation Checklist"

### 7. Webinars / Live Demos ⭐⭐⭐
**Why they work:** Highest trust-building format. Real-time Q&A. Personality sells.
**Conversion rate:** 20-40% attendance rate, 2-5% conversion to paid (LeadsPicker).
**Note:** Requires scheduling, live presence, and recording infrastructure.

---

## Lead Magnet Design Checklist

Before publishing any lead magnet, verify:

- [ ] **Solves ONE specific problem** (not "everything about X")
- [ ] **Delivers value in under 5 minutes** (or first email)
- [ ] **Has a clear next step** → your paid offer
- [ ] **Title is benefit-driven** ("Get X" not "Learn about X")
- [ ] **Trust signal present** (testimonial, number of users, case study)
- [ ] **Matches audience's awareness level:**
  - Unaware → "What NOT to do" list (educate on the problem)
  - Problem-aware → Template/calculator (solve it partially)
  - Solution-aware → Demo/case study (prove your solution works)
- [ ] **Opt-in friction is minimal** (name + email only, no 10-field forms)
- [ ] **Mobile-friendly** (50%+ of opt-ins happen on mobile)
- [ ] **Thank-you page sells the next step** (don't waste this page)

---

## Free → Paid Conversion Architecture

```
LEAD MAGNET (free, specific, immediate value)
    ↓
OPT-IN (email captured)
    ↓
DELIVERY + QUICK WIN (they use it, get result)
    ↓
NURTURE SEQUENCE (3-5 emails, more value, build trust)
    ↓
BRIDGE (reveal the bigger problem your paid offer solves)
    ↓
OFFER (paid product/service, positioned as obvious next step)
```

**Key insight:** The lead magnet ISN'T the sale. It's the first date. The nurture sequence builds the relationship. The offer is the proposal. Don't propose on the first date.

---

## Our Lead Magnet Playbook

| Product | Lead Magnet | Format | → Paid Offer |
|---------|-------------|--------|-------------|
| ClawHub skills | Free "Agent Security Checklist" | Checklist PDF | Premium skill bundle ($29) |
| The Reef | Free tier-config template | Config file | Full Reef kit ($29) |
| Alfred automation | "Missed Call Cost Calculator" | Interactive | $149/mo service |
| Upwork consulting | "5 n8n Workflows You Can Build Today" | Email course | $500+ project |
| Agent Family Kit | Free SOUL.md template | Template | Premium kit ($49) |

---

## Key Numbers
- 41% of marketers say lead generation is their #1 challenge (2025)
- Interactive content (quizzes, calculators) generally converts better than static — Demand Metric found ~2x more leads; actual multiplier varies by implementation
- BusySeed claims one calculator drove 45% of revenue for a service client — plausible as an outlier, not a typical result. Calculators are high-intent but this figure should not be treated as a benchmark.
- Quiz replacement of static PDF → 68% increase in opt-ins (single case study — directionally right but not universally generalizable)
- Webinars: 20-40% attendance, 2-5% conversion to paid
- Optimal form fields: 2-3 (name + email). Additional fields reduce conversion — estimates range from 4% (Unbounce) to 10%+ (industry rule of thumb). HubSpot found >4 fields can cut conversions up to 50%.
- Thank-you page is the highest-intent page on your site — use it to sell
