# Lead Scoring

> Hot, warm, or waste of time. Score every lead automatically.

## Scoring Formula

```yaml
# scoring.yaml
total_score: 100 points max

categories:
  icp_fit: 40 points
    - title_match: 15
    - company_size_match: 10
    - industry_match: 10
    - location_match: 5
    
  enrichment_quality: 25 points
    - verified_email: 15
    - phone_found: 5
    - linkedin_found: 5
    
  intent_signals: 25 points
    - recent_funding: 10
    - hiring_signal: 5
    - tech_stack_match: 5
    - engagement_signal: 5
    
  timing: 10 points
    - raised_last_90d: 5
    - posted_last_7d: 3
    - active_on_platform: 2

thresholds:
  hot: 75+      # Reach out TODAY
  warm: 50-74   # Queue for outreach
  cold: 25-49   # Nurture list
  trash: <25    # Discard
```

## Auto-Prioritization

```yaml
# priority-queue.yaml
sort_by:
  1. score DESC
  2. intent_recency DESC
  3. enrichment_completeness DESC
  
daily_output:
  hot_leads: top 20
  warm_leads: next 50
  
actions:
  hot: trigger_immediate_outreach
  warm: add_to_sequence
  cold: add_to_nurture
```
