# Output & Integrations

## Export Formats

```yaml
# CSV (Universal)
fields:
  - first_name
  - last_name
  - email
  - email_confidence
  - phone
  - company
  - title
  - linkedin
  - twitter
  - company_size
  - funding
  - tech_stack
  - score
  - signals

# JSON (API/Automation)
# Same fields, nested structure

# Direct CRM Push
supported:
  - hubspot
  - pipedrive
  - salesforce
  - close
  - apollo
```

## CRM Integration

```yaml
# hubspot.yaml
api_key: ${HUBSPOT_KEY}
on_new_lead:
  action: create_contact
  mapping:
    email: email
    firstname: first_name
    lastname: last_name
    company: company
    jobtitle: title
    phone: phone
    lead_score: score
  list: "lead-hunter-imports"
  
# pipedrive.yaml  
api_key: ${PIPEDRIVE_KEY}
on_new_lead:
  action: create_person
  create_org: true
  add_to_pipeline: "New Leads"
```

## Webhook Output

```yaml
# webhook.yaml
on_hot_lead:
  url: ${WEBHOOK_URL}
  method: POST
  payload:
    lead: full_lead_object
    score: score
    signals: detected_signals
  
# Integrate with:
# - Slack alerts
# - Email notifications  
# - Auto-outreach triggers
# - Zapier/Make
```
