# Discovery Sources

> Where to find your leads. Multi-source = higher coverage, better data.

---

## Source Overview

| Source | Lead Quality | Volume | Cost | Setup Difficulty |
|--------|--------------|--------|------|------------------|
| X/Twitter | High | High | Free/API | Easy |
| GitHub | High (devs) | Medium | Free | Easy |
| Product Hunt | Very High | Low | Free | Easy |
| Moltbook | High (AI niche) | Medium | Free | Easy |
| LinkedIn | High | Very High | Risky | Hard |
| Crunchbase | Very High | Medium | Paid | Medium |
| Custom RSS | Varies | Varies | Free | Medium |

---

## X/Twitter Discovery

Best for: Founders, creators, thought leaders, tech people

```yaml
# sources/twitter.yaml
enabled: true
api_version: v2
credentials:
  bearer_token: ${TWITTER_BEARER_TOKEN}
  
discovery_methods:
  # Method 1: Keyword search
  keyword_search:
    queries:
      - "just launched" startup
      - "we're hiring" founder
      - "raised our seed"
      - "building in public"
      - "looking for" automation
    filters:
      min_followers: 500
      max_followers: 100000      # Skip celebrities
      verified_only: false
      has_website: true
      account_age_days: 180
      
  # Method 2: Competitor followers
  competitor_followers:
    accounts:
      - zapier
      - make_hq
      - n8aborhood
    sample_size: 1000
    filter_by_bio:
      must_contain: ["founder", "ceo", "building"]
      
  # Method 3: List members
  list_members:
    lists:
      - "startup-founders"
      - "saas-builders"
    owner_accounts:
      - "@relevantcurator"
      
  # Method 4: Engagement signals
  engagement_mining:
    monitor_tweets_from:
      - "@ycombinator"
      - "@a]"
      - "@naval"
    capture:
      - repliers
      - quoters
      - retweeters
    min_engagement_score: 50
    
rate_limits:
  requests_per_15min: 450
  delay_between_requests: 2s
  
output:
  fields:
    - handle
    - name
    - bio
    - location
    - website
    - followers
    - following
    - tweet_count
    - created_at
    - verified
    - profile_image
```

### Twitter Search Operators

```yaml
# Power search templates
search_templates:
  recently_funded:
    query: '("just raised" OR "announced funding" OR "seed round") (founder OR ceo) -"rt"'
    
  hiring_signal:
    query: '("we\'re hiring" OR "join our team" OR "looking for") (startup OR founder) min_faves:10'
    
  product_launch:
    query: '("just launched" OR "launching today" OR "now live") (founder OR built) min_faves:20'
    
  pain_point:
    query: '("anyone know" OR "looking for" OR "need help with") (automation OR tool OR software)'
    
  building_public:
    query: '"building in public" (founder OR maker OR creator) min_followers:500'
```

---

## GitHub Discovery

Best for: Developers, technical founders, open source maintainers

```yaml
# sources/github.yaml
enabled: true
credentials:
  token: ${GITHUB_TOKEN}
  
discovery_methods:
  # Method 1: Trending repos
  trending_repos:
    languages:
      - python
      - typescript
      - rust
    time_range: weekly
    capture: repo_owners
    min_stars: 100
    
  # Method 2: Topic search
  topic_search:
    topics:
      - ai-agents
      - automation
      - saas
      - developer-tools
    capture: 
      - repo_owners
      - top_contributors
    min_stars: 50
    
  # Method 3: Organization members
  org_members:
    organizations:
      - vercel
      - supabase
      - planetscale
    role_filter: 
      - owner
      - member
    public_only: true
    
  # Method 4: Sponsorable users
  sponsorable_search:
    filters:
      - has_sponsors: true
      - min_sponsors: 10
    indicates: monetized_developer
    
rate_limits:
  requests_per_hour: 5000
  
output:
  fields:
    - username
    - name
    - email              # Often public
    - bio
    - company
    - location
    - website
    - twitter_handle
    - followers
    - public_repos
    - created_at
```

---

## Product Hunt Discovery

Best for: Startup founders, product people, makers

```yaml
# sources/producthunt.yaml
enabled: true
method: scraping          # No official API for this use
  
discovery_methods:
  # Method 1: New launches
  daily_launches:
    categories:
      - saas
      - developer-tools
      - productivity
      - artificial-intelligence
    min_upvotes: 50
    capture: makers
    
  # Method 2: Top products
  top_products:
    time_range: monthly
    min_upvotes: 200
    capture:
      - makers
      - hunters
      
  # Method 3: Collection members
  collection_scrape:
    collections:
      - "ai-tools"
      - "startup-tools"
    capture: makers

rate_limits:
  requests_per_minute: 10
  delay_between_pages: 5s
  
output:
  fields:
    - name
    - headline
    - product_name
    - product_url
    - twitter_handle
    - website
    - upvotes
    - launch_date
```

---

## Moltbook Discovery

Best for: AI/agent ecosystem, crypto-adjacent, bleeding edge

```yaml
# sources/moltbook.yaml
enabled: true
credentials:
  api_key: ${MOLTBOOK_API_KEY}
  
discovery_methods:
  # Method 1: Active posters
  active_agents:
    min_posts: 10
    min_engagement: 100
    topics:
      - business
      - automation
      - trading
    capture: agent_owners      # Get the human behind the agent
    
  # Method 2: Bounty posters
  bounty_posters:
    min_bounty_value: 50
    categories:
      - research
      - development
    indicates: has_budget
    
  # Method 3: Premium subscribers
  premium_users:
    indicates: paying_customer
    
output:
  fields:
    - agent_name
    - owner_handle
    - owner_twitter
    - owner_email
    - activity_score
    - bounties_posted
    - bounties_spent
```

---

## LinkedIn Discovery

⚠️ **HIGH RISK** — LinkedIn actively blocks scraping. Use carefully.

```yaml
# sources/linkedin.yaml
enabled: false            # Disabled by default
method: proxy_service     # Never direct scraping

# RECOMMENDED: Use a service
proxy_services:
  - phantombuster        # Paid, safer
  - linkedhelper         # Paid
  - apollo_io            # Has LinkedIn data

# If manual (risky):
manual_method:
  use_sales_navigator: true
  export_searches: true
  never_automate_connection_requests: true
  
# Search queries for Sales Navigator
search_templates:
  startup_founders:
    title: (Founder OR "Co-Founder" OR CEO)
    company_size: 1-50
    funding: (Seed OR "Series A")
    
  growth_leaders:
    title: ("Head of Growth" OR "VP Growth" OR "Growth Lead")
    company_size: 11-200
    
rate_limits:
  profiles_per_day: 100   # Stay under radar
  delay_between: 30s
  
warnings:
  - "LinkedIn will ban you if detected"
  - "Use residential proxies only"
  - "Never automate actions"
  - "Prefer Apollo/Clearbit for LinkedIn data"
```

---

## Crunchbase Discovery

Best for: Funded startups, verified company data

```yaml
# sources/crunchbase.yaml
enabled: true
credentials:
  api_key: ${CRUNCHBASE_API_KEY}
tier: basic               # basic | pro | enterprise

discovery_methods:
  # Method 1: Recent funding
  recent_funding:
    funding_type:
      - seed
      - series_a
      - series_b
    date_range: 90d
    amount:
      min: 500000
      max: 20000000
    location: 
      - United States
      - United Kingdom
      
  # Method 2: Company search
  company_search:
    categories:
      - artificial-intelligence
      - saas
      - automation
    founded_after: 2020
    employee_count:
      min: 5
      max: 100
      
output:
  company_fields:
    - name
    - description
    - website
    - linkedin_url
    - twitter_url
    - employee_count
    - funding_total
    - last_funding_date
    - investors
    
  people_fields:
    - name
    - title
    - linkedin
    - email_pattern     # For guessing
```

---

## Custom RSS/Webhook Sources

For niche industries or custom signals:

```yaml
# sources/custom.yaml
rss_feeds:
  - name: "TechCrunch Startups"
    url: "https://techcrunch.com/startups/feed/"
    extract:
      - company_mentions
      - founder_names
      
  - name: "Hacker News"
    url: "https://hnrss.org/newest?q=Show+HN"
    extract:
      - submitter_profile
      - project_url
      
webhooks:
  - name: "New Shopify Apps"
    url: "your-monitoring-service"
    trigger: new_app_published
    extract:
      - developer_info
      
google_alerts:
  - query: "raised seed round"
    frequency: daily
  - query: "just launched" saas
    frequency: daily
```

---

## Multi-Source Orchestration

Run all sources together:

```yaml
# discovery-orchestrator.yaml
sources:
  - twitter:
      weight: 0.3
      run_every: 4h
  - github:
      weight: 0.2
      run_every: 12h
  - producthunt:
      weight: 0.2
      run_every: 24h
  - moltbook:
      weight: 0.2
      run_every: 6h
  - crunchbase:
      weight: 0.1
      run_every: 24h
      
deduplication:
  enabled: true
  match_on:
    - email
    - twitter_handle
    - company_domain
    
merge_strategy:
  - prefer_source: crunchbase    # Most reliable company data
  - prefer_recent: true
  
output:
  combined_file: /output/all-leads.json
  per_source_files: true
```

---

→ Continue to `/enrichment/email-discovery.md`
