# ICP Configuration

> Define who you're hunting. The tighter your ICP, the better your leads.

## Template

```yaml
# icp.yaml
name: "tech-startup-founder"
description: "Early-stage tech startup founders who need automation"

# ═══════════════════════════════════════════════════════════════
# FIRMOGRAPHICS (Company-level)
# ═══════════════════════════════════════════════════════════════

company:
  # Industry targeting
  industries:
    include:
      - saas
      - fintech
      - ai/ml
      - developer-tools
      - automation
    exclude:
      - gambling
      - adult
      - tobacco
      
  # Company stage
  stage:
    include:
      - seed
      - series-a
      - series-b
    exclude:
      - enterprise
      - public
      
  # Employee count
  employee_range:
    min: 5
    max: 100
    
  # Funding
  funding:
    min: 500000          # $500k minimum
    max: 20000000        # $20M maximum
    recent_round_within: 18m   # Raised in last 18 months
    
  # Geography
  location:
    countries:
      - US
      - UK
      - Canada
      - Germany
    regions:
      - North America
      - Western Europe
    exclude_countries:
      - sanctioned_list
      
  # Tech stack signals
  tech_stack:
    must_have:
      - stripe           # Monetizing
      - intercom         # Customer-focused
    good_to_have:
      - segment
      - mixpanel
      - zapier          # Already automating
    red_flags:
      - salesforce      # Too enterprise
      
# ═══════════════════════════════════════════════════════════════
# DEMOGRAPHICS (Person-level)
# ═══════════════════════════════════════════════════════════════

person:
  # Titles
  titles:
    include:
      - founder
      - co-founder
      - ceo
      - cto
      - head of growth
      - head of ops
    exclude:
      - intern
      - assistant
      - coordinator
      
  # Seniority
  seniority:
    include:
      - c-level
      - vp
      - director
      - founder
      
  # Department
  department:
    include:
      - executive
      - operations
      - engineering
      - growth
      
# ═══════════════════════════════════════════════════════════════
# INTENT SIGNALS (Behavioral)
# ═══════════════════════════════════════════════════════════════

intent_signals:
  # Activity that suggests they need what you sell
  strong_signals:
    - posted_about: ["automation", "ai agents", "productivity"]
    - hired_for: ["operations", "automation"]
    - tech_added: ["zapier", "make", "n8n"]
    - searched_for: ["ai assistant", "virtual assistant"]
    - visited: ["competitor websites"]
    
  medium_signals:
    - posted_about: ["scaling", "growth", "efficiency"]
    - engaged_with: ["automation content"]
    - attended: ["saas conferences", "automation webinars"]
    
  timing_signals:
    - just_raised: 90d           # Raised in last 90 days
    - just_hired: ["ops", "growth"]
    - rapid_growth: 50           # 50%+ headcount growth
    - launched_product: 60d
    
# ═══════════════════════════════════════════════════════════════
# SCORING WEIGHTS
# ═══════════════════════════════════════════════════════════════

scoring:
  weights:
    industry_match: 20
    stage_match: 15
    title_match: 20
    tech_stack_match: 15
    intent_signals: 25
    timing: 5
    
  thresholds:
    hot: 80              # Score >= 80 = hot lead
    warm: 60             # Score 60-79 = warm lead
    cold: 40             # Score 40-59 = cold lead
    discard: 40          # Score < 40 = don't bother
```

---

## ICP Examples

### SaaS Founder (B2B)

```yaml
name: "saas-founder"
company:
  industries: [saas, b2b-software]
  employee_range: {min: 10, max: 200}
  funding: {min: 1000000, max: 50000000}
person:
  titles: [founder, ceo, coo]
intent_signals:
  strong_signals:
    - posted_about: ["scaling", "series a", "hiring"]
```

### E-commerce Brand Owner

```yaml
name: "ecom-brand"
company:
  industries: [ecommerce, dtc, cpg]
  employee_range: {min: 3, max: 50}
  tech_stack:
    must_have: [shopify]
person:
  titles: [founder, owner, ceo]
intent_signals:
  strong_signals:
    - posted_about: ["meta ads", "cac", "aov", "scaling"]
```

### Crypto/Web3 Builder

```yaml
name: "crypto-builder"
company:
  industries: [crypto, defi, web3, nft]
  stage: [seed, series-a]
person:
  titles: [founder, cto, lead developer]
intent_signals:
  strong_signals:
    - posted_about: ["ai agents", "automation", "defi"]
    - active_on: [moltbook, farcaster]
```

### Agency Owner

```yaml
name: "agency-owner"
company:
  industries: [marketing-agency, dev-agency, design-agency]
  employee_range: {min: 5, max: 50}
person:
  titles: [founder, owner, managing director]
intent_signals:
  strong_signals:
    - posted_about: ["client management", "scaling agency", "automation"]
```

---

## Anti-ICP (Who to Avoid)

Define who you DON'T want:

```yaml
# anti-icp.yaml
exclude:
  companies:
    - fortune_500
    - government
    - education
    - non_profit
    
  signals:
    - layoffs_recent: true
    - funding_negative: true     # Down round
    - bad_glassdoor: 2.5         # Below 2.5 rating
    
  behaviors:
    - unsubscribed_before: true
    - marked_spam: true
    - bounced_email: true
    - competitor_employee: true
```

---

## Dynamic ICP Adjustment

Your ICP should evolve based on what converts:

```yaml
# icp-learning.yaml
track_conversions:
  - replied_to_outreach
  - booked_meeting
  - became_customer
  
adjust_weights:
  frequency: weekly
  method: regression
  min_data_points: 50
  
auto_adjustments:
  - if conversion_rate_by_industry.fintech > 0.15:
      increase_weight: industry.fintech
  - if conversion_rate_by_title.cto > conversion_rate_by_title.ceo:
      increase_weight: titles.cto
```

---

## Multiple ICPs

Run different hunts for different profiles:

```bash
# Hunt for SaaS founders
lead-hunter discover --icp saas-founder --output saas-leads.json

# Hunt for agency owners
lead-hunter discover --icp agency-owner --output agency-leads.json

# Hunt for crypto builders
lead-hunter discover --icp crypto-builder --output crypto-leads.json
```

---

→ Continue to `/discovery/sources.md`
