---
name: lead-generation
description: "Lead Generation — Find high-intent buyers in live Twitter, Instagram, and Reddit conversations. Auto-researches your product, generates targeted search queries, and discovers people actively looking for solutions you offer. Social selling and prospecting powered by 1.5B+ indexed posts via Xpoz MCP."
homepage: https://xpoz.ai
metadata:
  {
    "openclaw":
      {
        "requires": {
          "bins": ["mcporter"],
          "skills": ["xpoz-setup"],
          "network": ["mcp.xpoz.ai"],
          "credentials": "Xpoz account (free tier) — auth via xpoz-setup skill (OAuth 2.1)"
        },
        "install": [{"id": "node", "kind": "node", "package": "mcporter", "bins": ["mcporter"], "label": "Install mcporter (npm)"}],
      },
  }
tags:
  - lead-generation
  - sales
  - prospecting
  - social-media
  - twitter
  - instagram
  - reddit
  - find-leads
  - social-selling
  - buyer-intent
  - outreach
  - growth
  - marketing
  - customer-discovery
  - leads
  - mcp
  - xpoz
  - intent
  - discovery
---

# Lead Generation

**Find high-intent buyers from live social conversations.**

Discovers leads expressing problems your product solves, complaining about competitors, or actively seeking solutions across Twitter, Instagram, and Reddit.

## Setup

Run `xpoz-setup` skill. Verify: `mcporter call xpoz.checkAccessKeyStatus`

## 3-Phase Process

### Phase 1: Product Research (One-Time)

Ask for product reference (website/GitHub/description). Use `web_fetch`/`web_search` to research. Build profile: product info, target audience, pain points, competitors, keywords. **Validate with user.**

Generate 12-18 queries across:
1. Pain point queries — people expressing problems
2. Competitor frustration — complaints about alternatives
3. Tool/solution seeking — "recommend..."
4. Industry discussion — target audience

Save to `data/lead-generation/product-profile.json` and `search-queries.json`.

### Phase 2: Lead Discovery (Repeatable)

```bash
mcporter call xpoz.getTwitterPostsByKeywords query="GENERATED_QUERY" startDate="DATE"
mcporter call xpoz.checkOperationStatus operationId="op_..." # Poll every 5s
mcporter call xpoz.getTwitterUsersByKeywords query="..." # Find people
```

Repeat for Instagram/Reddit.

### Phase 3: Scoring & Output

**Score (1-10):**
- Explicitly asking for solution: +3
- Complaining about competitor: +2
- Project blocked by pain: +2
- Active in target community: +1
- High engagement (>10 likes/5 comments): +1
- Recent (<48h): +1
- Profile matches ICP: +1
- Selling competing solution: -3

**Tiers:** 8-10 Hot, 6-7 Warm, 5 Watchlist

Deduplicate via `data/lead-generation/sent-leads.json` (key: `{platform}:{author}:{post_id}`).

**Output:** Username, quote, URL, score, why fit, outreach draft, engagement, timestamp.

**Outreach:**
> "I had the same problem! Ended up using [Product] — it does [capability]. [URL]  
> (Disclosure: I work with [Product])"

## Tips

- Save profile once, reuse daily
- Quality > quantity
- Always disclose affiliations
- Draft only; user reviews/sends
