# SEO Checklist for Lead Generation Websites

## Meta Tags (Every Page)
- Unique `<title>` tag (50-60 characters, include target keyword)
- Unique meta description (150-160 characters, compelling CTA)
- Canonical URL to avoid duplicate content
- Open Graph tags (og:title, og:description, og:url, og:type, og:image)
- Twitter Card tags (twitter:card, twitter:title, twitter:description, twitter:image)

## Structured Data (Schema.org JSON-LD)
- **LocalBusiness** on homepage: name, telephone, email, address, areaServed, openingHours
- **Service** on service pages: name, description, provider, areaServed
- **BreadcrumbList** on all pages for navigation
- **FAQPage** on FAQ page with questions and answers
- **Article** on blog posts with headline, author, datePublished

## Technical SEO
- **robots.txt** at root: Allow all, reference sitemap
- **sitemap.xml** at root: All pages with priorities (1.0 for homepage, 0.9 for main services, 0.7 for utilities, 0.3 for legal)
- Mobile-responsive design (mobile-first)
- Fast loading times (<3s)
- HTTPS enabled
- Clean URL structure (no parameters, use hyphens)

## On-Page SEO
- One H1 per page with target keyword
- Hierarchical heading structure (H1 > H2 > H3)
- Keyword in first 100 words
- Internal linking to related pages
- Alt text on all images (descriptive, include keywords naturally)
- Minimum 500 words on main pages, 1000+ on blog articles

## Local SEO
- City/region name in titles, H1, and content
- "Near me" keyword variations
- Service area pages for each covered location
- Embed Google Maps (if applicable)
- NAP (Name, Address, Phone) consistent across site

## Content Quality
- Original, unique content (no duplicate)
- Answer user intent (informational, transactional, navigational)
- Include FAQs to target long-tail keywords
- Use natural language, avoid keyword stuffing
- Regular updates (blog, new services)
