# RGPD Compliance Guide for Lead Generation Websites

## Cookie Banner (Required)
- Display on first visit before any non-essential cookies are set
- Clear explanation of cookie usage
- Options to accept, refuse, or customize
- Link to detailed cookie policy
- Store consent in localStorage
- Do not block access to site if cookies refused

## Privacy Policy (Required)
- Data controller identity and contact
- Types of data collected (name, phone, email, IP, cookies)
- Purpose of data collection (lead generation, analytics, marketing)
- Legal basis for processing (consent, legitimate interest)
- Data retention period (e.g., 3 years for leads)
- Third-party data sharing (analytics, CRM, email marketing)
- User rights (access, rectification, deletion, portability, objection)
- How to exercise rights (contact email)
- Right to lodge complaint with supervisory authority

## Cookie Policy (Required)
- Explanation of what cookies are
- Types of cookies used:
  - **Essential**: Session, security, load balancing
  - **Analytics**: Google Analytics, Umami (anonymized)
  - **Marketing**: Facebook Pixel, Google Ads (with consent)
- How to manage cookies (browser settings)
- Link to privacy policy

## Legal Mentions (Required in France)
- Site editor (name, address, phone, email)
- Hosting provider (name, address)
- Publication director
- Disclaimer on service (mise en relation, not direct service provider)

## Forms and Consent
- Clear purpose statement before form
- Checkbox for consent to data processing (pre-unchecked)
- Link to privacy policy near form
- Confirmation message after submission
- Option to unsubscribe from communications

## Data Security
- HTTPS encryption
- Secure form submission
- Regular backups
- Access control to database
- Data breach notification procedure

## User Rights Implementation
- Email address for data requests (e.g., privacy@domain.com)
- Process to verify identity
- Response within 1 month
- Ability to export data (JSON/CSV)
- Ability to delete data (right to be forgotten)
