# Garde-fous anti-spam (Google Spam Policies + March 2024)

Objectif : éviter les patterns de sites leadgen qui se font déclasser (ou désindexer) en restant **white-hat**.

> Rappel : aucun SEO ne peut garantir un résultat. On s'engage sur des **process** (qualité, preuves, transparence), pas sur des positions.

## 1) Risques majeurs à surveiller (checklist)

### A. Doorway pages (pages « porte »)
**Risque** : pages quasi-identiques par ville/quartier qui ne servent qu'à capter du trafic.
- Signaux : mêmes sections, mêmes phrases, seul le nom de ville change
- Correction :
  - **1 seule page Zones d’intervention** riche (sections par communes, contenu réellement utile)
  - Pages service = **par intention/problème**, pas par ville
  - Si page ville nécessaire : elle doit contenir info locale non duplicable (photos réelles, cas, horaires spécifiques, preuves locales)

### B. Scaled content abuse (contenu scalé sans valeur)
**Risque** : production en masse de pages/articles génériques.
- Signaux : articles « 800 mots » sans données, sans exemples, sans réponses concrètes
- Correction :
  - 10 pages excellentes > 40 pages moyennes
  - Chaque page répond à une intention : symptômes, causes, checklists, coûts, erreurs à éviter
  - Ajout progressif de **preuves** (avis, photos, cas)

### C. Site reputation abuse / parasite SEO
**Risque** : publier du leadgen sur un domaine tiers « réputé » (sous-dossiers, partenariats opportunistes).
- Correction : domaine propre, marque claire, ownership clair

### D. Expired domain abuse
**Risque** : racheter un domaine expiré pour son jus et faire du leadgen.
- Correction : domaine neuf OU historique cohérent (même thématique), pas de rebranding opportuniste

## 2) Transparence leadgen (mise en relation)
Si le site est un **service de mise en relation** :
- Mention explicite dans : Accueil, pages service, Contact, Mentions/Confidentialité
- Ne pas laisser penser que l’entreprise est l’artisan qui intervient
- Expliquer :
  - rôle exact (qualification + mise en relation)
  - indépendance des partenaires
  - validation du prix avant intervention

## 3) Preuves : uniquement réelles
- Pas de faux avis
- Pas de fausses photos (utiliser placeholders clairement indiqués ou des images neutres)
- Pas de fausse adresse (éviter les “bureaux virtuels” présentés comme atelier)

## 4) Claims & copywriting (sécurité)
Interdit / risqué :
- « garanti », « le moins cher », « #1 », « intervention en 30 min garantie »
- promesses de délai irréalistes

OK si cadré :
- « réponse rapide », « selon disponibilité », « fourchettes indicatives », « prix annoncé avant intervention »

## 5) Modèle de page service “safe”
Chaque page service doit contenir (minimum) :
- Symptômes + causes + ce que l’utilisateur peut vérifier
- Process clair (3 étapes) + transparence
- Fourchettes + facteurs de variation
- FAQ spécifique (5–7)
- CTA WhatsApp/appel

## 6) Audit avant mise en ligne (30 min)
- Titles/meta/H1 uniques
- Aucune duplication massive (comparaison 2–3 pages au hasard)
- Mentions leadgen sur toutes pages clés
- Schema JSON-LD cohérent avec le texte affiché
- robots/sitemap/canonicals OK
