# Design Philosophy Examples for Lead Generation Websites

## Neo-Artisanat Digital (Craft + Modern)
**Movement**: Arts & Crafts meets Flat Design  
**Colors**: Warm neutrals (cream #F5F1E8, anthracite #2D2D2D), metallic accents (copper #B87333), natural tones (sage green #7A9B76)  
**Typography**: Serif for headings (Fraunces, Lora), humanist sans for body (DM Sans, Inter)  
**Layout**: Asymmetric grids, generous whitespace, organic shapes  
**Signature**: Soft multi-layer shadows, paper texture overlay, hand-drawn line art icons  
**Animation**: Gentle easing (0.3s ease-out), subtle hover lifts, smooth scrolling  
**Use case**: Artisan services, home improvement, local crafts

## Brutalist Confidence (Raw + Bold)
**Movement**: Brutalism + Swiss Design  
**Colors**: High contrast (black #000000, white #FFFFFF), bold accent (electric blue #0066FF)  
**Typography**: Mono for headings (Space Mono, Roboto Mono), grotesque sans for body (Helvetica, Arial)  
**Layout**: Grid-based, sharp edges, no rounded corners, overlapping elements  
**Signature**: Hard shadows, border outlines, exposed structure  
**Animation**: Instant transitions, no easing, abrupt state changes  
**Use case**: Tech services, industrial, B2B

## Soft Modernism (Calm + Professional)
**Movement**: Scandinavian Minimalism + Material Design  
**Colors**: Cool neutrals (light gray #F7F7F7, charcoal #333333), pastel accent (soft blue #6B9BD1)  
**Typography**: Geometric sans for headings (Montserrat, Poppins), humanist sans for body (Open Sans, Lato)  
**Layout**: Centered layouts, ample padding, card-based design  
**Signature**: Subtle gradients, soft shadows (0 2px 8px rgba(0,0,0,0.1)), rounded corners (8-16px)  
**Animation**: Smooth transitions (0.2s cubic-bezier), fade-ins, gentle parallax  
**Use case**: Healthcare, consulting, professional services

## Vibrant Energy (Playful + Dynamic)
**Movement**: Memphis Design + Gradient Maximalism  
**Colors**: Vibrant gradients (sunset #FF6B6B to #FFD93D, ocean #4ECDC4 to #556270)  
**Typography**: Display for headings (Fredoka, Righteous), rounded sans for body (Nunito, Quicksand)  
**Layout**: Diagonal sections, overlapping cards, dynamic angles  
**Signature**: Bold gradients, geometric shapes, colorful illustrations  
**Animation**: Bouncy easing (cubic-bezier(0.68, -0.55, 0.265, 1.55)), scale transforms, rotation  
**Use case**: Creative services, events, youth-oriented

## Luxury Minimalism (Elegant + Refined)
**Movement**: Luxury Branding + Japanese Minimalism  
**Colors**: Monochrome (off-white #FAFAFA, deep black #1A1A1A), metallic accent (gold #D4AF37)  
**Typography**: Elegant serif for headings (Playfair Display, Cormorant), refined sans for body (Raleway, Jost)  
**Layout**: Generous whitespace, centered content, large hero images  
**Signature**: Thin borders (1px), subtle hover effects, high-quality photography  
**Animation**: Slow transitions (0.6s ease-in-out), fade effects, smooth reveals  
**Use case**: Premium services, real estate, luxury goods

## Selection Criteria
- **Target audience**: Age, socioeconomic status, tech-savviness
- **Service type**: Artisan vs. tech, local vs. national, B2C vs. B2B
- **Brand personality**: Trustworthy, innovative, friendly, professional
- **Competitor analysis**: Differentiate from competitors' design choices
- **Conversion goals**: Lead form vs. phone call vs. WhatsApp
