# Conversion Best Practices for Lead Generation Websites

## Call-to-Action (CTA) Strategy
- **Multiple CTAs per page**: Header, hero section, end of content, sticky mobile buttons
- **Clear value proposition**: "Devis gratuit", "Intervention sous 24h", "Artisans qualifiés"
- **Action-oriented language**: "Appeler maintenant", "Demander un devis", "Contacter via WhatsApp"
- **Contrasting colors**: Use primary color for main CTA, outline for secondary
- **Size and placement**: Large buttons (min 44x44px), above the fold and at natural decision points

## Contact Options
- **Phone**: Click-to-call links (tel:) for mobile users
- **WhatsApp**: Pre-filled message with project context
- **Email**: Visible email address with mailto: link
- **Form**: Short form (name, phone, message) with UTM tracking

## Trust Signals
- **Testimonials**: Real customer reviews with names and photos
- **Certifications**: Display relevant qualifications, insurance
- **Social proof**: "500+ clients satisfaits", "Note 4.8/5"
- **Guarantees**: "Devis gratuit", "Intervention rapide", "Satisfaction garantie"

## Form Optimization
- **Minimal fields**: Only ask for essential information (name, phone, message)
- **Clear labels**: Use descriptive labels and placeholders
- **Validation**: Real-time validation with helpful error messages
- **Mobile-friendly**: Large input fields, easy to tap
- **UTM tracking**: Capture utm_source, utm_campaign, utm_adset, utm_ad from URL parameters

## Mobile Optimization
- **Sticky CTA buttons**: Fixed at bottom of screen on mobile
- **Click-to-call**: Prominent phone button in header
- **WhatsApp integration**: Native app opening on mobile
- **Fast loading**: Optimize images, minimize JS
- **Touch-friendly**: Buttons min 44x44px, adequate spacing

## Page Speed
- **Images**: Compress and use modern formats (WebP)
- **Code**: Minify CSS/JS, remove unused code
- **Caching**: Leverage browser caching
- **CDN**: Use CDN for static assets

## A/B Testing Ideas
- CTA button color and text
- Form length (short vs. detailed)
- Testimonial placement
- Hero image vs. video
- WhatsApp vs. phone priority
